/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.ui.internal.diagram.Message;
import org.eclipse.jsr220orm.ui.internal.diagram.MessageEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.model.DotDotDotColumn;
import org.eclipse.jsr220orm.ui.internal.diagram.er.model.TableSectionHeader;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ColumnEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ColumnListEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.DotDotDotColumnEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ErConnectionEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.RdbColumnEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.TableEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.TableSectionHeaderEditPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

/**
 * @author dirk
 */
public class ErGraphicalEditor extends ScrollingGraphicalViewer implements Adapter{

    private Set colSet = new HashSet();
    private boolean enabled;
    private Schema schema;
    private MetadataElement metadataElement;
    private ArrayList elements = new ArrayList();
    private IHelpTextHelper helper;

    public ErGraphicalEditor(Composite parent) {
//		org.eclipse.gef.editparts.AbstractGraphicalEditPart.createConnection(AbstractGraphicalEditPart.java:278)
		createControl(parent);
		getControl().setBackground(ColorConstants.white);
        setEditPartFactory(new EditPartFactory() {

            private ColumnListEditPart lastColList;

            public EditPart createEditPart(EditPart part, Object object) {
                if (object instanceof MetadataElement) {
//                    elements.add(object);
//                    MetadataElement element = (MetadataElement) object;
//                    element.eAdapters().add(ErGraphicalEditor.this);
                }
//				System.out.println("ErGraphicalEditor.ErGraphicalEditor()"+part.getClass().getName());
//				System.out.println("ErGraphicalEditor.ErGraphicalEditor()"+object.getClass().getName());
				if(object instanceof List){
					return lastColList = new ColumnListEditPart(object);
                }else if(object instanceof OrmTable){
                    return new TableEditPart(schema, colSet, (OrmTable)object, helper);
				}else if(object instanceof OrmColumn){
					return new ColumnEditPart(colSet, object);
				}else if(object instanceof JoinPair){
					return new ErConnectionEditPart(object, lastColList);
                }else if(object instanceof Column){
                    return new RdbColumnEditPart(object);
                }else if(object instanceof Message){
                    return new MessageEditPart(object);
                }else if(object instanceof DotDotDotColumn){
                    return new DotDotDotColumnEditPart(object);
                }else if(object instanceof TableSectionHeader){
                    return new TableSectionHeaderEditPart(object);
				}
				return null;
			}
		});
	}

    public void setMetaDataElement(MetadataElement metadataElement) {
        for(Iterator it = elements.iterator(); it.hasNext();){
            MetadataElement element = (MetadataElement) it.next();
            element.eAdapters().remove(ErGraphicalEditor.this);
        }
        elements.clear();
        this.metadataElement = metadataElement;
        List cols = getColumnsForElement(metadataElement);
        if(metadataElement != null){
            schema = (Schema) metadataElement.adapt(Schema.class);
        }
        colSet.clear();
        colSet.addAll(cols);
        setContents(cols);
        getControl().redraw();
    }
    
    /**
     * The list of OrmColumns to display on the live er diagrams
     */
    private List getColumnsForElement(MetadataElement element) {
        if(element == null){
            return Collections.EMPTY_LIST;
        }
        AttributeMetaData attribute = (AttributeMetaData) 
            element.getAncestor(AttributeMetaData.class);
        if(attribute != null){
            return attribute.getColumns();
        }
        EntityMetaData entity = (EntityMetaData) 
            element.getAncestor(EntityMetaData.class);
        if(entity != null){
            ArrayList cols = new ArrayList(); 
            OrmTable table = entity.getTable();
            if (table != null) {
                List columnList = table.getColumnList();
                if (columnList != null) {
                    cols.addAll(columnList);
                }
            }
            List joins = entity.getSecondaryTableJoinList();
            if(joins != null){
                for(Iterator it = joins.iterator(); it.hasNext();){
                    Join join = (Join) it.next();
                    OrmTable destTable = join.getDestTable();
                    if (destTable != null) {
                        List columnList = destTable.getColumnList();
                        if (columnList != null) {
                            cols.addAll(columnList);
                        }
                    }
                    OrmTable srcTable = join.getSrcTable();
                    if (srcTable != null) {
                        List columnList = srcTable.getColumnList();
                        if (columnList != null) {
                            cols.addAll(columnList);
                        }
                    }
                }
            }
            return cols;
        }
        return Collections.EMPTY_LIST;
    }

    public void notifyChanged(Notification notification) {
//        System.out.println("ErGraphicalEditor.notifyChanged(): "+notification.getEventType());
        if (notification.getEventType() != Notification.REMOVING_ADAPTER && 
                notification.getFeatureID(notification.getNotifier().getClass()) != Notification.NO_FEATURE_ID) {
            setMetaDataElement(metadataElement); 
        } 
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type == EntityMetaData.class || type == OrmTable.class || type == OrmColumn.class;
    }

    public Object getFirstModelObject() {
        try {
            List children = ((EditPart) getContents().getChildren().get(0))
                    .getChildren();
            for(Iterator it = children.iterator(); it.hasNext();){
                Object next = it.next();
                if(next instanceof ColumnEditPart){
                    return next;
                }
            }
        } catch (Exception e) {
            return null;
        }
        return null;
    }

    public void setIHelpTextHelper(IHelpTextHelper helper) {
        this.helper = helper;
        
    }
}

