/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class OrmUiPlugin extends AbstractUIPlugin {
	// The shared instance.
	private static OrmUiPlugin plugin;

	// Resource bundle.
	private ResourceBundle resourceBundle;

    private FormColors fFormColors;

    private static URL BASE_URL;
    public final static String ICONS_PATH = "icons/"; 

	/**
	 * The constructor.
	 */
	public OrmUiPlugin(IPluginDescriptor descriptor) {
        this();
	}

	/**
	 * The constructor.
	 */
	public OrmUiPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle
					.getBundle("org.eclipse.jsr220orm.ui.OrmUiPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static OrmUiPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle, or 'key' if not
	 * found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = OrmUiPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException)
            e = ((InvocationTargetException) e).getTargetException();
        IStatus status = null;
        if (e instanceof CoreException)
            status = ((CoreException) e).getStatus();
        else
            status =
                new Status(IStatus.ERROR, getPluginId(), IStatus.OK, e.getMessage(), e);
        log(status);
    }

    public static void logErrorMessage(String message) {
        log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, message, null));
    }

    public static void logException(Throwable e, String message, final Shell shell) {
        logException(e, "Unexpected Error", message, shell);
    }
    public static void logException(Throwable e, final String title, 
            String message, final Shell shell) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException) e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException)
            status = ((CoreException) e).getStatus();
        else {
            if (message == null)
                message = e.getMessage();
            if (message == null)
                message = e.toString();
            status = new Status(IStatus.ERROR, getPluginId(), IStatus.OK, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = getStandardDisplay();
        final IStatus fstatus = status;
        final String dialogMessage = message;
        display.asyncExec(new Runnable() {
            public void run() {
                ErrorDialog.openError(shell, title, dialogMessage, fstatus);
            }
        });
    }

    public static void logException(Throwable e, Shell shell) {
        logException(e, null, null, shell);
    }
//
//    public static void log(Shell shell, String title, String message, Throwable e, int severity) {
//        log(shell, title, new Status(severity, getPluginId(), 0, message, e));
//    }
//
//    public static void log(Shell shell, String title, CoreException e) {
//        log(shell, title, e.getStatus());
//    }
//    
//    public static void log(Shell shell, String title, IStatus status) {
//        getDefault().getLog().log(status);
////        if(status.getSeverity() == IStatus.ERROR && shell != null){
////            ErrorDialog.openError(shell, title, status.getMessage(), status);
////        }
//    }
   
    public static String getPluginId() {
        return getDefault().getBundle().getSymbolicName();
    }
    
    /**
     * Returns the standard display to be used. The method first checks, if
     * the thread calling this method has an associated disaply. If so, this
     * display is returned. Otherwise the method returns the default display.
     */
    public static Display getStandardDisplay() {
        Display display;
        display = Display.getCurrent();
        if (display == null)
            display = Display.getDefault();
        return display;
    }

    
    public FormColors getFormColors(Display display) {
        if (fFormColors == null && display != null) {
            fFormColors = new FormColors(display);
            fFormColors.markShared();
        }
        return fFormColors;
    }

    /**
     * Returns an image descriptor for the image file at the given
     * plug-in relative path.
     *
     * @param path the path
     * @return the image descriptor
     */
    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin(getPluginId(), path);
    }
}
