/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;

/**
 * Adds functionality to the AnnotatedElement interface.  
 */
public interface RAnnotatedElement extends AnnotatedElement {

	/**
	 * Returns this element's annotation for the specified type if
     * such an annotation is present. If returnDefault is true and the
     * annotation is not present then an instance that just provides the
     * default values for the annotation is returned. Otherwise null is
     * returned and this method is the same as calling 
     * {@link AnnotatedElement#getAnnotation(java.lang.Class)}.
	 */
	public <T extends Annotation> T getAnnotation(Class<T> annotationType, 
			boolean returnDefault);	
	
	/**
	 * Get the name of this element (e.g. field or method name). 
	 */
	public String getName();
	
	/**
	 * Get the type of this element (e.g. int, java.lang.String etc.). Note
	 * that some implementations may return unqualified names here e.g.
	 * String instead of java.lang.String. For fields this is the type of
	 * the field. For methods this is the return type.
	 */
	public String getTypeName();
	
	/**
	 * Is {@link #getTypeName()} an enum? 
	 */
	public boolean isTypeEnum();
	
	/**
	 * Is {@link #getTypeName()} serializable? 
	 */
	public boolean isTypeSerializable();
	
	/**
	 * Is this element a field?
	 */
	public boolean isField();
	
	/**
	 * Get location information about this element for reporting errors and
	 * so on.
	 */
	public Map getLocation();
	
	/**
	 * Get the class that owns us.
	 */
	public RClass getRClass();
	
	/**
	 * Get our modifiers {@link java.lang.reflect.Modifier}.
	 */
	public int getModifiers();
	
	/**
	 * If this is a field or method then return the parameterized type names
	 * for the field or the methods return type. Otherwise return null.
	 */
	public String[] getActualTypeArguments();
	
	/**
	 * Get this elements position relative to other elements of similar
	 * level in its owner.
	 */
	public int getRelativeIndexInOwner();
	
}
