/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.io.ast;

import java.util.Map;

import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.generic.reflect.RMethod;

/**
 * Implementation using an Eclipse AST tree to provide the data. 
 */
public class AstRMethod extends AstRAnnotatedElement implements RMethod {

	protected final AstRClass cls;
	protected final MethodDeclaration declaration;
	protected final ITypeBinding binding;
	
	public AstRMethod(AstRClass cls, MethodDeclaration declaration, 
			int relativeIndexInOwner) {
		super(cls.getFactory(), declaration.modifiers(), 
				cls.getImportListHelper(), relativeIndexInOwner);
		this.cls = cls;
		this.declaration = declaration;
		Type rt = declaration.getReturnType2();
		this.binding = rt == null ? null : rt.resolveBinding();
		initAnnotations();
	}

	public String getName() {
		return declaration.getName().getFullyQualifiedName();
	} 
	
	public String toString() {
		return getName();
	}

	public String getFullyQualifiedName() {
		return cls.getFullyQualifiedName() + "." + getName();
	}

	public String getTypeName() {
		return Utils.getTypeName(binding);
	}

	public boolean isField() {
		return false;
	}

	public Map getLocation() {
		return Utils.createMarkerLocation(declaration.getName());
	}

	public RClass getRClass() {
		return cls;
	}

	public String[] getActualTypeArguments() {
		if (binding == null) {
			return null;
		}
		ITypeBinding[] ta = binding.getTypeArguments();
		int n = ta.length;
		if (n == 0) {
			return null;
		}
		String[] ans = new String[n];
		for (int i = 0; i < n; i++) {
			ans[i] = Utils.getTypeName(ta[i]);
		}
		return ans;
	}

	public boolean hasNoParameters() {
		return declaration.parameters().isEmpty();
	}

}
