/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.internal.ui.config;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

/**
 * Our property page.
 */
public class GenericPropertyPage extends PropertyPage implements
		IWorkbenchPropertyPage {

	private GenericPropertyComposite propertyPage;

    public GenericPropertyPage() {
		super();
	}

	protected Control createContents(Composite parent) {
        propertyPage = new GenericPropertyComposite(parent, SWT.NONE);
        propertyPage.setIProject((IProject) getElement());
        return propertyPage;
	}

    @Override
    public boolean performOk() {
        return propertyPage.saveChanges();
    }

}
