/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.osgi.framework.Bundle;

public class PersistenceClasspathInitializer extends
        ClasspathContainerInitializer {

    protected static final String EJB3_PERSISTENCE = "EJB3_PERSISTENCE";

    public PersistenceClasspathInitializer() {
        super();
    }

    public void initialize(IPath containerPath, IJavaProject project)
            throws CoreException {
        Bundle bundle = GenericPlugin.getDefault().getBundle();
        String path = bundle.getEntry("/").toExternalForm();
        IClasspathEntry ejb3Persistence;
        IClasspathEntry parFileEntry;
        try {
            ejb3Persistence = JavaCore.newLibraryEntry(
                new Path(Platform.asLocalURL(new URL(path + "lib/ejb3-persistence.jar")).getPath()), null, null);
            IProject project2 = project.getProject();
            PersistenceProperties props = new PersistenceProperties(project2);
            String parFileName = props.getParFileName();
            IFile parIFile = project2.getFile(parFileName);
            IPath parPath = parIFile.getRawLocation();
            File parFile = new File(parPath.toOSString());
            if(!parFile.exists()){
                File parDir = parFile.getParentFile();
                if(!parDir.exists()){
                    parDir.mkdirs();
                }
                JarOutputStream jos = new JarOutputStream(
                        new FileOutputStream(parFile));
                JarEntry newEntry = new JarEntry(".");
                jos.putNextEntry(newEntry);
                jos.flush();
                jos.close();
                parIFile.refreshLocal(0, new NullProgressMonitor());
            }
            parFileEntry = JavaCore.newLibraryEntry(parIFile.getFullPath(), null, null); 
        } catch (Exception e) {
            IStatus status = new Status(IStatus.ERROR, bundle.getSymbolicName(), 0, 
                    "Problems adding ejb3-persistence.jar to casspath", e); 
            throw new CoreException(status);
        }
        final IClasspathEntry[] entries = new IClasspathEntry[] {ejb3Persistence, parFileEntry};
        IClasspathContainer container = new IClasspathContainer() {
            public IClasspathEntry[] getClasspathEntries() {
                return entries;
            }

            public String getDescription() {
                return "Generic EJB3 persistence";
            }

            public IPath getPath() {
                return new Path(EJB3_PERSISTENCE);
            }
        
            public int getKind() {
                return K_APPLICATION;
            }
        };
        JavaCore.setClasspathContainer(container.getPath(),
            new IJavaProject[] {project },
            new IClasspathContainer[] {container},
            null);
    }
}
