/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: ReferenceAttributeItemProvider.java,v 1.14 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;

/**
 * This is the item provider adapter for a {@link org.eclipse.jsr220orm.metadata.ReferenceAttribute} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ReferenceAttributeItemProvider
    extends AttributeMetaDataItemProvider
    implements	
        IEditingDomainItemProvider,	
        IStructuredItemContentProvider,	
        ITreeItemContentProvider,	
        IItemLabelProvider,	
        IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public ReferenceAttributeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addCascadeTypePropertyDescriptor(object);
			addJoinPropertyDescriptor(object);
			addOneToOnePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

    /**
     * This adds a property descriptor for the Cascade Type feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     */
    protected void addCascadeTypePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (new IntOptionDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_ReferenceAttribute_cascadeType_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_ReferenceAttribute_cascadeType_feature", "_UI_ReferenceAttribute_type"),
                 MetadataPackage.eINSTANCE.getReferenceAttribute_CascadeType(),
                 true,
                 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
	 * This adds a property descriptor for the Join feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addJoinPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ReferenceAttribute_join_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_ReferenceAttribute_join_feature", "_UI_ReferenceAttribute_type"),
				 MetadataPackage.eINSTANCE.getReferenceAttribute_Join(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the One To One feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addOneToOnePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ReferenceAttribute_oneToOne_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_ReferenceAttribute_oneToOne_feature", "_UI_ReferenceAttribute_type"),
				 MetadataPackage.eINSTANCE.getReferenceAttribute_OneToOne(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(MetadataPackage.eINSTANCE.getReferenceAttribute_Join());
		}
		return childrenFeatures;
	}

    public Object getImage(Object object) {
    	ReferenceAttribute amd = (ReferenceAttribute)object;
    	String s;
    	if (amd.isOneToOne()) {
    		s = "OneToOne16";
    	} else {
    		s = "ManyToOne16";
    	}
        return getResourceLocator().getImage("full/obj16/" + s);
    }

    public String getText(Object object) {
    	StringBuffer s = new StringBuffer();
    	s.append(super.getText(object));
    	ReferenceAttribute amd = (ReferenceAttribute)object;
    	AttributeMetaData mb = amd.getMappedBy();
    	if (mb != null) {
    		s.append(" : mapped by ");
    		s.append(mb.getName());
    	} else {
    		Join join = amd.getJoin();
    		if (join != null) {
    			s.append(" : ");
    			appendColumnNames(s, join.getSrcColumns());
    		}
    	}
    	return s.toString();
    }

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ReferenceAttribute.class)) {
			case MetadataPackage.REFERENCE_ATTRIBUTE__CASCADE_TYPE:
			case MetadataPackage.REFERENCE_ATTRIBUTE__ONE_TO_ONE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case MetadataPackage.REFERENCE_ATTRIBUTE__JOIN:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public ResourceLocator getResourceLocator() {
		return MetadataEditPlugin.INSTANCE;
	}

}
