/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.options.IIntOption;
import org.eclipse.jsr220orm.core.options.IOptionsDescriptor;
import org.eclipse.jsr220orm.metadata.MetadataElement;

public class IntOptionDescriptor extends ItemPropertyDescriptor {

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category, String[] filterFlags) {
        super(adapterFactory, resourceLocator, displayName, description,
                parentReferences, isSettable, category, filterFlags);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category) {
        super(adapterFactory, resourceLocator, displayName, description,
                parentReferences, isSettable, category);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable) {
        super(adapterFactory, resourceLocator, displayName, description,
                parentReferences, isSettable);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences) {
        super(adapterFactory, resourceLocator, displayName, description,
                parentReferences);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category, String[] filterFlags) {
        super(adapterFactory, resourceLocator, displayName, description, feature,
                isSettable, staticImage, category, filterFlags);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category) {
        super(adapterFactory, resourceLocator, displayName, description, feature,
                isSettable, staticImage, category);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage) {
        super(adapterFactory, resourceLocator, displayName, description, feature,
                isSettable, staticImage);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category, String[] filterFlags) {
        super(adapterFactory, resourceLocator, displayName, description, feature,
                isSettable, category, filterFlags);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category) {
        super(adapterFactory, resourceLocator, displayName, description, feature,
                isSettable, category);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable) {
        super(adapterFactory, resourceLocator, displayName, description, feature,
                isSettable);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature) {
        super(adapterFactory, resourceLocator, displayName, description, feature);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category, String[] filterFlags) {
        super(adapterFactory, displayName, description, parentReferences, isSettable,
                category, filterFlags);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category) {
        super(adapterFactory, displayName, description, parentReferences, isSettable,
                category);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable) {
        super(adapterFactory, displayName, description, parentReferences, isSettable);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences) {
        super(adapterFactory, displayName, description, parentReferences);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category, String[] filterFlags) {
        super(adapterFactory, displayName, description, feature, isSettable,
                staticImage, category, filterFlags);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category) {
        super(adapterFactory, displayName, description, feature, isSettable,
                staticImage, category);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage) {
        super(adapterFactory, displayName, description, feature, isSettable,
                staticImage);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category, String[] filterFlags) {
        super(adapterFactory, displayName, description, feature, isSettable, category,
                filterFlags);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category) {
        super(adapterFactory, displayName, description, feature, isSettable, category);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable) {
        super(adapterFactory, displayName, description, feature, isSettable);
    }

    public IntOptionDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature) {
        super(adapterFactory, displayName, description, feature);
    }

    public Collection getComboBoxObjects(Object object) {
        if(object instanceof MetadataElement){
            try {
                MetadataElement element = (MetadataElement) object;
                IEntityModelManager modelManager = (IEntityModelManager) element.adapt(IEntityModelManager.class);
                if(modelManager != null){
                    Method method = modelManager.getClass().getMethod(getMethodName(), 
                            new Class[]{feature.getContainerClass()});
                    int[] validOptions = (int[]) method.invoke(modelManager, new Object[]{element});
                    ArrayList list = new ArrayList(validOptions.length);
                    for(int x = 0; x < validOptions.length; x++){
                        list.add(new Integer(validOptions[x]));
                    }
                    return list;
                }
            } catch (Exception e) {
                MetadataEditPlugin.getPlugin().log(e);
            }
       }
        return super.getComboBoxObjects(object);
    }

    private String getMethodName() {
        String name = feature.getName();
        name = Character.toUpperCase(name.charAt(0))+name.substring(1);
        return "getValid"+name+"s";
    }

    public IItemLabelProvider getLabelProvider(Object object) {
        final String key = feature.getContainerClass().getName()+"."+feature.getName();
        if(object instanceof MetadataElement){
            try {
                MetadataElement element = (MetadataElement) object;
                IOptionsDescriptor options = (IOptionsDescriptor) element.adapt(IOptionsDescriptor.class);
                if(options != null){
                    final Map allOptions = options.getOptions(feature.getContainerClass(), feature.getName());
                    if(allOptions != null){
                        return new IItemLabelProvider() {
                        
                            public Object getImage(Object object) {
                                IIntOption option = (IIntOption) allOptions.get(object);
                                if (option != null) {
                                    return option.getImage();
                                }else{
    //                                MetadataEditPlugin.getPlugin().log("No image found for: "+key+" value: "+object);
                                    return null;
                                }
                            }
                        
                            public String getText(Object object) {
                                IIntOption option = (IIntOption) allOptions.get(object);
                                if (option != null) {
                                    return option.getText();
                                }else{
    //                                MetadataEditPlugin.getPlugin().log("No description found for: "+key+" value: "+object);
                                    return object.toString();
                                }
                            }
                        
                        };
                    }
                }
            } catch (Exception e) {
                MetadataEditPlugin.getPlugin().log(e);
            }
        }
//        MetadataEditPlugin.getPlugin().log("No descriptions found for: "+key);
        return super.getLabelProvider(object);
    }

}
