/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: EntityMetaDataItemProvider.java,v 1.17 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataFactory;
import org.eclipse.jsr220orm.metadata.MetadataPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.jsr220orm.metadata.EntityMetaData} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class EntityMetaDataItemProvider
  extends TypeMetaDataItemProvider
  implements	
    IEditingDomainItemProvider,	
    IStructuredItemContentProvider,	
    ITreeItemContentProvider,	
    IItemLabelProvider,	
    IItemPropertySource		
{
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public EntityMetaDataItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addEntityTypePropertyDescriptor(object);
			addSchemaNamePropertyDescriptor(object);
			addSuperEntityPropertyDescriptor(object);
			addSubEntityListPropertyDescriptor(object);
			addAttributeListPropertyDescriptor(object);
			addPrimaryKeyListPropertyDescriptor(object);
			addVersionListPropertyDescriptor(object);
			addIdGeneratorTypePropertyDescriptor(object);
			addIdGeneratorNamePropertyDescriptor(object);
			addIdClassPropertyDescriptor(object);
			addTablePropertyDescriptor(object);
			addSecondaryTableJoinListPropertyDescriptor(object);
			addAccessTypePropertyDescriptor(object);
			addInheritancePropertyDescriptor(object);
			addInheritanceSpecifiedPropertyDescriptor(object);
			addDiscriminatorTypePropertyDescriptor(object);
			addDiscriminatorValuePropertyDescriptor(object);
			addDiscriminatorColumnPropertyDescriptor(object);
			addSuperJoinPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Entity Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addEntityTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_entityType_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_entityType_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_EntityType(),
				 true,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Schema Name feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addSchemaNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_schemaName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_schemaName_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_SchemaName(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Super Entity feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addSuperEntityPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_superEntity_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_superEntity_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_SuperEntity(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Sub Entity List feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addSubEntityListPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_subEntityList_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_subEntityList_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_SubEntityList(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Attribute List feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addAttributeListPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_attributeList_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_attributeList_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_AttributeList(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Primary Key List feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addPrimaryKeyListPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_primaryKeyList_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_primaryKeyList_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_PrimaryKeyList(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Version List feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addVersionListPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_versionList_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_versionList_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_VersionList(),
				 true,
				 null,
				 null,
				 null));
	}

    /**
     * This adds a property descriptor for the Id Generator Type feature.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     */
  protected void addIdGeneratorTypePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (new IntOptionDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_EntityMetaData_idGeneratorType_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_idGeneratorType_feature", "_UI_EntityMetaData_type"),
                 MetadataPackage.eINSTANCE.getEntityMetaData_IdGeneratorType(),
                 true,
                 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
	 * This adds a property descriptor for the Id Generator Name feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addIdGeneratorNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_idGeneratorName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_idGeneratorName_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_IdGeneratorName(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Id Class feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addIdClassPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_idClass_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_idClass_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_IdClass(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Table feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addTablePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_table_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_table_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_Table(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Secondary Table Join List feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addSecondaryTableJoinListPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_secondaryTableJoinList_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_secondaryTableJoinList_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_SecondaryTableJoinList(),
				 true,
				 null,
				 null,
				 null));
	}

    /**
     * This adds a property descriptor for the Access Type feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     */
    protected void addAccessTypePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (new IntOptionDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_EntityMetaData_accessType_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_accessType_feature", "_UI_EntityMetaData_type"),
                 MetadataPackage.eINSTANCE.getEntityMetaData_AccessType(),
                 true,
                 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
	 * This adds a property descriptor for the Inheritance feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	protected void addInheritancePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new IntOptionDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_inheritance_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_inheritance_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_Inheritance(),
				 true,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Inheritance Specified feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInheritanceSpecifiedPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_inheritanceSpecified_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_inheritanceSpecified_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_InheritanceSpecified(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Discriminator Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDiscriminatorTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_discriminatorType_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_discriminatorType_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_DiscriminatorType(),
				 true,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Discriminator Value feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDiscriminatorValuePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_discriminatorValue_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_discriminatorValue_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_DiscriminatorValue(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Discriminator Column feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDiscriminatorColumnPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_discriminatorColumn_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_discriminatorColumn_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_DiscriminatorColumn(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Super Join feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSuperJoinPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_EntityMetaData_superJoin_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_EntityMetaData_superJoin_feature", "_UI_EntityMetaData_type"),
				 MetadataPackage.eINSTANCE.getEntityMetaData_SuperJoin(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_SuperEntity());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_SubEntityList());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_AttributeList());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_PrimaryKeyList());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_VersionList());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_Table());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_SecondaryTableJoinList());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_DiscriminatorColumn());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getEntityMetaData_SuperJoin());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

    public Object getImage(Object object) {
    	EntityMetaData emd = (EntityMetaData)object;
    	String s;
    	switch (emd.getEntityType()) {
    	case EntityMetaData.TYPE_EMBEDDABLE:
    		s = "Embedded16";
    		break;
    	case EntityMetaData.TYPE_EMBEDDABLE_SUPERCLASS:
    		s = "EmbeddableSuperclass16";
    		break;
    	default:
        	if (emd.isBaseEntity()) {
        		if (emd.hasSubEntities()) {
        			s = "TreeClassBase16";
        		} else {
        			s = "TreeClass16";
        		}
        	} else if (emd.hasSubEntities()) {
    			s = "TreeClassMiddle16";
    		} else {
    			s = "TreeClassLeaf16";
    		}
    		break;
    	}    	
    	return getResourceLocator().getImage("full/obj16/" + s);
    }

    public String getText(Object object) {
    	EntityMetaData emd = (EntityMetaData)object;
    	String s = emd.getSchemaName();
    	if (s == null || s.length() == 0) {
    		s = emd.getClassName();
    		if (s == null || s.length() == 0) {
    			s = "Entity(unnamed)";
    		}
    	}
    	return s;
    }

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(EntityMetaData.class)) {
			case MetadataPackage.ENTITY_META_DATA__ENTITY_TYPE:
			case MetadataPackage.ENTITY_META_DATA__SCHEMA_NAME:
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_TYPE:
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_NAME:
			case MetadataPackage.ENTITY_META_DATA__ID_CLASS:
			case MetadataPackage.ENTITY_META_DATA__ACCESS_TYPE:
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE:
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE_SPECIFIED:
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_TYPE:
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_VALUE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY:
			case MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST:
			case MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST:
			case MetadataPackage.ENTITY_META_DATA__PRIMARY_KEY_LIST:
			case MetadataPackage.ENTITY_META_DATA__VERSION_LIST:
			case MetadataPackage.ENTITY_META_DATA__TABLE:
			case MetadataPackage.ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST:
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN:
			case MetadataPackage.ENTITY_META_DATA__SUPER_JOIN:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(MetadataPackage.eINSTANCE.getEntityMetaData_AttributeList(),
				 MetadataFactory.eINSTANCE.createCollectionAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(MetadataPackage.eINSTANCE.getEntityMetaData_AttributeList(),
				 MetadataFactory.eINSTANCE.createMapAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(MetadataPackage.eINSTANCE.getEntityMetaData_AttributeList(),
				 MetadataFactory.eINSTANCE.createBasicAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(MetadataPackage.eINSTANCE.getEntityMetaData_AttributeList(),
				 MetadataFactory.eINSTANCE.createReferenceAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(MetadataPackage.eINSTANCE.getEntityMetaData_AttributeList(),
				 MetadataFactory.eINSTANCE.createEmbeddedAttribute()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public ResourceLocator getResourceLocator() {
		return MetadataEditPlugin.INSTANCE;
	}

}
