/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MetadataSwitch.java,v 1.15 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jsr220orm.metadata.*;

import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.CollectionTypeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.JdoEntity;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MapAttribute;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.SimpleTypeMetaData;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * @see org.eclipse.jsr220orm.metadata.MetadataPackage
 * @generated
 */
public class MetadataSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static MetadataPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public MetadataSwitch() {
		if (modelPackage == null) {
			modelPackage = MetadataPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case MetadataPackage.ATTRIBUTE_META_DATA: {
				AttributeMetaData attributeMetaData = (AttributeMetaData)theEObject;
				Object result = caseAttributeMetaData(attributeMetaData);
				if (result == null) result = caseMetadataElement(attributeMetaData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.COLLECTION_ATTRIBUTE: {
				CollectionAttribute collectionAttribute = (CollectionAttribute)theEObject;
				Object result = caseCollectionAttribute(collectionAttribute);
				if (result == null) result = caseAttributeMetaData(collectionAttribute);
				if (result == null) result = caseMetadataElement(collectionAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.ENTITY_META_DATA: {
				EntityMetaData entityMetaData = (EntityMetaData)theEObject;
				Object result = caseEntityMetaData(entityMetaData);
				if (result == null) result = caseTypeMetaData(entityMetaData);
				if (result == null) result = caseMetadataElement(entityMetaData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.ENTITY_MODEL: {
				EntityModel entityModel = (EntityModel)theEObject;
				Object result = caseEntityModel(entityModel);
				if (result == null) result = caseMetadataElement(entityModel);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.JDO_ENTITY: {
				JdoEntity jdoEntity = (JdoEntity)theEObject;
				Object result = caseJdoEntity(jdoEntity);
				if (result == null) result = caseEntityMetaData(jdoEntity);
				if (result == null) result = caseTypeMetaData(jdoEntity);
				if (result == null) result = caseMetadataElement(jdoEntity);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.MAP_ATTRIBUTE: {
				MapAttribute mapAttribute = (MapAttribute)theEObject;
				Object result = caseMapAttribute(mapAttribute);
				if (result == null) result = caseAttributeMetaData(mapAttribute);
				if (result == null) result = caseMetadataElement(mapAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.METADATA_ELEMENT: {
				MetadataElement metadataElement = (MetadataElement)theEObject;
				Object result = caseMetadataElement(metadataElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.TYPE_META_DATA: {
				TypeMetaData typeMetaData = (TypeMetaData)theEObject;
				Object result = caseTypeMetaData(typeMetaData);
				if (result == null) result = caseMetadataElement(typeMetaData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.BASIC_ATTRIBUTE: {
				BasicAttribute basicAttribute = (BasicAttribute)theEObject;
				Object result = caseBasicAttribute(basicAttribute);
				if (result == null) result = caseAttributeMetaData(basicAttribute);
				if (result == null) result = caseMetadataElement(basicAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.REFERENCE_ATTRIBUTE: {
				ReferenceAttribute referenceAttribute = (ReferenceAttribute)theEObject;
				Object result = caseReferenceAttribute(referenceAttribute);
				if (result == null) result = caseAttributeMetaData(referenceAttribute);
				if (result == null) result = caseMetadataElement(referenceAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.JOIN: {
				Join join = (Join)theEObject;
				Object result = caseJoin(join);
				if (result == null) result = caseMetadataElement(join);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.JOIN_PAIR: {
				JoinPair joinPair = (JoinPair)theEObject;
				Object result = caseJoinPair(joinPair);
				if (result == null) result = caseMetadataElement(joinPair);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.ORM_COLUMN: {
				OrmColumn ormColumn = (OrmColumn)theEObject;
				Object result = caseOrmColumn(ormColumn);
				if (result == null) result = caseMetadataElement(ormColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.ORM_TABLE: {
				OrmTable ormTable = (OrmTable)theEObject;
				Object result = caseOrmTable(ormTable);
				if (result == null) result = caseMetadataElement(ormTable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.SIMPLE_TYPE_META_DATA: {
				SimpleTypeMetaData simpleTypeMetaData = (SimpleTypeMetaData)theEObject;
				Object result = caseSimpleTypeMetaData(simpleTypeMetaData);
				if (result == null) result = caseTypeMetaData(simpleTypeMetaData);
				if (result == null) result = caseMetadataElement(simpleTypeMetaData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.COLLECTION_TYPE_META_DATA: {
				CollectionTypeMetaData collectionTypeMetaData = (CollectionTypeMetaData)theEObject;
				Object result = caseCollectionTypeMetaData(collectionTypeMetaData);
				if (result == null) result = caseTypeMetaData(collectionTypeMetaData);
				if (result == null) result = caseMetadataElement(collectionTypeMetaData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MetadataPackage.EMBEDDED_ATTRIBUTE: {
				EmbeddedAttribute embeddedAttribute = (EmbeddedAttribute)theEObject;
				Object result = caseEmbeddedAttribute(embeddedAttribute);
				if (result == null) result = caseAttributeMetaData(embeddedAttribute);
				if (result == null) result = caseMetadataElement(embeddedAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Attribute Meta Data</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Attribute Meta Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAttributeMetaData(AttributeMetaData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Collection Attribute</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Collection Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCollectionAttribute(CollectionAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Entity Meta Data</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Entity Meta Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEntityMetaData(EntityMetaData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Entity Model</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Entity Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEntityModel(EntityModel object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Jdo Entity</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Jdo Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseJdoEntity(JdoEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Map Attribute</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Map Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseMapAttribute(MapAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Element</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseMetadataElement(MetadataElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Type Meta Data</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Type Meta Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTypeMetaData(TypeMetaData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Basic Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Basic Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBasicAttribute(BasicAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Reference Attribute</em>'.
	 * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Reference Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
    public Object caseReferenceAttribute(ReferenceAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Join</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Join</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseJoin(Join object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Join Pair</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Join Pair</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseJoinPair(JoinPair object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Orm Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Orm Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOrmColumn(OrmColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Orm Table</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Orm Table</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOrmTable(OrmTable object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Simple Type Meta Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Simple Type Meta Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSimpleTypeMetaData(SimpleTypeMetaData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Collection Type Meta Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Collection Type Meta Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCollectionTypeMetaData(CollectionTypeMetaData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Embedded Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Embedded Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEmbeddedAttribute(EmbeddedAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc --> This implementation returns null; returning a
	 * non-null result will terminate the switch, but this is the last case
	 * anyway. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} // MetadataSwitch
