/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MetadataPackageImpl.java,v 1.16 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.CollectionTypeMetaData;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.JdoEntity;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MapAttribute;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataFactory;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.SimpleTypeMetaData;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MetadataPackageImpl extends EPackageImpl implements MetadataPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass attributeMetaDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass collectionAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass entityMetaDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass entityModelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass jdoEntityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mapAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass metadataElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeMetaDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass basicAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass referenceAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass joinEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass joinPairEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ormColumnEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ormTableEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass simpleTypeMetaDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass collectionTypeMetaDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass embeddedAttributeEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.jsr220orm.metadata.MetadataPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private MetadataPackageImpl() {
		super(eNS_URI, MetadataFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static MetadataPackage init() {
		if (isInited) return (MetadataPackage)EPackage.Registry.INSTANCE.getEPackage(MetadataPackage.eNS_URI);

		// Obtain or create and register package
		MetadataPackageImpl theMetadataPackage = (MetadataPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof MetadataPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new MetadataPackageImpl());

		isInited = true;

		// Create package meta-data objects
		theMetadataPackage.createPackageContents();

		// Initialize created meta-data
		theMetadataPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theMetadataPackage.freeze();

		return theMetadataPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAttributeMetaData() {
		return attributeMetaDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAttributeMetaData_EntityMetaData() {
		return (EReference)attributeMetaDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAttributeMetaData_EmbeddedIn() {
		return (EReference)attributeMetaDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeMetaData_Name() {
		return (EAttribute)attributeMetaDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAttributeMetaData_JavaType() {
		return (EReference)attributeMetaDataEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeMetaData_FetchType() {
		return (EAttribute)attributeMetaDataEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeMetaData_Optional() {
		return (EAttribute)attributeMetaDataEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeMetaData_GetterMethodName() {
		return (EAttribute)attributeMetaDataEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeMetaData_SetterMethodName() {
		return (EAttribute)attributeMetaDataEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAttributeMetaData_MappedBy() {
		return (EReference)attributeMetaDataEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAttributeMetaData_InverseList() {
		return (EReference)attributeMetaDataEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAttributeMetaData_OverrideOf() {
		return (EReference)attributeMetaDataEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAttributeMetaData_OverrideList() {
		return (EReference)attributeMetaDataEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCollectionAttribute() {
		return collectionAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCollectionAttribute_ElementType() {
		return (EReference)collectionAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCollectionAttribute_JoinTable() {
		return (EReference)collectionAttributeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCollectionAttribute_SrcJoin() {
		return (EReference)collectionAttributeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCollectionAttribute_DestJoin() {
		return (EReference)collectionAttributeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCollectionAttribute_CascadeType() {
		return (EAttribute)collectionAttributeEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCollectionAttribute_OrderBy() {
		return (EAttribute)collectionAttributeEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCollectionAttribute_OneToMany() {
		return (EAttribute)collectionAttributeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEntityMetaData() {
		return entityMetaDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_EntityType() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_SchemaName() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_SuperEntity() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_SubEntityList() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_AttributeList() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_PrimaryKeyList() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_VersionList() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_IdGeneratorType() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_IdGeneratorName() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_IdClass() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_Table() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_SecondaryTableJoinList() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_AccessType() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_Inheritance() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_InheritanceSpecified() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_DiscriminatorType() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(15);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEntityMetaData_DiscriminatorValue() {
		return (EAttribute)entityMetaDataEClass.getEStructuralFeatures().get(16);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_DiscriminatorColumn() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(17);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityMetaData_SuperJoin() {
		return (EReference)entityMetaDataEClass.getEStructuralFeatures().get(18);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEntityModel() {
		return entityModelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEntityModel_TypeList() {
		return (EReference)entityModelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getJdoEntity() {
		return jdoEntityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getJdoEntity_IdentityType() {
		return (EAttribute)jdoEntityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMapAttribute() {
		return mapAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMapAttribute_KeyType() {
		return (EReference)mapAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMapAttribute_ValueType() {
		return (EReference)mapAttributeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMetadataElement() {
		return metadataElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypeMetaData() {
		return typeMetaDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypeMetaData_EntityModel() {
		return (EReference)typeMetaDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTypeMetaData_ClassName() {
		return (EAttribute)typeMetaDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTypeMetaData_Cls() {
		return (EAttribute)typeMetaDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBasicAttribute() {
		return basicAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBasicAttribute_Column() {
		return (EReference)basicAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getReferenceAttribute() {
		return referenceAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getReferenceAttribute_CascadeType() {
		return (EAttribute)referenceAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getReferenceAttribute_Join() {
		return (EReference)referenceAttributeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getReferenceAttribute_OneToOne() {
		return (EAttribute)referenceAttributeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getJoin() {
		return joinEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getJoin_PairList() {
		return (EReference)joinEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getJoin_Comment() {
		return (EAttribute)joinEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getJoinPair() {
		return joinPairEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getJoinPair_Join() {
		return (EReference)joinPairEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getJoinPair_Src() {
		return (EReference)joinPairEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getJoinPair_Dest() {
		return (EReference)joinPairEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOrmColumn() {
		return ormColumnEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrmColumn_Table() {
		return (EReference)ormColumnEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Name() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_JdbcType() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Nullable() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Insertable() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Updatable() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Length() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Scale() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_ColumnDefinition() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_ColumnDefinitionSpecified() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrmColumn_SrcJoinPairs() {
		return (EReference)ormColumnEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrmColumn_DestJoinPairs() {
		return (EReference)ormColumnEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_DatabaseType() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Comment() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_OriginalColumnDefinition() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_RelativePositionInTable() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(15);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmColumn_Identity() {
		return (EAttribute)ormColumnEClass.getEStructuralFeatures().get(16);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOrmTable() {
		return ormTableEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmTable_Name() {
		return (EAttribute)ormTableEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmTable_Catalog() {
		return (EAttribute)ormTableEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmTable_Schema() {
		return (EAttribute)ormTableEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrmTable_ColumnList() {
		return (EReference)ormTableEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrmTable_ParentElement() {
		return (EReference)ormTableEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmTable_Comment() {
		return (EAttribute)ormTableEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrmTable_PrimaryKeyList() {
		return (EReference)ormTableEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrmTable_Virtual() {
		return (EAttribute)ormTableEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSimpleTypeMetaData() {
		return simpleTypeMetaDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSimpleTypeMetaData_Column() {
		return (EReference)simpleTypeMetaDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCollectionTypeMetaData() {
		return collectionTypeMetaDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEmbeddedAttribute() {
		return embeddedAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEmbeddedAttribute_AttributeList() {
		return (EReference)embeddedAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetadataFactory getMetadataFactory() {
		return (MetadataFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		attributeMetaDataEClass = createEClass(ATTRIBUTE_META_DATA);
		createEReference(attributeMetaDataEClass, ATTRIBUTE_META_DATA__ENTITY_META_DATA);
		createEReference(attributeMetaDataEClass, ATTRIBUTE_META_DATA__EMBEDDED_IN);
		createEAttribute(attributeMetaDataEClass, ATTRIBUTE_META_DATA__NAME);
		createEReference(attributeMetaDataEClass, ATTRIBUTE_META_DATA__JAVA_TYPE);
		createEAttribute(attributeMetaDataEClass, ATTRIBUTE_META_DATA__FETCH_TYPE);
		createEAttribute(attributeMetaDataEClass, ATTRIBUTE_META_DATA__OPTIONAL);
		createEAttribute(attributeMetaDataEClass, ATTRIBUTE_META_DATA__GETTER_METHOD_NAME);
		createEAttribute(attributeMetaDataEClass, ATTRIBUTE_META_DATA__SETTER_METHOD_NAME);
		createEReference(attributeMetaDataEClass, ATTRIBUTE_META_DATA__MAPPED_BY);
		createEReference(attributeMetaDataEClass, ATTRIBUTE_META_DATA__INVERSE_LIST);
		createEReference(attributeMetaDataEClass, ATTRIBUTE_META_DATA__OVERRIDE_OF);
		createEReference(attributeMetaDataEClass, ATTRIBUTE_META_DATA__OVERRIDE_LIST);

		collectionAttributeEClass = createEClass(COLLECTION_ATTRIBUTE);
		createEReference(collectionAttributeEClass, COLLECTION_ATTRIBUTE__ELEMENT_TYPE);
		createEAttribute(collectionAttributeEClass, COLLECTION_ATTRIBUTE__ONE_TO_MANY);
		createEReference(collectionAttributeEClass, COLLECTION_ATTRIBUTE__JOIN_TABLE);
		createEReference(collectionAttributeEClass, COLLECTION_ATTRIBUTE__SRC_JOIN);
		createEReference(collectionAttributeEClass, COLLECTION_ATTRIBUTE__DEST_JOIN);
		createEAttribute(collectionAttributeEClass, COLLECTION_ATTRIBUTE__CASCADE_TYPE);
		createEAttribute(collectionAttributeEClass, COLLECTION_ATTRIBUTE__ORDER_BY);

		entityMetaDataEClass = createEClass(ENTITY_META_DATA);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__ENTITY_TYPE);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__SCHEMA_NAME);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__SUPER_ENTITY);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__SUB_ENTITY_LIST);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__ATTRIBUTE_LIST);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__PRIMARY_KEY_LIST);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__VERSION_LIST);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__ID_GENERATOR_TYPE);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__ID_GENERATOR_NAME);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__ID_CLASS);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__TABLE);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__ACCESS_TYPE);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__INHERITANCE);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__INHERITANCE_SPECIFIED);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__DISCRIMINATOR_TYPE);
		createEAttribute(entityMetaDataEClass, ENTITY_META_DATA__DISCRIMINATOR_VALUE);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__DISCRIMINATOR_COLUMN);
		createEReference(entityMetaDataEClass, ENTITY_META_DATA__SUPER_JOIN);

		entityModelEClass = createEClass(ENTITY_MODEL);
		createEReference(entityModelEClass, ENTITY_MODEL__TYPE_LIST);

		jdoEntityEClass = createEClass(JDO_ENTITY);
		createEAttribute(jdoEntityEClass, JDO_ENTITY__IDENTITY_TYPE);

		mapAttributeEClass = createEClass(MAP_ATTRIBUTE);
		createEReference(mapAttributeEClass, MAP_ATTRIBUTE__KEY_TYPE);
		createEReference(mapAttributeEClass, MAP_ATTRIBUTE__VALUE_TYPE);

		metadataElementEClass = createEClass(METADATA_ELEMENT);

		typeMetaDataEClass = createEClass(TYPE_META_DATA);
		createEReference(typeMetaDataEClass, TYPE_META_DATA__ENTITY_MODEL);
		createEAttribute(typeMetaDataEClass, TYPE_META_DATA__CLASS_NAME);
		createEAttribute(typeMetaDataEClass, TYPE_META_DATA__CLS);

		basicAttributeEClass = createEClass(BASIC_ATTRIBUTE);
		createEReference(basicAttributeEClass, BASIC_ATTRIBUTE__COLUMN);

		referenceAttributeEClass = createEClass(REFERENCE_ATTRIBUTE);
		createEAttribute(referenceAttributeEClass, REFERENCE_ATTRIBUTE__CASCADE_TYPE);
		createEReference(referenceAttributeEClass, REFERENCE_ATTRIBUTE__JOIN);
		createEAttribute(referenceAttributeEClass, REFERENCE_ATTRIBUTE__ONE_TO_ONE);

		joinEClass = createEClass(JOIN);
		createEReference(joinEClass, JOIN__PAIR_LIST);
		createEAttribute(joinEClass, JOIN__COMMENT);

		joinPairEClass = createEClass(JOIN_PAIR);
		createEReference(joinPairEClass, JOIN_PAIR__JOIN);
		createEReference(joinPairEClass, JOIN_PAIR__SRC);
		createEReference(joinPairEClass, JOIN_PAIR__DEST);

		ormColumnEClass = createEClass(ORM_COLUMN);
		createEReference(ormColumnEClass, ORM_COLUMN__TABLE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__NAME);
		createEAttribute(ormColumnEClass, ORM_COLUMN__JDBC_TYPE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__NULLABLE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__INSERTABLE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__UPDATABLE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__LENGTH);
		createEAttribute(ormColumnEClass, ORM_COLUMN__SCALE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__COLUMN_DEFINITION);
		createEAttribute(ormColumnEClass, ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED);
		createEAttribute(ormColumnEClass, ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION);
		createEReference(ormColumnEClass, ORM_COLUMN__SRC_JOIN_PAIRS);
		createEReference(ormColumnEClass, ORM_COLUMN__DEST_JOIN_PAIRS);
		createEAttribute(ormColumnEClass, ORM_COLUMN__DATABASE_TYPE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__COMMENT);
		createEAttribute(ormColumnEClass, ORM_COLUMN__RELATIVE_POSITION_IN_TABLE);
		createEAttribute(ormColumnEClass, ORM_COLUMN__IDENTITY);

		ormTableEClass = createEClass(ORM_TABLE);
		createEAttribute(ormTableEClass, ORM_TABLE__NAME);
		createEAttribute(ormTableEClass, ORM_TABLE__CATALOG);
		createEAttribute(ormTableEClass, ORM_TABLE__SCHEMA);
		createEReference(ormTableEClass, ORM_TABLE__COLUMN_LIST);
		createEReference(ormTableEClass, ORM_TABLE__PARENT_ELEMENT);
		createEAttribute(ormTableEClass, ORM_TABLE__COMMENT);
		createEReference(ormTableEClass, ORM_TABLE__PRIMARY_KEY_LIST);
		createEAttribute(ormTableEClass, ORM_TABLE__VIRTUAL);

		simpleTypeMetaDataEClass = createEClass(SIMPLE_TYPE_META_DATA);
		createEReference(simpleTypeMetaDataEClass, SIMPLE_TYPE_META_DATA__COLUMN);

		collectionTypeMetaDataEClass = createEClass(COLLECTION_TYPE_META_DATA);

		embeddedAttributeEClass = createEClass(EMBEDDED_ATTRIBUTE);
		createEReference(embeddedAttributeEClass, EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Add supertypes to classes
		attributeMetaDataEClass.getESuperTypes().add(this.getMetadataElement());
		collectionAttributeEClass.getESuperTypes().add(this.getAttributeMetaData());
		entityMetaDataEClass.getESuperTypes().add(this.getTypeMetaData());
		entityModelEClass.getESuperTypes().add(this.getMetadataElement());
		jdoEntityEClass.getESuperTypes().add(this.getEntityMetaData());
		mapAttributeEClass.getESuperTypes().add(this.getAttributeMetaData());
		typeMetaDataEClass.getESuperTypes().add(this.getMetadataElement());
		basicAttributeEClass.getESuperTypes().add(this.getAttributeMetaData());
		referenceAttributeEClass.getESuperTypes().add(this.getAttributeMetaData());
		joinEClass.getESuperTypes().add(this.getMetadataElement());
		joinPairEClass.getESuperTypes().add(this.getMetadataElement());
		ormColumnEClass.getESuperTypes().add(this.getMetadataElement());
		ormTableEClass.getESuperTypes().add(this.getMetadataElement());
		simpleTypeMetaDataEClass.getESuperTypes().add(this.getTypeMetaData());
		collectionTypeMetaDataEClass.getESuperTypes().add(this.getTypeMetaData());
		embeddedAttributeEClass.getESuperTypes().add(this.getAttributeMetaData());

		// Initialize classes and features; add operations and parameters
		initEClass(attributeMetaDataEClass, AttributeMetaData.class, "AttributeMetaData", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAttributeMetaData_EntityMetaData(), this.getEntityMetaData(), this.getEntityMetaData_AttributeList(), "entityMetaData", null, 0, 1, AttributeMetaData.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAttributeMetaData_EmbeddedIn(), this.getEmbeddedAttribute(), this.getEmbeddedAttribute_AttributeList(), "embeddedIn", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributeMetaData_Name(), ecorePackage.getEString(), "name", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAttributeMetaData_JavaType(), this.getTypeMetaData(), null, "javaType", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributeMetaData_FetchType(), ecorePackage.getEInt(), "fetchType", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributeMetaData_Optional(), ecorePackage.getEBoolean(), "optional", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributeMetaData_GetterMethodName(), ecorePackage.getEString(), "getterMethodName", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributeMetaData_SetterMethodName(), ecorePackage.getEString(), "setterMethodName", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAttributeMetaData_MappedBy(), this.getAttributeMetaData(), this.getAttributeMetaData_InverseList(), "mappedBy", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAttributeMetaData_InverseList(), this.getAttributeMetaData(), this.getAttributeMetaData_MappedBy(), "inverseList", null, 0, -1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAttributeMetaData_OverrideOf(), this.getAttributeMetaData(), this.getAttributeMetaData_OverrideList(), "overrideOf", null, 0, 1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAttributeMetaData_OverrideList(), this.getAttributeMetaData(), this.getAttributeMetaData_OverrideOf(), "overrideList", null, 0, -1, AttributeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(attributeMetaDataEClass, ecorePackage.getEBoolean(), "isPrimaryKey");

		addEOperation(attributeMetaDataEClass, ecorePackage.getEBoolean(), "isNonPersistent");

		addEOperation(attributeMetaDataEClass, null, "makeNonPersistent");

		addEOperation(attributeMetaDataEClass, ecorePackage.getEBoolean(), "isField");

		addEOperation(attributeMetaDataEClass, ecorePackage.getEBoolean(), "isVersion");

		initEClass(collectionAttributeEClass, CollectionAttribute.class, "CollectionAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCollectionAttribute_ElementType(), this.getTypeMetaData(), null, "elementType", null, 0, 1, CollectionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCollectionAttribute_OneToMany(), ecorePackage.getEBoolean(), "oneToMany", null, 0, 1, CollectionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCollectionAttribute_JoinTable(), this.getOrmTable(), null, "joinTable", null, 0, 1, CollectionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCollectionAttribute_SrcJoin(), this.getJoin(), null, "srcJoin", null, 0, 1, CollectionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCollectionAttribute_DestJoin(), this.getJoin(), null, "destJoin", null, 0, 1, CollectionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCollectionAttribute_CascadeType(), ecorePackage.getEInt(), "cascadeType", null, 0, 1, CollectionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCollectionAttribute_OrderBy(), ecorePackage.getEString(), "orderBy", null, 0, 1, CollectionAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(entityMetaDataEClass, EntityMetaData.class, "EntityMetaData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getEntityMetaData_EntityType(), ecorePackage.getEInt(), "entityType", "1", 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_SchemaName(), ecorePackage.getEString(), "schemaName", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_SuperEntity(), this.getEntityMetaData(), this.getEntityMetaData_SubEntityList(), "superEntity", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_SubEntityList(), this.getEntityMetaData(), this.getEntityMetaData_SuperEntity(), "subEntityList", null, 0, -1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_AttributeList(), this.getAttributeMetaData(), this.getAttributeMetaData_EntityMetaData(), "attributeList", null, 0, -1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_PrimaryKeyList(), this.getAttributeMetaData(), null, "primaryKeyList", null, 0, -1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_VersionList(), this.getAttributeMetaData(), null, "versionList", null, 0, -1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_IdGeneratorType(), ecorePackage.getEInt(), "idGeneratorType", "1", 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_IdGeneratorName(), ecorePackage.getEString(), "idGeneratorName", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_IdClass(), ecorePackage.getEString(), "idClass", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_Table(), this.getOrmTable(), null, "table", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_SecondaryTableJoinList(), this.getJoin(), null, "secondaryTableJoinList", null, 0, -1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_AccessType(), ecorePackage.getEInt(), "accessType", "1", 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_Inheritance(), ecorePackage.getEInt(), "inheritance", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_InheritanceSpecified(), ecorePackage.getEBoolean(), "inheritanceSpecified", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_DiscriminatorType(), ecorePackage.getEInt(), "discriminatorType", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMetaData_DiscriminatorValue(), ecorePackage.getEString(), "discriminatorValue", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_DiscriminatorColumn(), this.getOrmColumn(), null, "discriminatorColumn", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMetaData_SuperJoin(), this.getJoin(), null, "superJoin", null, 0, 1, EntityMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(entityMetaDataEClass, ecorePackage.getEBoolean(), "isBaseEntity");

		addEOperation(entityMetaDataEClass, ecorePackage.getEBoolean(), "hasSubEntities");

		addEOperation(entityMetaDataEClass, ecorePackage.getEBoolean(), "isEntity");

		addEOperation(entityMetaDataEClass, ecorePackage.getEBoolean(), "isEmbeddable");

		addEOperation(entityMetaDataEClass, ecorePackage.getEBoolean(), "isEmbeddableSuperclass");

		initEClass(entityModelEClass, EntityModel.class, "EntityModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEntityModel_TypeList(), this.getTypeMetaData(), this.getTypeMetaData_EntityModel(), "typeList", null, 0, -1, EntityModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		EOperation op = addEOperation(entityModelEClass, this.getTypeMetaData(), "findTypeByClassName");
		addEParameter(op, ecorePackage.getEString(), "className");

		op = addEOperation(entityModelEClass, this.getEntityMetaData(), "findEntityBySchemaName");
		addEParameter(op, ecorePackage.getEString(), "schemaName");

		initEClass(jdoEntityEClass, JdoEntity.class, "JdoEntity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getJdoEntity_IdentityType(), ecorePackage.getEInt(), "identityType", null, 0, 1, JdoEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mapAttributeEClass, MapAttribute.class, "MapAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMapAttribute_KeyType(), this.getTypeMetaData(), null, "keyType", null, 0, 1, MapAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMapAttribute_ValueType(), this.getTypeMetaData(), null, "valueType", null, 0, 1, MapAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(metadataElementEClass, MetadataElement.class, "MetadataElement", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(metadataElementEClass, null, "delete");

		initEClass(typeMetaDataEClass, TypeMetaData.class, "TypeMetaData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTypeMetaData_EntityModel(), this.getEntityModel(), this.getEntityModel_TypeList(), "entityModel", null, 0, 1, TypeMetaData.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTypeMetaData_ClassName(), ecorePackage.getEString(), "className", null, 0, 1, TypeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTypeMetaData_Cls(), ecorePackage.getEJavaClass(), "cls", null, 0, 1, TypeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(typeMetaDataEClass, ecorePackage.getEString(), "getShortName");

		initEClass(basicAttributeEClass, BasicAttribute.class, "BasicAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getBasicAttribute_Column(), this.getOrmColumn(), null, "column", null, 0, 1, BasicAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(referenceAttributeEClass, ReferenceAttribute.class, "ReferenceAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getReferenceAttribute_CascadeType(), ecorePackage.getEInt(), "cascadeType", null, 0, 1, ReferenceAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getReferenceAttribute_Join(), this.getJoin(), null, "join", null, 0, 1, ReferenceAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getReferenceAttribute_OneToOne(), ecorePackage.getEBoolean(), "oneToOne", null, 0, 1, ReferenceAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(joinEClass, Join.class, "Join", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getJoin_PairList(), this.getJoinPair(), this.getJoinPair_Join(), "pairList", null, 0, -1, Join.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJoin_Comment(), ecorePackage.getEString(), "comment", null, 0, 1, Join.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		op = addEOperation(joinEClass, this.getJoinPair(), "findPairForDest");
		addEParameter(op, this.getOrmColumn(), "dest");

		addEOperation(joinEClass, this.getOrmColumn(), "getSrcColumns");

		op = addEOperation(joinEClass, this.getJoinPair(), "findPairForSrc");
		addEParameter(op, this.getOrmColumn(), "src");

		op = addEOperation(joinEClass, this.getJoinPair(), "findPairForSrc");
		addEParameter(op, ecorePackage.getEString(), "srcColName");

		addEOperation(joinEClass, this.getOrmColumn(), "getDestColumns");

		addEOperation(joinEClass, this.getOrmTable(), "getSrcTable");

		addEOperation(joinEClass, this.getOrmTable(), "getDestTable");

		initEClass(joinPairEClass, JoinPair.class, "JoinPair", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getJoinPair_Join(), this.getJoin(), this.getJoin_PairList(), "join", null, 0, 1, JoinPair.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getJoinPair_Src(), this.getOrmColumn(), this.getOrmColumn_SrcJoinPairs(), "src", null, 0, 1, JoinPair.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getJoinPair_Dest(), this.getOrmColumn(), this.getOrmColumn_DestJoinPairs(), "dest", null, 0, 1, JoinPair.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ormColumnEClass, OrmColumn.class, "OrmColumn", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOrmColumn_Table(), this.getOrmTable(), this.getOrmTable_ColumnList(), "table", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Name(), ecorePackage.getEString(), "name", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_JdbcType(), ecorePackage.getEInt(), "jdbcType", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Nullable(), ecorePackage.getEBoolean(), "nullable", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Insertable(), ecorePackage.getEBoolean(), "insertable", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Updatable(), ecorePackage.getEBoolean(), "updatable", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Length(), ecorePackage.getEInt(), "length", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Scale(), ecorePackage.getEInt(), "scale", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_ColumnDefinition(), ecorePackage.getEString(), "columnDefinition", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_ColumnDefinitionSpecified(), ecorePackage.getEBoolean(), "columnDefinitionSpecified", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_OriginalColumnDefinition(), ecorePackage.getEString(), "originalColumnDefinition", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOrmColumn_SrcJoinPairs(), this.getJoinPair(), this.getJoinPair_Src(), "srcJoinPairs", null, 0, -1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOrmColumn_DestJoinPairs(), this.getJoinPair(), this.getJoinPair_Dest(), "destJoinPairs", null, 0, -1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_DatabaseType(), ecorePackage.getEString(), "databaseType", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Comment(), ecorePackage.getEString(), "comment", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_RelativePositionInTable(), ecorePackage.getEInt(), "relativePositionInTable", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmColumn_Identity(), ecorePackage.getEBoolean(), "identity", null, 0, 1, OrmColumn.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(ormColumnEClass, ecorePackage.getEBoolean(), "isPrimaryKey");

		op = addEOperation(ormColumnEClass, this.getOrmColumn(), "copyTo");
		addEParameter(op, this.getOrmColumn(), "dest");

		initEClass(ormTableEClass, OrmTable.class, "OrmTable", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getOrmTable_Name(), ecorePackage.getEString(), "name", null, 0, 1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmTable_Catalog(), ecorePackage.getEString(), "catalog", null, 0, 1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmTable_Schema(), ecorePackage.getEString(), "schema", null, 0, 1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOrmTable_ColumnList(), this.getOrmColumn(), this.getOrmColumn_Table(), "columnList", null, 0, -1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOrmTable_ParentElement(), this.getMetadataElement(), null, "parentElement", null, 0, 1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmTable_Comment(), ecorePackage.getEString(), "comment", null, 0, 1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOrmTable_PrimaryKeyList(), this.getOrmColumn(), null, "primaryKeyList", null, 0, -1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOrmTable_Virtual(), ecorePackage.getEBoolean(), "virtual", null, 0, 1, OrmTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		op = addEOperation(ormTableEClass, this.getOrmColumn(), "findColumn");
		addEParameter(op, ecorePackage.getEString(), "name");

		addEOperation(ormTableEClass, ecorePackage.getEBoolean(), "sortColumns");

		initEClass(simpleTypeMetaDataEClass, SimpleTypeMetaData.class, "SimpleTypeMetaData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSimpleTypeMetaData_Column(), this.getOrmColumn(), null, "column", null, 0, 1, SimpleTypeMetaData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(collectionTypeMetaDataEClass, CollectionTypeMetaData.class, "CollectionTypeMetaData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(embeddedAttributeEClass, EmbeddedAttribute.class, "EmbeddedAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEmbeddedAttribute_AttributeList(), this.getAttributeMetaData(), this.getAttributeMetaData_EmbeddedIn(), "attributeList", null, 0, -1, EmbeddedAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} //MetadataPackageImpl
