/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MetadataFactoryImpl.java,v 1.15 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.jsr220orm.metadata.*;

import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.CollectionTypeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.JdoEntity;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MapAttribute;
import org.eclipse.jsr220orm.metadata.MetadataFactory;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.SimpleTypeMetaData;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MetadataFactoryImpl extends EFactoryImpl implements MetadataFactory {
	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetadataFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case MetadataPackage.COLLECTION_ATTRIBUTE: return createCollectionAttribute();
			case MetadataPackage.ENTITY_META_DATA: return createEntityMetaData();
			case MetadataPackage.ENTITY_MODEL: return createEntityModel();
			case MetadataPackage.JDO_ENTITY: return createJdoEntity();
			case MetadataPackage.MAP_ATTRIBUTE: return createMapAttribute();
			case MetadataPackage.TYPE_META_DATA: return createTypeMetaData();
			case MetadataPackage.BASIC_ATTRIBUTE: return createBasicAttribute();
			case MetadataPackage.REFERENCE_ATTRIBUTE: return createReferenceAttribute();
			case MetadataPackage.JOIN: return createJoin();
			case MetadataPackage.JOIN_PAIR: return createJoinPair();
			case MetadataPackage.ORM_COLUMN: return createOrmColumn();
			case MetadataPackage.ORM_TABLE: return createOrmTable();
			case MetadataPackage.SIMPLE_TYPE_META_DATA: return createSimpleTypeMetaData();
			case MetadataPackage.COLLECTION_TYPE_META_DATA: return createCollectionTypeMetaData();
			case MetadataPackage.EMBEDDED_ATTRIBUTE: return createEmbeddedAttribute();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollectionAttribute createCollectionAttribute() {
		CollectionAttributeImpl collectionAttribute = new CollectionAttributeImpl();
		return collectionAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EntityMetaData createEntityMetaData() {
		EntityMetaDataImpl entityMetaData = new EntityMetaDataImpl();
		return entityMetaData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EntityModel createEntityModel() {
		EntityModelImpl entityModel = new EntityModelImpl();
		return entityModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JdoEntity createJdoEntity() {
		JdoEntityImpl jdoEntity = new JdoEntityImpl();
		return jdoEntity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MapAttribute createMapAttribute() {
		MapAttributeImpl mapAttribute = new MapAttributeImpl();
		return mapAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData createTypeMetaData() {
		TypeMetaDataImpl typeMetaData = new TypeMetaDataImpl();
		return typeMetaData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BasicAttribute createBasicAttribute() {
		BasicAttributeImpl basicAttribute = new BasicAttributeImpl();
		return basicAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReferenceAttribute createReferenceAttribute() {
		ReferenceAttributeImpl referenceAttribute = new ReferenceAttributeImpl();
		return referenceAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join createJoin() {
		JoinImpl join = new JoinImpl();
		return join;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JoinPair createJoinPair() {
		JoinPairImpl joinPair = new JoinPairImpl();
		return joinPair;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn createOrmColumn() {
		OrmColumnImpl ormColumn = new OrmColumnImpl();
		return ormColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmTable createOrmTable() {
		OrmTableImpl ormTable = new OrmTableImpl();
		return ormTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleTypeMetaData createSimpleTypeMetaData() {
		SimpleTypeMetaDataImpl simpleTypeMetaData = new SimpleTypeMetaDataImpl();
		return simpleTypeMetaData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollectionTypeMetaData createCollectionTypeMetaData() {
		CollectionTypeMetaDataImpl collectionTypeMetaData = new CollectionTypeMetaDataImpl();
		return collectionTypeMetaData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EmbeddedAttribute createEmbeddedAttribute() {
		EmbeddedAttributeImpl embeddedAttribute = new EmbeddedAttributeImpl();
		return embeddedAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetadataPackage getMetadataPackage() {
		return (MetadataPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static MetadataPackage getPackage() {
		return MetadataPackage.eINSTANCE;
	}

} //MetadataFactoryImpl
