/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

/**
 * A reference to an entity.
 *
 * @model
 * @generated
 */
public interface ReferenceAttribute extends AttributeMetaData{
	
	/**
	 * Bitmapped cascade semantics for this reference.
	 * 
	 * @see AttributeMetaData#CASCADE_TYPE_MERGE
	 * @see AttributeMetaData#CASCADE_TYPE_PERSIST
	 * @see AttributeMetaData#CASCADE_TYPE_REFRESH
	 * @see AttributeMetaData#CASCADE_TYPE_REMOVE
	 * 
	 * @model
	 * @generated
	 */
    int getCascadeType();

    void setCascadeType(int value);

	/**
	 * The join to the referenced entities table.
	 * 
	 * @model
	 * @generated
	 */
	Join getJoin();

	void setJoin(Join value);

	/**
	 * Is this a one-to-one relationship?
	 * 
	 * @model
	 * @generated
	 */
	boolean isOneToOne();

	void setOneToOne(boolean value);

	void setMappedBy(AttributeMetaData value);

} // ReferenceAttribute
