/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

import org.eclipse.emf.common.util.EList;

/**
 * A column in a OrmTable. Natural ordering is by {@link #getIndexInTable()}.
 * 
 * @model
 * @generated
 */
public interface OrmColumn extends MetadataElement{
	
	/**
	 * The table this column belongs to.
	 * 
	 * @model
	 * @generated
	 */
	OrmTable getTable();

	/**
	 * @generated
	 */
	void setTable(OrmTable value);

	/**
	 * The name of this column.
	 * 
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * @generated
	 */
	void setName(String value);

	/**
	 * The JDBC type of this column (from {@link java.sql.Types}).
	 * 
	 * @generated
	 * @model
	 */
	int getJdbcType();

	/**
	 * @generated
	 */
	void setJdbcType(int value);

	/**
	 * Does the column allow nulls?
	 * 
	 * @model
	 * @generated
	 */
	boolean isNullable();

	/**
	 * @generated
	 */
	void setNullable(boolean value);

	/**
	 * Must the column be included in generated insert statements?
	 * 
	 * @model
	 * @generated
	 */
	boolean isInsertable();

	/**
	 * @generated
	 */
	void setInsertable(boolean value);

	/**
	 * Must the column be included in generated update statements?
	 * 
	 * @model
	 * @generated
	 */
	boolean isUpdatable();

	/**
	 * @generated
	 */
	void setUpdatable(boolean value);

	/**
	 * The column length e.g. for a VARCHAR column.
     * Returning -1 means that scale is not relevant. eg. it will not be 
     * displayed on live er diagram
	 * 
	 * @model
	 * @generated
	 */
	int getLength();

	/**
	 * @generated
	 */
	void setLength(int value);

	/**
	 * The scale for a decimal column.
	 * Returning -1 means that scale is not relevant. eg. it will not be 
     * displayed on live er diagram
	 * @model
	 * @generated
	 */
	int getScale();

	/**
	 * @generated
	 */
	void setScale(int value);

	/**
	 * The text to be used when generating DDL to create this column. If this is
	 * empty or null then the column type and other properties are used to
	 * generate the DDL.
	 * 
	 * @model
	 * @generated
	 */
	String getColumnDefinition();

	void setColumnDefinition(String value);

	/**
	 * Was the {@link #getColumnDefinition()} specified in some meta data or
	 * was it generated from column properties?
	 * 
	 * @model
	 * @generated
	 */
	boolean isColumnDefinitionSpecified();

	void setColumnDefinitionSpecified(boolean value);

	/**
	 * Get the original value of {@link #getColumnDefinition()}. This is used
	 * by tooling to detect changes to the columnDefinition attribute.
	 * 
	 * @model
	 * @generated
	 */
	String getOriginalColumnDefinition();

	void setOriginalColumnDefinition(String value);

	/**
	 * Set the relative position of this column its table.
	 * 
	 * @see OrmTable#sortColumns()
	 * 
	 * @model
	 * @generated
	 */
	int getRelativePositionInTable();

	void setRelativePositionInTable(int value);

	/**
	 * Is this column an IDENTITY or AUTO INCREMENT column?
	 * 
	 * @model
	 * @generated
	 */
	boolean isIdentity();

	void setIdentity(boolean value);

	/**
	 * Is this column in the {@link OrmTable#getPrimaryKeyList()} of its 
	 * owning table?
	 * 
	 * @model kind="operation"
	 */
	boolean isPrimaryKey();

	/**
	 * Copy our attributes to dest (except table and JoinPair lists) and
	 * return dest.
	 * 
	 * @model kind="operation"
	 */
	OrmColumn copyTo(OrmColumn dest);

    /**
     * Get the JoinPair's where we are the {@link JoinPair#getSrc()}.
     * 
     * @model type="org.eclipse.jsr220orm.metadata.mapping.JoinPair" opposite="src"
     * @generated
     */
    EList getSrcJoinPairs();

	/**
     * Get the JoinPair's where we are the {@link JoinPair#getDest()}.
     * 
	 * @model type="org.eclipse.jsr220orm.metadata.JoinPair" opposite="dest"
	 * @generated
	 */
	EList getDestJoinPairs();

    /**
     * The basic database type for this column suitable for display in GUIs
     * and debugging (e.g. "VARCHAR(255)").
     * 
     * @model
     * @generated
     */
    String getDatabaseType();

    void setDatabaseType(String value);

    /**
     * @model
     * @generated
     */
    String getComment();

    void setComment(String value);

} // OrmColumn
