/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MetadataFactory.java,v 1.13 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.jsr220orm.metadata.MetadataPackage
 * @generated
 */
public interface MetadataFactory extends EFactory{
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MetadataFactory eINSTANCE = new org.eclipse.jsr220orm.metadata.impl.MetadataFactoryImpl();

	/**
	 * Returns a new object of class '<em>Collection Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Collection Attribute</em>'.
	 * @generated
	 */
	CollectionAttribute createCollectionAttribute();

	/**
	 * Returns a new object of class '<em>Entity Meta Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Entity Meta Data</em>'.
	 * @generated
	 */
	EntityMetaData createEntityMetaData();

	/**
	 * Returns a new object of class '<em>Entity Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Entity Model</em>'.
	 * @generated
	 */
	EntityModel createEntityModel();

	/**
	 * Returns a new object of class '<em>Jdo Entity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Jdo Entity</em>'.
	 * @generated
	 */
	JdoEntity createJdoEntity();

	/**
	 * Returns a new object of class '<em>Map Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Map Attribute</em>'.
	 * @generated
	 */
	MapAttribute createMapAttribute();

	/**
	 * Returns a new object of class '<em>Type Meta Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Type Meta Data</em>'.
	 * @generated
	 */
	TypeMetaData createTypeMetaData();

	/**
	 * Returns a new object of class '<em>Basic Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Basic Attribute</em>'.
	 * @generated
	 */
	BasicAttribute createBasicAttribute();

	/**
	 * Returns a new object of class '<em>Reference Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference Attribute</em>'.
	 * @generated
	 */
	ReferenceAttribute createReferenceAttribute();

	/**
	 * Returns a new object of class '<em>Join</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Join</em>'.
	 * @generated
	 */
	Join createJoin();

	/**
	 * Returns a new object of class '<em>Join Pair</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Join Pair</em>'.
	 * @generated
	 */
	JoinPair createJoinPair();

	/**
	 * Returns a new object of class '<em>Orm Column</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Orm Column</em>'.
	 * @generated
	 */
	OrmColumn createOrmColumn();

	/**
	 * Returns a new object of class '<em>Orm Table</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Orm Table</em>'.
	 * @generated
	 */
	OrmTable createOrmTable();

	/**
	 * Returns a new object of class '<em>Simple Type Meta Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Simple Type Meta Data</em>'.
	 * @generated
	 */
	SimpleTypeMetaData createSimpleTypeMetaData();

	/**
	 * Returns a new object of class '<em>Collection Type Meta Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Collection Type Meta Data</em>'.
	 * @generated
	 */
	CollectionTypeMetaData createCollectionTypeMetaData();

	/**
	 * Returns a new object of class '<em>Embedded Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Embedded Attribute</em>'.
	 * @generated
	 */
	EmbeddedAttribute createEmbeddedAttribute();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	MetadataPackage getMetadataPackage();

} //MetadataFactory
