/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

/**
 * A collection attribute (java.util.Set etc.).
 * 
 * @model
 * @generated
 */
public interface CollectionAttribute extends AttributeMetaData{

	/**
	 * Get the type of values stored in the collection.
	 * 
	 * @model
	 * @generated
	 */
	TypeMetaData getElementType();

	void setElementType(TypeMetaData value);

	/**
	 * Is this a OneToMany relationship?
	 * 
	 * @model
	 * @generated
	 */
	boolean isOneToMany();

	void setOneToMany(boolean value);

	/**
	 * If this collection is stored using a join or association table then
	 * this is not null.
	 * 
	 * @model
	 * @generated
	 */
	OrmTable getJoinTable();

	void setJoinTable(OrmTable value);

	/**
	 * The columns in our {@link #getJoinTable()} that reference our table.
	 * Null if not using a join table.
	 * 
	 * @model
	 * @generated
	 */
	Join getSrcJoin();

	void setSrcJoin(Join value);

	/**
	 * The columns in our {@link #getJoinTable()} that reference our
	 * target entity. Null if not using a join table.
	 * 
	 * @model
	 * @generated
	 */
	Join getDestJoin();

	void setDestJoin(Join value);

	/**
	 * How this attribute cascaded ({@link AttributeMetaData#CASCADE_TYPE_ALL}
	 * etc.)?
	 * 
	 * @model
	 * @generated
	 */
	int getCascadeType();

	void setCascadeType(int value);

	/**
	 * The ordering expresion for the collection.
	 * 
	 * @model
	 * @generated
	 */
	String getOrderBy();

	void setOrderBy(String value);

} // CollectionAttribute
