/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.views;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jsr220orm.core.nature.OrmNatureEvent;
import org.eclipse.jsr220orm.core.nature.OrmNatureListener;
import org.eclipse.jsr220orm.core.nature.OrmNatureUtils;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.internal.selection.PersistenceSelection;
import org.eclipse.jsr220orm.ui.internal.selection.PersistenceSelectionProvider;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractMetadataView
extends ViewPart
implements ISelectionChangedListener,
IPartListener,
IPageListener,
IPerspectiveListener,
OrmNatureListener {
    private ISelection selection;
    protected PersistenceSelectionProvider selectionProvider;
    private MetadataElement parentElement;
    private EntityModel entityModel;
    private boolean busy;
    private boolean needUpdate;
    private final Adapter parentListener = new Adapter(){

        public void notifyChanged(Notification no) {
            switch (no.getEventType()) {
                case 3: 
                case 4: {
                    AbstractMetadataView.this.asyncRefresh();
                }
            }
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof Class && EntityMetaData.class.isAssignableFrom((Class)type) && EntityModel.class.isAssignableFrom((Class)type);
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public AbstractMetadataView() {
        OrmNatureUtils.addOrmNatureListener((OrmNatureListener)this);
    }

    public void dispose() {
        super.dispose();
        OrmNatureUtils.removeOrmNatureListener((OrmNatureListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelectionProvider eventSelectionProvider = event.getSelectionProvider();
        if (eventSelectionProvider != this.selectionProvider) {
            if (eventSelectionProvider != null) {
                eventSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            return;
        }
        this.selection = event.getSelection();
        this.doUpdate(false);
    }

    public void doUpdate(boolean dataChanged) {
        if (dataChanged) {
            this.selection = null;
        }
        MetadataElement element = this.getMetadataElement();
        IWorkbenchPartSite site = this.getSite();
        if (site != null && site.getPage().isPartVisible((IWorkbenchPart)this)) {
            this.doUpdateImpl(element);
            this.needUpdate = false;
        } else {
            this.needUpdate = true;
        }
    }

    protected abstract void doUpdate(MetadataElement var1);

    private void doUpdateImpl(MetadataElement element) {
        MetadataElement np;
        if (element != null && this.entityModel == null) {
            this.entityModel = (EntityModel)element.getAncestor(EntityModel.class);
            if (this.entityModel != null) {
                this.entityModel.eAdapters().add((Object)this.parentListener);
            }
        }
        MetadataElement metadataElement = np = element == null ? null : element.getParentElement();
        if (np != this.parentElement) {
            if (this.parentElement != null) {
                this.parentElement.eAdapters().remove((Object)this.parentListener);
            }
            if ((this.parentElement = np) != null) {
                this.parentElement.eAdapters().add((Object)this.parentListener);
            }
        }
        try {
            if (!this.busy) {
                this.busy = true;
                this.doUpdate(element);
            }
        }
        finally {
            this.busy = false;
        }
    }

    protected MetadataElement getMetadataElement() {
        if (this.selection == null && this.selectionProvider != null) {
            this.selection = this.selectionProvider.getSelection();
        }
        if (this.selection instanceof PersistenceSelection) {
            MetadataElement element = ((PersistenceSelection)this.selection).getSelectedElement();
            return element;
        }
        return null;
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        IWorkbenchPage page = site.getPage();
        page.addPartListener((IPartListener)this);
        page.getWorkbenchWindow().addPageListener((IPageListener)this);
        page.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        this.installWorkbenchPage((IWorkbenchPart)page.getActiveEditor());
    }

    protected void installWorkbenchPage(IWorkbenchPart part) {
        boolean thisPart;
        if (part == null) {
            return;
        }
        boolean bl = thisPart = part == this;
        if (thisPart && this.selectionProvider == null && (part = this.getSite().getPage().getActiveEditor()) == null) {
            return;
        }
        PersistenceSelectionProvider newProvider = null;
        newProvider = (PersistenceSelectionProvider)part.getAdapter(PersistenceSelectionProvider.class);
        if (this.selectionProvider != newProvider && newProvider != null) {
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener(this);
            }
            this.selectionProvider = newProvider;
            if (this.selectionProvider != null) {
                this.selectionProvider.addSelectionChangedListener(this);
            }
        }
        if (!thisPart || this.needUpdate) {
            this.doUpdate(this.selectionProvider != null);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.installWorkbenchPage(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.installWorkbenchPage(part);
    }

    public void pageActivated(IWorkbenchPage page) {
        this.installWorkbenchPage(page.getActivePart());
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (page == this.getSite().getPage()) {
            this.installWorkbenchPage(page.getActivePart());
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (page == this.getSite().getPage()) {
            this.installWorkbenchPage(page.getActivePart());
        }
    }

    public void ormNatureRemoved(OrmNatureEvent e) {
        this.refreshModel();
    }

    public void projectActivated(OrmNatureEvent e) {
        this.refreshModel();
    }

    public void projectDeactivated(OrmNatureEvent e) {
        this.refreshModel();
    }

    private void refreshModel() {
        if (this.entityModel != null) {
            this.entityModel.eAdapters().remove((Object)this.parentListener);
        }
        this.asyncRefresh();
    }

    private void asyncRefresh() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                AbstractMetadataView.this.doUpdate(true);
            }
        });
    }
}

