/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.mapping.composite;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.binding.EmfWidgetBinding;
import org.eclipse.jsr220orm.ui.internal.binding.EntEntityTypeBinding;
import org.eclipse.jsr220orm.ui.internal.binding.EntUseDiscriminatorBinding;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class EntityComposite {
    private Text tSchemaName;
    private CCombo tAccessType;
    private Text tIdCLass;
    private CCombo tIdGeneratorType;
    private Text tIdGeneratorName;
    private EntEntityTypeBinding entityTypeBinding = new EntEntityTypeBinding();
    private EmfWidgetBinding tSchemaNameBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tAccessTypeBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tIdCLassBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tIdGeneratorTypeBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tIdGeneratorNameBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tInheritanceBinding = new EmfWidgetBinding();
    private EmfWidgetBinding tDiscriminatorValueBinding = new EmfWidgetBinding();
    private EntUseDiscriminatorBinding tUseDiscriminatorBinding = new EntUseDiscriminatorBinding();
    private EntityMetaData entityMetaData;
    private Hyperlink lIdClass = null;
    private CCombo tInheritanceType;
    private Button tUseDiscriminator;
    private Text tDiscriminatorValue;
    private ScrolledForm scrolledForm;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Composite createComposite(Composite parent, FormToolkit toolkit) {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetadataItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        this.scrolledForm = new ScrolledForm(parent, 512);
        this.scrolledForm.setExpandHorizontal(true);
        this.scrolledForm.setExpandVertical(true);
        this.scrolledForm.setMinWidth(0);
        toolkit.adapt((Composite)this.scrolledForm);
        Composite composite = this.scrolledForm.getBody();
        GridLayout thisLayout = new GridLayout();
        composite.setLayout((Layout)thisLayout);
        thisLayout.numColumns = 2;
        toolkit.createLabel(composite, "Mapping");
        CCombo tEntityType = new CCombo(composite, 2056);
        this.entityTypeBinding.bind((AdapterFactory)adapterFactory, (Widget)tEntityType, 3);
        toolkit.adapt((Composite)tEntityType);
        tEntityType.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(composite, "Name");
        this.tSchemaName = toolkit.createText(composite, "", 2048);
        this.tSchemaNameBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tSchemaName, 4);
        this.tSchemaName.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(composite, "Access Type");
        GridData tAccessTypeLData = new GridData();
        tAccessTypeLData.grabExcessHorizontalSpace = true;
        tAccessTypeLData.widthHint = 75;
        this.tAccessType = new CCombo(composite, 2056);
        this.tAccessTypeBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tAccessType, 15);
        this.tAccessType.setLayoutData((Object)tAccessTypeLData);
        this.tAccessType.setEditable(false);
        toolkit.adapt((Composite)this.tAccessType);
        GridData tIdCLassLData = new GridData();
        tIdCLassLData.grabExcessHorizontalSpace = true;
        tIdCLassLData.horizontalAlignment = 4;
        this.lIdClass = toolkit.createHyperlink(composite, "ID class", 0);
        this.lIdClass.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EntityComposite.this.findIdClass();
            }
        });
        this.tIdCLass = toolkit.createText(composite, "", 2048);
        this.tIdCLass.setLayoutData((Object)tIdCLassLData);
        this.tIdCLassBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tIdCLass, 12);
        toolkit.createLabel(composite, "ID generator type");
        GridData tIdGeneratorTypeLData = new GridData();
        tIdGeneratorTypeLData.grabExcessHorizontalSpace = true;
        tIdGeneratorTypeLData.widthHint = 100;
        this.tIdGeneratorType = new CCombo(composite, 2056);
        this.tIdGeneratorTypeBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tIdGeneratorType, 10);
        this.tIdGeneratorType.setLayoutData((Object)tIdGeneratorTypeLData);
        toolkit.adapt((Composite)this.tIdGeneratorType);
        toolkit.createLabel(composite, "ID generator name");
        GridData tIdGeneratorNameLData = new GridData();
        tIdGeneratorNameLData.grabExcessHorizontalSpace = true;
        tIdGeneratorNameLData.horizontalAlignment = 4;
        this.tIdGeneratorName = toolkit.createText(composite, "", 2048);
        this.tIdGeneratorNameBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tIdGeneratorName, 11);
        this.tIdGeneratorName.setLayoutData((Object)tIdGeneratorNameLData);
        toolkit.createLabel(composite, "Inheritance type");
        this.tInheritanceType = new CCombo(composite, 2056);
        GridData tInheritanceTypeData = new GridData();
        tInheritanceTypeData.widthHint = 100;
        this.tInheritanceType.setLayoutData((Object)tInheritanceTypeData);
        toolkit.adapt((Composite)this.tInheritanceType);
        this.tInheritanceBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tInheritanceType, 16);
        toolkit.createLabel(composite, "Use discriminator");
        this.tUseDiscriminator = toolkit.createButton(composite, "", 32);
        this.tUseDiscriminatorBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tUseDiscriminator);
        toolkit.createLabel(composite, "Discriminator value");
        this.tDiscriminatorValue = toolkit.createText(composite, "", 2048);
        GridData tDiscriminatorData = new GridData();
        tDiscriminatorData.grabExcessHorizontalSpace = true;
        tDiscriminatorData.horizontalAlignment = 4;
        this.tDiscriminatorValue.setLayoutData((Object)tDiscriminatorData);
        this.tDiscriminatorValueBinding.bind((AdapterFactory)adapterFactory, (Widget)this.tDiscriminatorValue, 19);
        return this.scrolledForm;
    }

    private String getTile(EntityMetaData entityMetaData) {
        String schemaName = entityMetaData.getSchemaName();
        return schemaName != null ? schemaName : entityMetaData.getClassName();
    }

    public Composite getComposite() {
        return this.scrolledForm;
    }

    protected void findIdClass() {
        try {
            Object[] result;
            IProject project = (IProject)this.entityMetaData.adapt(IProject.class);
            SelectionDialog select = JavaUI.createTypeDialog((Shell)this.scrolledForm.getShell(), null, (IProject)project, (int)2, (boolean)false);
            if (select.open() == 0 && (result = select.getResult()).length > 0) {
                IType type = (IType)result[0];
                this.tIdCLass.setText(type.getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            OrmUiPlugin.logException(e, "Error finding class", this.scrolledForm.getShell());
        }
    }

    public EntityMetaData getEntityMetaData() {
        return this.entityMetaData;
    }

    public void setEntityMetaData(EntityMetaData entityMetaData) {
        this.entityMetaData = entityMetaData;
        this.entityTypeBinding.setEObject((EObject)entityMetaData);
        this.tSchemaNameBinding.setEObject((EObject)entityMetaData);
        this.tAccessTypeBinding.setEObject((EObject)entityMetaData);
        this.tIdCLassBinding.setEObject((EObject)entityMetaData);
        this.tIdGeneratorTypeBinding.setEObject((EObject)entityMetaData);
        this.tIdGeneratorNameBinding.setEObject((EObject)entityMetaData);
        this.tInheritanceBinding.setEObject((EObject)entityMetaData);
        this.tDiscriminatorValueBinding.setEObject((EObject)entityMetaData);
        this.tUseDiscriminatorBinding.setEObject((EObject)entityMetaData);
        IEntityModelManager emm = (IEntityModelManager)entityMetaData.adapt(IEntityModelManager.class);
        boolean idGeneratorEnabled = false;
        if (emm != null) {
            idGeneratorEnabled = emm.isIdGeneratorEnabled(entityMetaData);
        }
        this.tIdGeneratorType.setEnabled(idGeneratorEnabled);
        this.tIdGeneratorName.setEnabled(idGeneratorEnabled);
    }
}

