/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.mapping.DefaultMetadataUISelector;
import org.eclipse.jsr220orm.ui.mapping.MappingUIProvider;
import org.eclipse.jsr220orm.ui.mapping.MetadataUISelector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Bundle;

public class MainMetadataUISelector
implements MetadataUISelector {
    private Map selectors = new HashMap();
    private Map selectorsInstances = new HashMap();
    private DefaultMetadataUISelector defaultSelector;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MainMetadataUISelector() {
        this.selectors.put(MetadataElement.class.getName(), new ProviderExtention(DefaultMetadataUISelector.class.getName(), OrmUiPlugin.getPluginId()));
    }

    public MappingUIProvider getMappingUIProvider(MetadataElement element, Composite parent, FormToolkit toolkit) {
        MetadataUISelector selector = this.getSelector(element.getClass());
        if (selector != null) {
            return selector.getMappingUIProvider(element, parent, toolkit);
        }
        return null;
    }

    private MetadataUISelector getSelector(Class clazz) {
        if (clazz == null) {
            return this.getDefaultSelector();
        }
        MetadataUISelector selector = (MetadataUISelector)this.selectorsInstances.get(clazz);
        if (selector == null) {
            selector = this.getSelector(clazz.getName());
            if (selector == null && (selector = this.getSelector(clazz.getSuperclass())) == null) {
                Class<?>[] interfaces = clazz.getInterfaces();
                int x = interfaces.length - 1;
                while (x >= 0) {
                    selector = this.getSelector(interfaces[x]);
                    if (selector != null) break;
                    --x;
                }
            }
            if (selector != null) {
                this.selectorsInstances.put(clazz, selector);
            }
        }
        return selector;
    }

    private MetadataUISelector getSelector(String className) {
        ProviderExtention selectorExtention = (ProviderExtention)this.selectors.get(className);
        if (selectorExtention != null) {
            try {
                Bundle bundle = Platform.getBundle((String)selectorExtention.namespace);
                Class selectorClass = bundle.loadClass(selectorExtention.selectorClassName);
                return (MetadataUISelector)selectorClass.newInstance();
            }
            catch (Exception x) {
                OrmPlugin.log(null, (String)("Could not load MetadataUISelector class " + selectorExtention.selectorClassName + " for plgin " + selectorExtention.namespace), (Throwable)x, (int)2);
            }
        }
        return null;
    }

    public DefaultMetadataUISelector getDefaultSelector() {
        if (this.defaultSelector == null) {
            this.defaultSelector = new DefaultMetadataUISelector();
        }
        return this.defaultSelector;
    }

    private class ProviderExtention {
        private String selectorClassName;
        private String namespace;

        public ProviderExtention(String selectorClassName, String namespace) {
            this.selectorClassName = selectorClassName;
            this.namespace = namespace;
        }
    }
}

