/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ColumnListEditPart
extends AbstractGraphicalEditPart {
    private Color color = Display.getCurrent().getSystemColor(22);

    public ColumnListEditPart(Object colList) {
        this.setModel(colList);
    }

    protected IFigure createFigure() {
        Figure f = new Figure();
        f.setBorder((Border)new BaseBorder());
        f.setOpaque(false);
        f.setBackgroundColor(this.color);
        FlowLayout flowLayout = new FlowLayout(true);
        flowLayout.setMajorSpacing(25);
        flowLayout.setMinorSpacing(25);
        f.setLayoutManager((LayoutManager)flowLayout);
        return f;
    }

    protected void createEditPolicies() {
    }

    protected List getModelChildren() {
        ArrayList<OrmTable> diagramTables = new ArrayList<OrmTable>();
        List columns = (List)this.getModel();
        for (OrmColumn ormColumn : columns) {
            OrmTable ormTable = ormColumn.getTable();
            if (diagramTables.contains(ormTable)) continue;
            diagramTables.add(ormTable);
        }
        return diagramTables;
    }

    public class BaseBorder
    extends AbstractBorder {
        private Color color = Display.getCurrent().getSystemColor(18);
        private Insets insets = new Insets(3, 3, 4, 1);

        public Insets getInsets(IFigure figure) {
            return this.insets;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setForegroundColor(this.color);
            tempRect.setBounds(BaseBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            graphics.drawLine(tempRect.right() - 1, BaseBorder.tempRect.y, tempRect.right() - 1, tempRect.bottom());
        }
    }
}

