/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.core.nature;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jsr220orm.core.nature.OrmNatureUtils;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;

public class PersistenceProperties {
    public static final String PERSISTENCE_FILE_NAME = ".persistence";
    public static final String PROP_PERSISTENCE_XML = "ejb3.persistence.xml.file";
    public static final String PAR_FILE_NAME = "ejb3.par.file";
    public static final String ACTIVE_PERSISTENT_PRODUCT = "jsr220.orm.active.product";
    public static final String RDB_DATABASE = "jsr220.orm.rdb.database";
    public static final String RDB_DATABASE_VERSION = "jsr220.orm.rdb.database.version";
    public static final String RDB_CONNECTION = "jsr220.orm.rdb.connection";
    public static final String RDB_SCHEMA = "jsr220.orm.rdb.schema";
    public static final String RDB_USER_NAME = "jsr220.rdb.user";
    public static final String RDB_PASSWORD = "jsr220.rdb.password";
    private Properties persistenceProperties;
    private IProject project;

    public PersistenceProperties(IProject project) throws CoreException, IOException {
        this.project = project;
        this.persistenceProperties = OrmNatureUtils.getProperties(project, false);
    }

    public void reload(IProject project) throws CoreException, IOException {
        this.project = project;
        this.persistenceProperties = OrmNatureUtils.getProperties(project, true);
    }

    public void save() throws IOException, CoreException {
        OrmNatureUtils.setProperties(this.project, this.persistenceProperties);
    }

    public Properties getProperties() {
        return this.persistenceProperties;
    }

    public String getPersistenceProduct() {
        return this.persistenceProperties.getProperty(ACTIVE_PERSISTENT_PRODUCT);
    }

    public void setPersistenceProduct(String productKey) {
        this.setProperty(ACTIVE_PERSISTENT_PRODUCT, productKey);
    }

    public void setProperty(String key, String value) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        if (value != null && value.trim().length() > 0) {
            this.persistenceProperties.setProperty(key, value);
        } else {
            this.persistenceProperties.remove(key);
        }
    }

    public String getDatabaseName() {
        String database = this.persistenceProperties.getProperty(RDB_DATABASE);
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        if (database == null || !ddr.getVersions(database).hasNext()) {
            Iterator products = ddr.getProducts();
            String product = null;
            String[] defaults = new String[]{"MySql", "Oracle", "Derby", "SQL Server", "Sybase"};
            int index = defaults.length;
            while (products.hasNext()) {
                String prodName = (String)products.next();
                if (prodName == null || prodName.trim().length() == 0) continue;
                int x = 0;
                while (x < index) {
                    if (prodName.equals(defaults[x])) {
                        index = x;
                        product = prodName;
                    }
                    ++x;
                }
            }
            if (product == null) {
                product = (String)ddr.getProducts().next();
            }
            return product;
        }
        return database;
    }

    public void setDatabaseName(String database) {
        this.setProperty(RDB_DATABASE, database);
    }

    public String getDatabaseVersion() {
        String database = this.getDatabaseName();
        String version = this.persistenceProperties.getProperty(RDB_DATABASE_VERSION);
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        Iterator versions = ddr.getVersions(database);
        String newVersion = version;
        while (versions.hasNext()) {
            String tempVersion = (String)versions.next();
            if (tempVersion == null || tempVersion.trim().length() == 0) continue;
            if (tempVersion.equals(version)) {
                return version;
            }
            newVersion = tempVersion;
        }
        return newVersion;
    }

    public void setDatabaseVersion(String version) {
        this.setProperty(RDB_DATABASE_VERSION, version);
    }

    public String getConnectionName() {
        return this.persistenceProperties.getProperty(RDB_CONNECTION);
    }

    public void setConnectionName(String connectionName) {
        this.setProperty(RDB_CONNECTION, connectionName);
    }

    public String getSchemaName() {
        return this.persistenceProperties.getProperty(RDB_SCHEMA);
    }

    public void setSchemaName(String shemaName) {
        this.setProperty(RDB_SCHEMA, shemaName);
    }

    public String getConnectionUserName() {
        return this.persistenceProperties.getProperty(RDB_USER_NAME);
    }

    public void setConnectionUserName(String userName) {
        this.setProperty(RDB_USER_NAME, userName);
    }

    public String getConnectionPassword() {
        return this.persistenceProperties.getProperty(RDB_PASSWORD);
    }

    public void setConnectionPassword(String password) {
        this.setProperty(RDB_PASSWORD, password);
    }

    public String getParFileName() {
        String parFileName = this.persistenceProperties.getProperty(PAR_FILE_NAME);
        if (parFileName == null) {
            parFileName = String.valueOf(this.project.getName()) + ".jar";
        }
        return parFileName;
    }

    public void setParFileName(String parFileName) {
        this.setProperty(PAR_FILE_NAME, parFileName);
    }

    public String getPersistenceFileName() {
        String name = this.persistenceProperties.getProperty(PROP_PERSISTENCE_XML);
        if (name == null) {
            name = "persistence.xml";
        }
        return name;
    }

    public void setPersistenceFileName(String fileName) {
        this.setProperty(PROP_PERSISTENCE_XML, fileName);
    }

    public String getProperty(String key) {
        return this.persistenceProperties.getProperty(key);
    }
}

