/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io.ast;

import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.ast.AstRAnnotatedElement;
import org.eclipse.jsr220orm.generic.io.ast.AstRClass;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.generic.reflect.RField;

public class AstRField
extends AstRAnnotatedElement
implements RField {
    protected final AstRClass cls;
    protected final VariableDeclarationFragment varDec;
    protected final FieldDeclaration fieldDec;
    protected final ITypeBinding binding;

    public AstRField(AstRClass cls, FieldDeclaration fieldDec, VariableDeclarationFragment varDec, int relativeIndexInOwner) {
        super(cls.getFactory(), fieldDec.modifiers(), cls.getImportListHelper(), relativeIndexInOwner);
        this.cls = cls;
        this.varDec = varDec;
        this.fieldDec = fieldDec;
        this.binding = fieldDec.getType().resolveBinding();
        this.initAnnotations();
    }

    public String getName() {
        return this.varDec.getName().getFullyQualifiedName();
    }

    public String getTypeName() {
        return Utils.getTypeName(this.binding);
    }

    public String toString() {
        return this.getName();
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this.cls.getFullyQualifiedName()) + "." + this.getName();
    }

    public boolean isField() {
        return true;
    }

    public Map getLocation() {
        return Utils.createMarkerLocation((ASTNode)this.varDec.getName());
    }

    public RClass getRClass() {
        return this.cls;
    }

    public String[] getActualTypeArguments() {
        if (this.binding == null) {
            return null;
        }
        ITypeBinding[] ta = this.binding.getTypeArguments();
        int n = ta.length;
        if (n == 0) {
            return null;
        }
        String[] ans = new String[n];
        int i = 0;
        while (i < n) {
            ans[i] = Utils.getTypeName(ta[i]);
            ++i;
        }
        return ans;
    }
}

