/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io.ast;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.generic.io.ast.AstAnnotationProxyHandler;
import org.eclipse.jsr220orm.generic.io.ast.AstRClassFactory;
import org.eclipse.jsr220orm.generic.io.ast.ImportListHelper;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstRAnnotatedElement
implements RAnnotatedElement {
    protected final AstRClassFactory factory;
    protected final List modifierList;
    protected final ImportListHelper importListHelper;
    protected final int relativeIndexInOwner;
    protected Map<Class, Annotation> annotations;
    protected int modifierBits = -1;

    public AstRAnnotatedElement(AstRClassFactory factory, List modifierList, ImportListHelper importListHelper, int relativeIndexInOwner) {
        this.factory = factory;
        this.modifierList = modifierList;
        this.importListHelper = importListHelper;
        this.relativeIndexInOwner = relativeIndexInOwner;
    }

    protected void initAnnotations() {
        this.annotations = this.factory.createAnnotations(this, this.modifierList.iterator(), this.importListHelper);
    }

    public AstRClassFactory getFactory() {
        return this.factory;
    }

    public ImportListHelper getImportListHelper() {
        return this.importListHelper;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)this.annotations.get(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, boolean returnDefault) {
        Object ans = this.getAnnotation(annotationType);
        if (ans == null && returnDefault) {
            AstAnnotationProxyHandler h = new AstAnnotationProxyHandler(this, annotationType, this.importListHelper, null, this.modifierList);
            ans = h.newProxy();
            this.annotations.put(annotationType, (Annotation)ans);
        }
        return ans;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] all = new Annotation[this.annotations.size()];
        this.annotations.values().toArray(all);
        return all;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public abstract String getFullyQualifiedName();

    @Override
    public int getModifiers() {
        if (this.modifierBits < 0) {
            this.modifierBits = 0;
            for (Object o : this.modifierList) {
                if (!(o instanceof Modifier)) continue;
                this.modifierBits |= ((Modifier)o).getKeyword().toFlagValue();
            }
        }
        return this.modifierBits;
    }

    @Override
    public int getRelativeIndexInOwner() {
        return this.relativeIndexInOwner;
    }

    @Override
    public boolean isTypeEnum() {
        try {
            IType type = this.factory.getJavaProject().findType(this.getTypeName());
            return type != null && type.isEnum();
        }
        catch (JavaModelException e) {
            OrmPlugin.log((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isTypeSerializable() {
        try {
            return this.isTypeSerializableImp(this.factory.getJavaProject(), this.getTypeName());
        }
        catch (JavaModelException e) {
            OrmPlugin.log((Throwable)e);
            return false;
        }
    }

    protected boolean isTypeSerializableImp(IJavaProject javaProject, String name) throws JavaModelException {
        String n;
        IType type = javaProject.findType(name);
        if (type == null) {
            return false;
        }
        if ("java.io.Serializable".equals(type.getFullyQualifiedName())) {
            return true;
        }
        String[] stringArray = type.getSuperInterfaceTypeSignatures();
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            n = stringArray[n2];
            if (this.isTypeSerializableImp(javaProject, type, n)) {
                return true;
            }
            ++n2;
        }
        n = type.getSuperclassTypeSignature();
        return n != null && this.isTypeSerializableImp(javaProject, type, n);
    }

    protected boolean isTypeSerializableImp(IJavaProject javaProject, IType type, String n) throws JavaModelException {
        String sq = Signature.getSignatureQualifier((String)n);
        String sn = Signature.getSignatureSimpleName((String)n);
        n = sq.length() > 0 ? String.valueOf(sq) + "." + sn : sn;
        if (type.isBinary()) {
            return this.isTypeSerializableImp(javaProject, n);
        }
        String[][] rt = type.resolveType(n);
        return rt != null && this.isTypeSerializableImp(javaProject, n = String.valueOf(rt[0][0]) + "." + rt[0][1]);
    }
}

