/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io.ast;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jsr220orm.core.util.JdbcUtils;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.AnnotationRegistry;
import org.eclipse.jsr220orm.generic.io.ast.AstRAnnotatedElement;
import org.eclipse.jsr220orm.generic.io.ast.AstState;
import org.eclipse.jsr220orm.generic.io.ast.ImportListHelper;

public class AstAnnotationProxyHandler
implements InvocationHandler {
    protected final AstRAnnotatedElement owner;
    protected final AnnotationRegistry reg;
    protected final Class annotationType;
    protected final ImportListHelper importListHelper;
    protected final List modifierList;
    protected final LifeCycleManager lifeCycleManager;
    protected final AST ast;
    protected org.eclipse.jdt.core.dom.Annotation ann;
    protected Map defaultMap;
    protected Map<String, String> errorMap;
    protected boolean marker;
    protected static final String[] VALUE = new String[]{"value"};
    protected static final String[] EMPTY = new String[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AstAnnotationProxyHandler(AstRAnnotatedElement owner, Class annotationType, ImportListHelper importListHelper, org.eclipse.jdt.core.dom.Annotation ann, List modList) {
        Object ploc;
        this.owner = owner;
        this.reg = owner.getFactory().getAnnotationRegistry();
        this.annotationType = annotationType;
        this.importListHelper = importListHelper;
        this.ast = importListHelper.getRoot().getAST();
        this.ann = ann;
        this.lifeCycleManager = null;
        this.errorMap = this.getAstState().getAnnotationErrorMap(this, false);
        this.modifierList = modList == null && ann != null ? ((ploc = ann.getParent().getStructuralProperty(ann.getLocationInParent())) instanceof List ? (List)ploc : null) : modList;
    }

    public AstAnnotationProxyHandler(AstRAnnotatedElement owner, Class annotationType, ImportListHelper importListHelper, org.eclipse.jdt.core.dom.Annotation ann, LifeCycleManager lifeCycleManager) {
        this.owner = owner;
        this.reg = owner.getFactory().getAnnotationRegistry();
        this.annotationType = annotationType;
        this.importListHelper = importListHelper;
        this.ast = importListHelper.getRoot().getAST();
        this.ann = ann;
        this.modifierList = null;
        this.lifeCycleManager = lifeCycleManager;
        this.errorMap = this.getAstState().getAnnotationErrorMap(this, false);
        this.marker = this.reg.isMarker(annotationType);
    }

    public AstRAnnotatedElement getOwner() {
        return this.owner;
    }

    public Class getAnnotationType() {
        return this.annotationType;
    }

    public Annotation newProxy() {
        return (Annotation)Proxy.newProxyInstance(this.annotationType.getClassLoader(), new Class[]{this.annotationType, AnnotationEx.class}, (InvocationHandler)this);
    }

    protected AstState getAstState() {
        return this.owner.getFactory().getAstState();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object def;
        String methodName = method.getName();
        if (args != null && args.length == 1 && "get".equals(methodName)) {
            methodName = (String)args[0];
            method = this.annotationType.getDeclaredMethod(methodName, null);
            args = null;
        }
        if (args == null) {
            if (this.ann instanceof NormalAnnotation) {
                MemberValuePair p = this.findMemberValuePair(methodName);
                if (p != null) {
                    return this.convert(methodName, p.getValue(), method.getReturnType(), method.getDefaultValue());
                }
            } else if (this.ann instanceof SingleMemberAnnotation && "value".equals(methodName)) {
                SingleMemberAnnotation sa = (SingleMemberAnnotation)this.ann;
                return this.convert("value", sa.getValue(), method.getReturnType(), method.getDefaultValue());
            }
            if ("getErrorMap".equals(methodName)) {
                return this.errorMap;
            }
            if ("toString".equals(methodName)) {
                return this.ann == null ? this.annotationType.getSimpleName() : this.ann.toString();
            }
            if ("delete".equals(methodName)) {
                if (this.ann != null) {
                    this.ann.delete();
                    this.ann = null;
                }
                return null;
            }
            if ("getValueCount".equals(methodName)) {
                if (this.ann instanceof NormalAnnotation) {
                    return ((NormalAnnotation)this.ann).values().size();
                }
                if (this.ann instanceof SingleMemberAnnotation) {
                    return 1;
                }
                return 0;
            }
            if ("getValueNames".equals(methodName)) {
                return this.getValueNames();
            }
        } else if (args.length == 2) {
            if ("set".equals(methodName)) {
                this.set((String)args[0], args[1], false);
                return null;
            }
            if ("setDefault".equals(methodName)) {
                if (this.defaultMap == null) {
                    this.defaultMap = new HashMap();
                }
                this.defaultMap.put(args[0], args[1]);
            } else if ("setArraySize".equals(methodName)) {
                return this.setArraySize((String)args[0], (Integer)args[1]);
            }
        } else if (args.length == 1) {
            String s;
            if ("getAsString".equals(methodName)) {
                s = this.getAsString((String)args[0]);
                if (s != null) {
                    return s;
                }
            } else {
                if ("hasValue".equals(methodName)) {
                    if (this.ann instanceof NormalAnnotation) {
                        if (this.findMemberValuePair((String)args[0]) != null) {
                            return true;
                        }
                        return false;
                    }
                    if (this.ann instanceof SingleMemberAnnotation) {
                        return "value".equals(args[0]);
                    }
                    return false;
                }
                if ("getLocation".equals(methodName)) {
                    return this.getLocation((String)args[0]);
                }
                if ("setMarker".equals(methodName)) {
                    this.marker = (Boolean)args[0];
                    if (this.marker && this.ann == null) {
                        this.ann = this.ast.newMarkerAnnotation();
                        this.ann.setTypeName((Name)this.ast.newSimpleName(this.annotationType.getSimpleName()));
                        this.modifierList.add(this.chooseModifierListIndex(), this.ann);
                        this.importListHelper.ensureImport(this.annotationType.getName());
                    }
                } else if ("getClassValue".equals(methodName)) {
                    s = this.getAsString((String)args[0]);
                    if (s != null) {
                        if (s.endsWith(".class")) {
                            return s.substring(0, s.length() - 6);
                        }
                        return s;
                    }
                } else {
                    if ("appendArrayElement".equals(methodName)) {
                        return this.appendArrayElement((String)args[0]);
                    }
                    if ("getArraySize".equals(methodName)) {
                        return this.getArraySize((String)args[0]);
                    }
                }
            }
        } else if (args.length == 3 && "set".equals(methodName)) {
            this.set((String)args[0], args[1], (Boolean)args[2]);
            return null;
        }
        if (this.defaultMap != null && (def = this.defaultMap.get(methodName)) != null) {
            return def;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isAnnotation()) {
            return this.convertAnnotation(methodName, null, returnType);
        }
        return method.getDefaultValue();
    }

    protected String getAsString(String name) {
        if (this.ann instanceof NormalAnnotation) {
            MemberValuePair p = this.findMemberValuePair(name);
            if (p != null) {
                return ASTFlattener.asString((ASTNode)p.getValue());
            }
        } else if (this.ann instanceof SingleMemberAnnotation && "value".equals(name)) {
            SingleMemberAnnotation sa = (SingleMemberAnnotation)this.ann;
            return ASTFlattener.asString((ASTNode)sa.getValue());
        }
        return null;
    }

    protected MemberValuePair findMemberValuePair(String name) {
        List values = ((NormalAnnotation)this.ann).values();
        int i = values.size() - 1;
        while (i >= 0) {
            MemberValuePair p = (MemberValuePair)values.get(i);
            if (p.getName().getIdentifier().equals(name)) {
                return p;
            }
            --i;
        }
        return null;
    }

    protected Object convert(String name, Expression value, Class cls, Object def) {
        Object ans = null;
        switch (value.getNodeType()) {
            case 45: {
                ans = ((StringLiteral)value).getLiteralValue();
                break;
            }
            case 40: {
                String qn = ((QualifiedName)value).getFullyQualifiedName();
                ans = this.reg.getNamedValue(qn);
                if (ans != null) break;
                this.setError(name, "Invalid value: " + qn);
                break;
            }
            case 34: {
                try {
                    ans = Integer.parseInt(((NumberLiteral)value).getToken());
                }
                catch (NumberFormatException e) {
                    this.setError(name, e.toString());
                }
                break;
            }
            case 9: {
                ans = ((BooleanLiteral)value).booleanValue();
                break;
            }
            case 77: {
                ans = this.convertAnnotation(name, (org.eclipse.jdt.core.dom.Annotation)value, cls);
                break;
            }
            case 4: {
                if (cls.isArray()) {
                    Class<?> componentType = cls.getComponentType();
                    if (componentType.isAnnotation()) {
                        ans = this.convertAnnotationArray(name, (ArrayInitializer)value, cls.getComponentType(), def);
                        break;
                    }
                    ArrayInitializer ai = (ArrayInitializer)value;
                    int n = ai.expressions().size();
                    Object[] a = (Object[])Array.newInstance(componentType, n);
                    int i = 0;
                    while (i < n) {
                        a[i] = this.convert(name, (Expression)ai.expressions().get(i), componentType, null);
                        ++i;
                    }
                    if (this.getError(name) != null) {
                        return def;
                    }
                    return a;
                }
            }
            default: {
                this.setError(name, "Cannot convert to " + cls.getName() + ": " + value);
                return def;
            }
        }
        if (cls.isPrimitive()) {
            cls = Utils.PRIM_WRAPPER_MAP.get(cls);
        }
        if (cls.isInstance(ans)) {
            return ans;
        }
        if (cls.isArray() && cls.getComponentType().isInstance(ans)) {
            Object[] a = (Object[])Array.newInstance(cls.getComponentType(), 1);
            a[0] = ans;
            return a;
        }
        this.setError(name, "Expected " + cls.getName() + ": " + ans);
        return def;
    }

    protected void setError(String name, String msg) {
        if (this.errorMap == null) {
            this.errorMap = this.getAstState().getAnnotationErrorMap(this, true);
        }
        this.errorMap.put(name, msg);
    }

    protected String getError(String name) {
        if (this.errorMap == null) {
            return null;
        }
        return this.errorMap.get(name);
    }

    protected Object convert(Expression value) {
        switch (value.getNodeType()) {
            case 45: {
                return ((StringLiteral)value).getLiteralValue();
            }
            case 40: {
                QualifiedName qn = (QualifiedName)value;
                return this.reg.getNamedValue(qn.getFullyQualifiedName());
            }
            case 34: {
                try {
                    return Integer.parseInt(((NumberLiteral)value).getToken());
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
            case 9: {
                return ((BooleanLiteral)value).booleanValue();
            }
        }
        return null;
    }

    protected Expression convert(String name, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            ArrayInitializer ai = this.ast.newArrayInitializer();
            Object[] a = (Object[])value;
            int i = 0;
            while (i < a.length) {
                Expression e = this.convert(name, a[i]);
                if (e != null) {
                    ai.expressions().add(e);
                }
                ++i;
            }
            return ai;
        }
        if (value instanceof String) {
            if (this.getValueType(name) == Class.class) {
                Name cname = this.ast.newName((String)value);
                TypeLiteral t = this.ast.newTypeLiteral();
                t.setType((Type)this.ast.newSimpleType(cname));
                return t;
            }
            StringLiteral v = this.ast.newStringLiteral();
            v.setLiteralValue((String)value);
            return v;
        }
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            QualifiedName qn = this.ast.newQualifiedName((Name)this.ast.newSimpleName(e.getClass().getSimpleName()), this.ast.newSimpleName(e.name()));
            return qn;
        }
        if (value instanceof Integer) {
            return this.ast.newNumberLiteral(value.toString());
        }
        if (value instanceof Boolean) {
            return this.ast.newBooleanLiteral(((Boolean)value).booleanValue());
        }
        return null;
    }

    protected Object getDefaultValue(String name) {
        if (this.defaultMap != null && this.defaultMap.containsKey(name)) {
            return this.defaultMap.get(name);
        }
        return this.reg.getDefault(this.annotationType, name);
    }

    protected void set(String name, Object value, boolean treatEmptyAsNull) {
        if (this.errorMap != null && this.errorMap.containsKey(name)) {
            return;
        }
        if (treatEmptyAsNull && value instanceof String && ((String)value).length() == 0) {
            value = null;
        }
        Expression astValue = null;
        Object def = this.getDefaultValue(name);
        if (def == value || def != null && def.equals(value)) {
            value = null;
            astValue = null;
        } else {
            String s;
            if ("jdbcType".equals(name) && value instanceof Integer && (s = JdbcUtils.getQualifiedJdbcTypeName((Integer)((Integer)value))) != null) {
                astValue = this.ast.newName(s);
                this.importListHelper.ensureImport("java.sql.Types");
            }
            if (astValue == null) {
                astValue = this.convert(name, value);
            }
        }
        if (astValue != null) {
            if (value instanceof Enum) {
                this.importListHelper.ensureImport(value.getClass().getName());
            } else {
                Class<?> cls = value.getClass();
                if (cls.isArray() && cls.getComponentType().isEnum()) {
                    this.importListHelper.ensureImport(cls.getComponentType().getName());
                }
            }
        }
        if (this.ann == null && astValue != null) {
            this.createOurAstAnnotation();
        }
        if (this.ann instanceof NormalAnnotation) {
            NormalAnnotation na = (NormalAnnotation)this.ann;
            List values = na.values();
            for (MemberValuePair p : values) {
                if (!p.getName().getFullyQualifiedName().equals(name)) continue;
                if (astValue == null) {
                    values.remove(p);
                    if (values.isEmpty()) {
                        if (this.marker) {
                            MarkerAnnotation ma = this.ast.newMarkerAnnotation();
                            Name typeName = (Name)ASTNode.copySubtree((AST)this.ast, (ASTNode)na.getTypeName());
                            ma.setTypeName(typeName);
                            Utils.replace((ASTNode)na, (ASTNode)ma);
                            this.ann = ma;
                        } else {
                            if (this.lifeCycleManager != null) {
                                this.lifeCycleManager.remove(this);
                            } else {
                                this.ann.delete();
                            }
                            this.ann = null;
                        }
                    }
                } else {
                    p.setValue(astValue);
                }
                return;
            }
            if (astValue != null) {
                values.add(this.chooseIndexForNewPair(name, values), this.createMemberValuePair(name, astValue));
            }
        } else if (this.ann instanceof MarkerAnnotation) {
            if (astValue != null) {
                this.convertMarkerToNormal(name, astValue);
            }
        } else if (this.ann instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation sa = (SingleMemberAnnotation)this.ann;
            if (astValue != null) {
                sa.setValue(astValue);
            } else if (this.reg.isMarker(this.annotationType)) {
                MarkerAnnotation ma = this.ast.newMarkerAnnotation();
                Name typeName = (Name)ASTNode.copySubtree((AST)this.ast, (ASTNode)sa.getTypeName());
                ma.setTypeName(typeName);
                Utils.replace((ASTNode)sa, (ASTNode)ma);
                this.ann = ma;
            } else {
                this.ann.delete();
                this.ann = null;
            }
        }
    }

    protected int chooseIndexForNewPair(String name, List values) {
        Map<String, Integer> map = this.reg.getOrderingMap(this.annotationType);
        Integer pos = map.get(name);
        if (pos == null) {
            return values.size();
        }
        int posi = pos;
        int n = values.size();
        int i = 0;
        while (i < n) {
            MemberValuePair p = (MemberValuePair)values.get(i);
            String pname = p.getName().getFullyQualifiedName();
            Integer q = map.get(pname);
            if (q == null || posi < q) {
                return i;
            }
            ++i;
        }
        return n;
    }

    protected void convertMarkerToNormal(String name, Expression astValue) {
        NormalAnnotation na = this.ast.newNormalAnnotation();
        Name typeName = (Name)ASTNode.copySubtree((AST)this.ast, (ASTNode)this.ann.getTypeName());
        na.setTypeName(typeName);
        na.values().add(this.createMemberValuePair(name, astValue));
        Utils.replace((ASTNode)this.ann, (ASTNode)na);
        this.ann = na;
    }

    protected void createOurAstAnnotation() {
        this.ann = this.reg.isSingleValue(this.annotationType) ? this.ast.newSingleMemberAnnotation() : this.ast.newNormalAnnotation();
        this.ann.setTypeName((Name)this.ast.newSimpleName(this.annotationType.getSimpleName()));
        if (this.modifierList == null) {
            this.lifeCycleManager.create(this);
        } else {
            this.modifierList.add(this.chooseModifierListIndex(), this.ann);
        }
        this.importListHelper.ensureImport(this.annotationType.getName());
    }

    protected MemberValuePair createMemberValuePair(String name, Expression value) {
        MemberValuePair p = this.ast.newMemberValuePair();
        p.setName(this.ast.newSimpleName(name));
        p.setValue(value);
        return p;
    }

    protected int chooseModifierListIndex() {
        int n = this.modifierList.size();
        int pos = this.reg.getOrderingIndex(this.ann.getTypeName().getFullyQualifiedName());
        int i = 0;
        while (i < n) {
            Object o = this.modifierList.get(i);
            if (o instanceof org.eclipse.jdt.core.dom.Annotation) {
                String s = ((org.eclipse.jdt.core.dom.Annotation)o).getTypeName().getFullyQualifiedName();
                if (pos < this.reg.getOrderingIndex(s)) {
                    return i;
                }
            } else {
                return i;
            }
            ++i;
        }
        return n;
    }

    protected Map getLocation(String name) {
        MemberValuePair p;
        if (this.ann == null) {
            return this.owner.getLocation();
        }
        if (this.ann instanceof NormalAnnotation && (p = this.findMemberValuePair(name)) != null) {
            return Utils.createMarkerLocation((ASTNode)p);
        }
        return Utils.createMarkerLocation((ASTNode)this.ann);
    }

    protected Object convertAnnotation(final String name, org.eclipse.jdt.core.dom.Annotation e, Class cls) {
        boolean array = cls.isArray();
        Class<?> annType = array ? cls.getComponentType() : cls;
        LifeCycleManager lcm = new LifeCycleManager(){

            public void create(AstAnnotationProxyHandler h) {
                if (AstAnnotationProxyHandler.this.ann == null) {
                    AstAnnotationProxyHandler.this.createOurAstAnnotation();
                }
                if (AstAnnotationProxyHandler.this.ann instanceof NormalAnnotation) {
                    NormalAnnotation na = (NormalAnnotation)AstAnnotationProxyHandler.this.ann;
                    na.values().add(AstAnnotationProxyHandler.this.createMemberValuePair(name, (Expression)h.ann));
                } else {
                    SingleMemberAnnotation sa = (SingleMemberAnnotation)AstAnnotationProxyHandler.this.ann;
                    sa.setValue((Expression)h.ann);
                }
            }

            public void remove(AstAnnotationProxyHandler h) {
                AstAnnotationProxyHandler.this.set(name, null, false);
            }
        };
        AstAnnotationProxyHandler h = new AstAnnotationProxyHandler(this.owner, annType, this.importListHelper, e, lcm);
        Annotation p = h.newProxy();
        if (array) {
            Object[] ans = (Object[])Array.newInstance(annType, 1);
            ans[0] = p;
            return ans;
        }
        return p;
    }

    protected Object convertAnnotationArray(String name, ArrayInitializer ai, Class annotationType, Object def) {
        int n = ai.expressions().size();
        Object[] ans = (Object[])Array.newInstance(annotationType, n);
        int i = 0;
        while (i < n) {
            Expression e = (Expression)ai.expressions().get(i);
            if (!(e instanceof org.eclipse.jdt.core.dom.Annotation)) {
                this.setError(name, "Expected " + annotationType.getName() + ": " + e);
                return def;
            }
            AstAnnotationProxyHandler h = new AstAnnotationProxyHandler(this.owner, annotationType, this.importListHelper, (org.eclipse.jdt.core.dom.Annotation)e, null);
            ans[i] = h.newProxy();
            ++i;
        }
        return ans;
    }

    protected boolean setArraySize(String name, int size) {
        if (this.errorMap != null && this.errorMap.containsKey(name)) {
            return false;
        }
        ArrayInitializer ai = this.getOrCreateArrayInitializer(name);
        List expressions = ai.expressions();
        int n = expressions.size();
        if (n == size) {
            return true;
        }
        if (n > size) {
            while (n > size) {
                ((Expression)expressions.get(--n)).delete();
            }
        } else {
            Class<?> componentType = this.getValueType(name).getComponentType();
            int i = n;
            while (i < size) {
                Object a = this.reg.isSingleValue(componentType) ? this.ast.newSingleMemberAnnotation() : this.ast.newNormalAnnotation();
                a.setTypeName((Name)this.ast.newSimpleName(componentType.getSimpleName()));
                expressions.add(a);
                this.importListHelper.ensureImport(componentType.getName());
                ++i;
            }
        }
        return true;
    }

    protected ArrayInitializer getOrCreateArrayInitializer(String name) {
        ArrayInitializer ai;
        if (this.ann == null) {
            this.createOurAstAnnotation();
        }
        if (this.ann instanceof NormalAnnotation) {
            MemberValuePair p = this.findMemberValuePair(name);
            if (p != null) {
                Expression v = p.getValue();
                if (v instanceof ArrayInitializer) {
                    ai = (ArrayInitializer)v;
                } else {
                    ai = this.ast.newArrayInitializer();
                    p.setValue((Expression)ai);
                }
            } else {
                NormalAnnotation na = (NormalAnnotation)this.ann;
                ai = this.ast.newArrayInitializer();
                na.values().add(this.createMemberValuePair(name, (Expression)ai));
            }
        } else if (this.ann instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation sa = (SingleMemberAnnotation)this.ann;
            Expression v = sa.getValue();
            if (v instanceof ArrayInitializer) {
                ai = (ArrayInitializer)v;
            } else {
                ai = this.ast.newArrayInitializer();
                sa.setValue((Expression)ai);
            }
        } else {
            ai = this.ast.newArrayInitializer();
            this.convertMarkerToNormal(name, (Expression)ai);
        }
        return ai;
    }

    protected int getArraySize(String name) {
        SingleMemberAnnotation sa;
        Expression v;
        if (this.ann instanceof NormalAnnotation) {
            Expression v2;
            MemberValuePair p = this.findMemberValuePair(name);
            if (p != null && (v2 = p.getValue()) instanceof ArrayInitializer) {
                return ((ArrayInitializer)v2).expressions().size();
            }
        } else if (this.ann instanceof SingleMemberAnnotation && (v = (sa = (SingleMemberAnnotation)this.ann).getValue()) instanceof ArrayInitializer) {
            return ((ArrayInitializer)v).expressions().size();
        }
        return 0;
    }

    protected Object appendArrayElement(final String name) {
        final Class<?> componentType = this.getValueType(name).getComponentType();
        LifeCycleManager lcm = new LifeCycleManager(){

            public void create(AstAnnotationProxyHandler h) {
                ArrayInitializer ai = AstAnnotationProxyHandler.this.getOrCreateArrayInitializer(name);
                List expressions = ai.expressions();
                expressions.add(h.ann);
                AstAnnotationProxyHandler.this.importListHelper.ensureImport(componentType.getName());
            }

            public void remove(AstAnnotationProxyHandler h) {
                if (h.ann != null) {
                    h.ann.delete();
                    h.ann = null;
                }
            }
        };
        AstAnnotationProxyHandler h = new AstAnnotationProxyHandler(this.owner, componentType, this.importListHelper, null, lcm);
        return h.newProxy();
    }

    protected Class getValueType(String name) {
        try {
            Method m = this.annotationType.getDeclaredMethod(name, null);
            return m.getReturnType();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String[] getValueNames() {
        if (this.ann instanceof NormalAnnotation) {
            List values = ((NormalAnnotation)this.ann).values();
            int n = values.size();
            String[] a = new String[n];
            int i = 0;
            while (i < n) {
                MemberValuePair p = (MemberValuePair)values.get(i);
                a[i] = p.getName().getFullyQualifiedName();
                ++i;
            }
            return a;
        }
        if (this.ann instanceof SingleMemberAnnotation) {
            return VALUE;
        }
        return EMPTY;
    }

    protected static interface LifeCycleManager {
        public void create(AstAnnotationProxyHandler var1);

        public void remove(AstAnnotationProxyHandler var1);
    }
}

