/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.AttributeIO;
import org.eclipse.jsr220orm.generic.io.ColumnNameStrategy;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

public class CollectionAttributeIO
extends AttributeIO {
    protected CollectionAttribute amd;
    protected TypeMetaData oldElementType;
    protected String defaultJoinTableName;
    public static final IntOption MAPPING_MANY_TO_MANY = new IntOption(1, "Many to many", "Join table", Utils.getImage("ManyToMany16"));
    public static final IntOption MAPPING_ONE_TO_MANY = new IntOption(2, "One to many", "Inverse foreign key or join table", Utils.getImage("OneToMany16"));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public CollectionAttributeIO(EntityIO entityIO) {
        super(entityIO);
    }

    public AttributeMetaData getAttributeMetaData() {
        return this.amd;
    }

    public void getPossibleMappings(List ans) {
        ans.add(MAPPING_MANY_TO_MANY);
        ans.add(MAPPING_ONE_TO_MANY);
        ans.add(MAPPING_NOT_PERSISTENT);
    }

    public IntOption getMapping() {
        if (this.amd == null || this.amd.isNonPersistent()) {
            return MAPPING_NOT_PERSISTENT;
        }
        if (this.amd.isOneToMany()) {
            return MAPPING_ONE_TO_MANY;
        }
        return MAPPING_MANY_TO_MANY;
    }

    public void setMapping(IntOption mapping) {
        if (MAPPING_NOT_PERSISTENT.equals((Object)mapping)) {
            this.setPersistent(false);
        } else {
            this.setPersistent(true);
            this.amd.setOneToMany(MAPPING_ONE_TO_MANY.equals((Object)mapping));
        }
    }

    public boolean updateModelFromMetaData(RClass cls, RAnnotatedElement attribute, boolean metaDataChanged) {
        String targetEntity;
        String[] ta;
        AnnotationEx main;
        this.amd = (CollectionAttribute)this.initAttributeMetaData((AttributeMetaData)this.amd, attribute, MetadataPackage.eINSTANCE.getCollectionAttribute());
        if (this.amd.isNonPersistent()) {
            return true;
        }
        if (!this.hasTableAndPrimaryKey(this.entityIO.getEntityMetaData())) {
            return false;
        }
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        if (!emd.isEntity()) {
            this.updateModelCleanup();
            this.entityIO.addProblem(String.valueOf(this.getTypeName(emd)) + " classes " + "may only have basic attributes", attribute.getLocation());
            return true;
        }
        GenericEntityModelManager mm = this.entityIO.getModelManager();
        EntityModel model = mm.getEntityModel();
        ManyToMany manyToMany = attribute.getAnnotation(ManyToMany.class);
        OneToMany oneToMany = attribute.getAnnotation(OneToMany.class);
        this.amd.setOneToMany(oneToMany != null);
        if (oneToMany != null) {
            main = (AnnotationEx)oneToMany;
            this.setFetchType((AttributeMetaData)this.amd, oneToMany.fetch());
            this.amd.setCascadeType(this.getCascadeBits(oneToMany.cascade()));
            if (manyToMany != null) {
                this.entityIO.addProblem("ManyToMany and OneToMany may not be used together", ((AnnotationEx)oneToMany).getLocation(null));
            }
        } else {
            if (manyToMany == null) {
                manyToMany = attribute.getAnnotation(ManyToMany.class, true);
            }
            main = (AnnotationEx)manyToMany;
            this.setFetchType((AttributeMetaData)this.amd, manyToMany.fetch());
            this.amd.setCascadeType(this.getCascadeBits(manyToMany.cascade()));
        }
        if ((ta = attribute.getActualTypeArguments()) == null || ta.length != 1) {
            targetEntity = main.getClassValue("targetEntity");
            if (targetEntity == null) {
                this.entityIO.addProblem("Non-generic collections must specify targetEntity", main.getLocation(null));
            }
        } else {
            targetEntity = ta[0];
        }
        EntityMetaData target = null;
        if (targetEntity != null) {
            TypeMetaData tmd = model.findTypeByClassName(targetEntity);
            if (tmd == null) {
                String msg = mm.isPossibleEntity(targetEntity) ? "Target " + targetEntity + " is not persistent" : "Entity not found: '" + targetEntity + "'";
                this.entityIO.addProblem(msg, main.getLocation("targetEntity"));
            } else if (!(tmd instanceof EntityMetaData)) {
                this.entityIO.addProblem("Collections of non-entity types are not supported", main.getLocation("targetEntity"));
            } else {
                target = (EntityMetaData)tmd;
                if (target.getEntityType() != 1) {
                    this.entityIO.addProblem(String.valueOf(target.getShortName()) + " is " + this.getTypeName(target) + " so it may not be the " + "target of a persistent relationship", attribute.getLocation());
                    this.entityIO.addDependencyOn(target);
                    target = null;
                } else if (!this.hasTableAndPrimaryKey(target)) {
                    return false;
                }
            }
        }
        this.oldElementType = target;
        this.amd.setElementType(this.oldElementType);
        this.entityIO.addDependencyOn(target);
        OrderBy orderBy = attribute.getAnnotation(OrderBy.class);
        if (orderBy != null) {
            this.amd.setOrderBy(orderBy.value());
        } else {
            this.amd.setOrderBy(null);
        }
        if (target == null) {
            this.updateModelCleanup();
            return true;
        }
        boolean usingMappedBy = this.updateModelMappedBy(main, target);
        if (usingMappedBy) {
            OrmTable joinTable = this.amd.getJoinTable();
            if (joinTable != null) {
                joinTable.delete();
                this.amd.setJoinTable(null);
            }
        } else {
            this.updateModelJoinTable(attribute, metaDataChanged);
        }
        return true;
    }

    protected void updateModelCleanup() {
        OrmTable joinTable = this.amd.getJoinTable();
        if (joinTable != null) {
            joinTable.delete();
            this.amd.setJoinTable(null);
        }
        this.amd.setMappedBy(null);
    }

    protected boolean updateModelMappedBy(AnnotationEx main, EntityMetaData target) {
        String mappedBy = (String)main.get("mappedBy");
        AttributeMetaData mb = null;
        boolean usingMappedBy = mappedBy != null && mappedBy.length() > 0;
        if (usingMappedBy) {
            Class expect;
            mb = this.getMappedByAttribute(main, mappedBy, target);
            Class clazz = expect = this.amd.isOneToMany() ? ReferenceAttribute.class : CollectionAttribute.class;
            if (expect.isInstance(mb)) {
                if (this.amd.isOneToMany()) {
                    if (mb.getJavaType() != this.entityIO.getEntityMetaData()) {
                        this.entityIO.addProblem("Reference '" + mappedBy + "' has incorrect type: " + mb.getJavaType().getClassName(), main.getLocation("mappedBy"));
                        mb = null;
                    }
                } else {
                    CollectionAttribute ca = (CollectionAttribute)mb;
                    TypeMetaData caet = ca.getElementType();
                    if (caet != this.entityIO.getEntityMetaData()) {
                        if (caet != null) {
                            this.entityIO.addProblem("Collection '" + mappedBy + "' contains " + "incorrect type: " + caet.getClassName(), main.getLocation("mappedBy"));
                        }
                        mb = null;
                    }
                }
            } else if (mb != null) {
                this.entityIO.addProblem("Attribute '" + mappedBy + "' is not valid for mappedBy", main.getLocation("mappedBy"));
                mb = null;
            }
        }
        this.amd.setMappedBy(mb);
        return usingMappedBy;
    }

    protected void updateModelJoinTable(RAnnotatedElement attribute, boolean metaDataChanged) {
        GenericEntityModelManager mm = this.entityIO.getModelManager();
        EntityMetaData target = (EntityMetaData)this.amd.getElementType();
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        OrmTable destTable = target.getTable();
        OrmTable srcTable = emd.getTable();
        destTable.getPrimaryKeyList();
        srcTable.getPrimaryKeyList();
        JoinTable joinTable = attribute.getAnnotation(JoinTable.class, true);
        Table tableAnn = joinTable.table();
        OrmTable table = this.entityIO.ensureTable(this.amd.getJoinTable());
        table.setParentElement((MetadataElement)this.amd);
        table.setComment(this.getComment((AttributeMetaData)this.amd));
        String tableName = tableAnn.name();
        this.defaultJoinTableName = mm.getDefaultJoinTableName(this.amd, srcTable, destTable);
        if (tableName.length() == 0) {
            tableName = this.defaultJoinTableName;
        }
        table.setName(tableName);
        table.setCatalog(tableAnn.catalog());
        table.setSchema(tableAnn.schema());
        Object[] jca = joinTable.joinColumns();
        Join srcJoin = this.entityIO.getJoinIO().updateModelJoin(this.amd.getSrcJoin(), null, jca.length == 0 ? null : jca, ((AnnotationEx)joinTable).getLocation("joinColumns"), metaDataChanged, table, srcTable, mm.getJoinTableOwnerCNS(this.amd), this.getComment((AttributeMetaData)this.amd), false, mm.getColumnPositionPrimaryKey());
        if (this.amd.getSrcJoin() != srcJoin) {
            this.amd.setSrcJoin(srcJoin);
        }
        jca = joinTable.inverseJoinColumns();
        Join destJoin = this.entityIO.getJoinIO().updateModelJoin(this.amd.getDestJoin(), null, jca.length == 0 ? null : jca, ((AnnotationEx)joinTable).getLocation("inverseJoinColumns"), metaDataChanged, table, destTable, mm.getJoinTableInverseCNS(this.amd), this.getComment((AttributeMetaData)this.amd), this.amd.isOptional(), mm.getColumnPositionForeignKey());
        if (this.amd.getDestJoin() != destJoin) {
            this.amd.setDestJoin(destJoin);
        }
        if (srcJoin != null) {
            for (OrmColumn c : srcJoin.getSrcColumns()) {
                if (c.isPrimaryKey()) continue;
                table.getPrimaryKeyList().add((Object)c);
            }
        }
        if (destJoin != null) {
            boolean oneToMany = this.amd.isOneToMany();
            for (OrmColumn c : destJoin.getSrcColumns()) {
                if (c.isPrimaryKey()) {
                    if (!oneToMany) continue;
                    table.getPrimaryKeyList().remove((Object)c);
                    continue;
                }
                if (oneToMany) continue;
                table.getPrimaryKeyList().add((Object)c);
            }
        }
        table.sortColumns();
        if (this.amd.getJoinTable() != table) {
            this.amd.setJoinTable(table);
        }
    }

    public void updateMetaDataFromModel(RClass cls, RAnnotatedElement attribute) {
        TypeMetaData elementType;
        AnnotationEx toDelete;
        GenericEntityModelManager mm = this.getModelManager();
        if (this.amd.isNonPersistent()) {
            Utils.removeAnnotation(attribute, OneToMany.class);
            Utils.removeAnnotation(attribute, ManyToMany.class);
            Utils.removeAnnotation(attribute, JoinTable.class);
            this.ensureTransient(attribute);
            return;
        }
        Utils.removeAnnotation(attribute, Transient.class);
        AnnotationEx main = (AnnotationEx)attribute.getAnnotation(this.amd.isOneToMany() ? OneToMany.class : ManyToMany.class, true);
        if (main.getValueCount() == 0 && (toDelete = (AnnotationEx)attribute.getAnnotation(this.amd.isOneToMany() ? ManyToMany.class : OneToMany.class)) != null) {
            toDelete.delete();
        }
        if ((elementType = this.amd.getElementType()) == null) {
            return;
        }
        String[] ta = attribute.getActualTypeArguments();
        if (ta == null || ta.length != 1) {
            main.set("targetEntity", this.amd.getElementType().getClassName());
        } else {
            main.set("targetEntity", null);
        }
        AttributeMetaData mb = this.amd.getMappedBy();
        main.set("mappedBy", mb == null ? null : mb.getName());
        if (mb == null) {
            main.setMarker(this.amd.isOneToMany() || mm.isUseMarkerAnnotations());
        } else {
            Utils.removeAnnotation(attribute, JoinTable.class);
        }
        Utils.setIfNotNull(main, "fetch", this.getFetchType((AttributeMetaData)this.amd));
        main.set("cascade", this.getCascadeTypes(this.amd.getCascadeType()));
        String ob = this.amd.getOrderBy();
        if (ob == null) {
            Utils.removeAnnotation(attribute, OrderBy.class);
        } else {
            AnnotationEx orderBy = (AnnotationEx)attribute.getAnnotation(OrderBy.class, true);
            orderBy.set("value", ob);
        }
        OrmTable table = this.amd.getJoinTable();
        if (table == null || this.oldElementType != elementType) {
            return;
        }
        EntityMetaData target = (EntityMetaData)this.amd.getElementType();
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        target.getTable();
        emd.getTable();
        JoinTable joinTable = attribute.getAnnotation(JoinTable.class, true);
        AnnotationEx tableAnn = (AnnotationEx)joinTable.table();
        tableAnn.setDefault("name", this.defaultJoinTableName);
        tableAnn.set("name", table.getName(), true);
        tableAnn.set("catalog", table.getCatalog(), true);
        tableAnn.set("schema", table.getSchema(), true);
        this.updateMetaDataJoin((AnnotationEx)joinTable, this.amd.getSrcJoin(), "joinColumns", mm.getJoinTableOwnerCNS(this.amd));
        this.updateMetaDataJoin((AnnotationEx)joinTable, this.amd.getDestJoin(), "inverseJoinColumns", mm.getJoinTableInverseCNS(this.amd));
    }

    protected void updateMetaDataJoin(AnnotationEx joinTableEx, Join join, String name, ColumnNameStrategy cns) {
        if (join == null) {
            return;
        }
        EList pairList = join.getPairList();
        int n = pairList.size();
        if (joinTableEx.setArraySize(name, n)) {
            JoinColumn[] a = (JoinColumn[])joinTableEx.get(name);
            int i = 0;
            while (i < n) {
                this.entityIO.getJoinIO().updateMetaDataJoinColumn((AnnotationEx)a[i], join, (JoinPair)pairList.get(i), cns, false);
                ++i;
            }
            if (n > 1) {
                i = 0;
                while (i < n) {
                    AnnotationEx jc = (AnnotationEx)a[i];
                    int c = jc.getValueCount();
                    if (jc.hasValue("referencedColumnName")) {
                        --c;
                    }
                    if (c > 0) break;
                    ++i;
                }
                if (i == n) {
                    joinTableEx.set(name, null);
                }
            } else if (n == 1) {
                AnnotationEx jc = (AnnotationEx)a[0];
                if (jc.getValueCount() == 0) {
                    joinTableEx.set(name, null);
                }
            } else {
                joinTableEx.set(name, null);
            }
        }
    }

    public List getValidMappedByAttributes() {
        TypeMetaData et = this.amd.getElementType();
        if (!(et instanceof EntityMetaData)) {
            return Collections.EMPTY_LIST;
        }
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        EntityMetaData target = (EntityMetaData)et;
        ArrayList<AttributeMetaData> ans = new ArrayList<AttributeMetaData>();
        boolean oneToMany = this.amd.isOneToMany();
        Class expect = oneToMany ? ReferenceAttribute.class : CollectionAttribute.class;
        for (AttributeMetaData a : target.getAttributeList()) {
            if (a.getMappedBy() != null || !expect.isInstance(a)) continue;
            if (oneToMany) {
                if (a.getJavaType() != emd) continue;
                ans.add(a);
                continue;
            }
            if (((CollectionAttribute)a).getElementType() != emd) continue;
            ans.add(a);
        }
        return ans;
    }
}

