/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.internal.ui.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jsr220Orm.generic.xml.VendorDefinitionDocument;
import org.eclipse.jsr220Orm.xml.EntityManagerDocument;
import org.eclipse.jsr220orm.core.internal.product.OrmProduct;
import org.eclipse.jsr220orm.core.internal.product.OrmProductRegistry;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.jsr220orm.generic.GenericPlugin;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.internal.ui.config.FileSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPropertyComposite
extends Composite {
    private Label lPersistence = null;
    private Text tPersistence = null;
    private Button bPersistence = null;
    private Label lParFile = null;
    private Text tParFile = null;
    private Button bParFile = null;
    private Group cProperties = null;
    private Table tProperties = null;
    private Button bAdd = null;
    private Button bRemove = null;
    private IProject project;
    private Button bNew = null;
    private TableViewer tableViewer;
    private EntityManagerDocument.EntityManager.Properties properties;
    private EntityManagerDocument emd;
    private Label lContextName;
    private Text tContextName;

    public GenericPropertyComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 3;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.lPersistence = new Label((Composite)this, 0);
        this.lPersistence.setText("persistence.xml location");
        this.lPersistence.setLayoutData((Object)gridData2);
        this.tPersistence = new Text((Composite)this, 2048);
        this.tPersistence.setLayoutData((Object)gridData);
        this.tPersistence.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericPropertyComposite.this.loadProperties();
            }
        });
        this.bPersistence = new Button((Composite)this, 0);
        this.bPersistence.setText("Browse...");
        this.bPersistence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericPropertyComposite.this.findFile(GenericPropertyComposite.this.tPersistence, "Choose persistence.xml", "Choose your persistence.xml file.", "xml");
            }
        });
        this.lContextName = new Label((Composite)this, 0);
        this.lContextName.setText("Persistence context name");
        this.lContextName.setLayoutData((Object)new GridData(128));
        this.tContextName = new Text((Composite)this, 2048);
        this.tContextName.setLayoutData((Object)gridData3);
        this.lParFile = new Label((Composite)this, 0);
        this.lParFile.setText(".par file location");
        this.lParFile.setLayoutData((Object)gridData11);
        this.tParFile = new Text((Composite)this, 2048);
        this.tParFile.setLayoutData((Object)gridData1);
        this.bParFile = new Button((Composite)this, 0);
        this.bParFile.setText("Browse...");
        this.bParFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericPropertyComposite.this.findFile(GenericPropertyComposite.this.tParFile, "Select par", "Select where to create your par file.", "par", "jar");
            }
        });
        this.setLayout((Layout)gridLayout);
        this.createGroup();
        this.setSize(new Point(300, 200));
    }

    protected void findFile(Text text, String title, String message, String ... exts) {
        FileSelectionDialog dialog = new FileSelectionDialog(this.getShell());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setInput(this.project);
        dialog.setAllowMultiple(false);
        dialog.setValidExtentions(exts);
        dialog.setSorter((ViewerSorter)new ResourceSorter(2));
        try {
            dialog.setInitialSelection(this.project.getFile(text.getText()));
        }
        catch (Exception exception) {}
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            file.getFullPath().removeFirstSegments(1);
            text.setText(file.getFullPath().removeFirstSegments(1).toPortableString());
        }
    }

    private void createGroup() {
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 3;
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        this.cProperties = new Group((Composite)this, 0);
        this.cProperties.setText("Properties");
        this.createTable();
        this.cProperties.setLayout((Layout)gridLayout1);
        this.cProperties.setLayoutData((Object)gridData3);
        this.bAdd = new Button((Composite)this.cProperties, 0);
        this.bNew = new Button((Composite)this.cProperties, 0);
        this.bNew.setText("New");
        this.bNew.setLayoutData((Object)gridData6);
        this.bNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericPropertyComposite.this.newProperty();
            }
        });
        this.bAdd.setText("Add");
        this.bAdd.setLayoutData((Object)gridData5);
        this.bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericPropertyComposite.this.addProperty();
            }
        });
        this.bRemove = new Button((Composite)this.cProperties, 0);
        this.bRemove.setText("Remove");
        this.bRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericPropertyComposite.this.removeProperty();
            }
        });
    }

    private void createTable() {
        GridData gridData4 = new GridData();
        gridData4.verticalSpan = 6;
        gridData4.verticalAlignment = 4;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalAlignment = 4;
        this.tProperties = new Table((Composite)this.cProperties, 0);
        this.tProperties.setEnabled(true);
        this.tProperties.setHeaderVisible(true);
        this.tProperties.setLayoutData((Object)gridData4);
        this.tProperties.setLinesVisible(true);
        TableColumn tcKey = new TableColumn(this.tProperties, 0);
        tcKey.setWidth(220);
        tcKey.setText("Name");
        TableColumn tcValue = new TableColumn(this.tProperties, 0);
        tcValue.setWidth(220);
        tcValue.setText("Value");
        this.tableViewer = new TableViewer(this.tProperties);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(new String[]{"Name", "Value"});
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.tProperties), new TextCellEditor((Composite)this.tProperties)};
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                EntityManagerDocument.EntityManager.Properties.Property property2 = (EntityManagerDocument.EntityManager.Properties.Property)item.getData();
                if ("Name".equals(property)) {
                    property2.getName().setStringValue(value.toString());
                    item.setText(0, value.toString());
                } else if ("Value".equals(property)) {
                    property2.getValue().setStringValue(value.toString());
                    item.setText(1, value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                EntityManagerDocument.EntityManager.Properties.Property property2 = (EntityManagerDocument.EntityManager.Properties.Property)element;
                if ("Name".equals(property)) {
                    return property2.getName().getStringValue();
                }
                if ("Value".equals(property)) {
                    return property2.getValue().getStringValue();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
    }

    public void setIProject(IProject project) {
        this.project = project;
        try {
            PersistenceProperties properties = new PersistenceProperties(project);
            String persistenceFileName = properties.getPersistenceFileName();
            this.tPersistence.setText(persistenceFileName != null ? persistenceFileName : "persistence.xml");
            this.tParFile.setText(properties.getParFileName());
        }
        catch (Exception e) {
            GenericPlugin.logException(e, "Error loading poperties.", "Could not load persistence properties.");
        }
        this.bAdd.setEnabled(!this.getVendorProperties().isEmpty());
    }

    public boolean saveChanges() {
        try {
            PersistenceProperties properties = new PersistenceProperties(this.project);
            properties.getPersistenceFileName();
            properties.setParFileName(this.tParFile.getText());
            properties.setPersistenceFileName(this.tPersistence.getText());
            String contextName = this.tContextName.getText();
            if (contextName == null || contextName.trim().length() == 0) {
                contextName = null;
            }
            this.emd.getEntityManager().setName(contextName);
            properties.save();
            Utils.savePersistenceXml(this.project, this.emd);
            return true;
        }
        catch (Exception e) {
            GenericPlugin.logException(e, "Error loading poperties.", "Could not load persistence properties.");
            return false;
        }
    }

    private void loadProperties() {
        try {
            this.emd = Utils.loadPersistenceXml(this.project, this.tPersistence.getText());
            EntityManagerDocument.EntityManager em = this.emd.getEntityManager();
            String contextName = em.getName();
            this.tContextName.setText(contextName != null ? contextName : "");
            this.properties = em.getProperties();
            if (this.properties == null) {
                this.properties = em.addNewProperties();
            }
            EntityManagerDocument.EntityManager.Properties.Property[] propertyArray = this.properties.getPropertyArray();
            this.tProperties.removeAll();
            int x = 0;
            while (x < propertyArray.length) {
                EntityManagerDocument.EntityManager.Properties.Property property = propertyArray[x];
                TableItem item = new TableItem(this.tProperties, 0);
                item.setText(0, property.getName().getStringValue());
                item.setText(1, property.getValue().getStringValue());
                item.setData((Object)property);
                ++x;
            }
            this.setKnownInfo();
        }
        catch (Exception e) {
            GenericPlugin.log(e);
        }
    }

    private void setKnownInfo() throws CoreException, IOException {
        HashMap<String, String> keyValue = new HashMap<String, String>();
        PersistenceProperties properties = new PersistenceProperties(this.project);
        VendorDefinitionDocument.VendorDefinition vendorDef = null;
        try {
            VendorDefinitionDocument vdd = this.createVendorDefDoc();
            vendorDef = vdd.getVendorDefinition();
        }
        catch (Exception e) {
            GenericPlugin.logException(e);
        }
        ConnectionInfo info = this.getActiveConnectionInfo(properties);
        DatabaseDefinition dbdef = null;
        if (info != null) {
            dbdef = info.getDatabaseDefinition();
            if (dbdef != null && vendorDef != null) {
                String dbProduct = dbdef.getProduct();
                String dbVersion = dbdef.getVersion();
                VendorDefinitionDocument.VendorDefinition.JdbcTypeMap match = null;
                int i = 0;
                while (i < vendorDef.sizeOfJdbcTypeMapArray()) {
                    VendorDefinitionDocument.VendorDefinition.JdbcTypeMap map = vendorDef.getJdbcTypeMapArray(i);
                    String database = map.getDatabase();
                    if (database.equalsIgnoreCase(dbProduct)) {
                        if (match == null) {
                            match = map;
                        }
                        if (dbVersion.equals(map.getVersion())) {
                            match = map;
                            break;
                        }
                    }
                    ++i;
                }
                if (match == null) {
                    match = vendorDef.getJdbcTypeMapArray(0);
                }
                String dialect = match.getDialect();
                this.setPropertyValue(keyValue, "dialect", dialect);
                this.setPropertyValue(keyValue, "connection.driver", match.getDefaultDriverClass());
            }
            this.setPropertyValue(keyValue, "connection.driver", info.getDriverClassName());
            this.setPropertyValue(keyValue, "connection.url", info.getURL());
            this.setPropertyValue(keyValue, "connection.username", info.getUserName());
            this.setPropertyValue(keyValue, "connection.password", info.getPassword());
        }
        this.setPropertyValue(keyValue, "connection.username", properties.getConnectionUserName());
        this.setPropertyValue(keyValue, "connection.password", properties.getConnectionPassword());
        if (vendorDef != null) {
            VendorDefinitionDocument.VendorDefinition.PersistenceXml persistenceXml = vendorDef.getPersistenceXmlArray(0);
            VendorDefinitionDocument.VendorDefinition.PersistenceXml.PropertyMapping[] propertyMappings = persistenceXml.getPropertyMappingArray();
            int x = 0;
            while (x < propertyMappings.length) {
                VendorDefinitionDocument.VendorDefinition.PersistenceXml.PropertyMapping mapping = propertyMappings[x];
                String propertyName = mapping.getPropertyName();
                String key = mapping.getKey();
                this.changeKey(keyValue, key, propertyName);
                ++x;
            }
        }
        TableItem[] items = this.tProperties.getItems();
        int x = 0;
        while (x < items.length) {
            TableItem item = items[x];
            String key = item.getText(0);
            String value = keyValue.get(key);
            if (value != null) {
                item.setText(1, value);
                EntityManagerDocument.EntityManager.Properties.Property prop = (EntityManagerDocument.EntityManager.Properties.Property)item.getData();
                prop.getValue().setStringValue(value);
                keyValue.remove(key);
            }
            ++x;
        }
        for (Map.Entry<String, String> entry : keyValue.entrySet()) {
            String propName = entry.getKey();
            String propValue = entry.getValue();
            EntityManagerDocument.EntityManager.Properties.Property property = this.properties.addNewProperty();
            TableItem item = new TableItem(this.tProperties, 0);
            item.setText(0, propName);
            item.setText(1, propValue);
            item.setData((Object)property);
            property.addNewName().setStringValue(propName);
            property.addNewValue().setStringValue(propValue);
        }
    }

    private void setPropertyValue(HashMap<String, String> keyValue, String key, String value) {
        if (key != null && value != null) {
            keyValue.put(key, value);
        }
    }

    private void changeKey(HashMap<String, String> keyValue, String oldKey, String newKey) {
        String value;
        if (oldKey != null && newKey != null && (value = keyValue.get(oldKey)) != null) {
            keyValue.put(newKey, value);
            keyValue.remove(oldKey);
        }
    }

    private void addProperty() {
        List<String> props = this.getVendorProperties();
        if (props.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"No properties in vendor definition file.", (String)"No more properties in vendor definition file to add.");
            return;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider());
        dialog.setTitle("Select a property.");
        dialog.setMessage("Select a property to add.");
        dialog.setElements(props.toArray());
        dialog.setAllowDuplicates(false);
        dialog.setMultipleSelection(true);
        dialog.setEmptyListMessage("No more properties in vendor definition file to add.");
        dialog.setEmptySelectionMessage("You must select a property to add.");
        if (dialog.open() == 0) {
            VendorDefinitionDocument.VendorDefinition.PersistenceXml.Property[] properties = null;
            try {
                VendorDefinitionDocument vdd = this.createVendorDefDoc();
                VendorDefinitionDocument.VendorDefinition vendorDef = vdd.getVendorDefinition();
                VendorDefinitionDocument.VendorDefinition.PersistenceXml persistenceXml = vendorDef.getPersistenceXmlArray(0);
                properties = persistenceXml.getPropertyArray();
            }
            catch (Exception e) {
                GenericPlugin.logException(e);
            }
            Object[] results = dialog.getResult();
            int x = 0;
            while (x < results.length) {
                String propName = (String)results[x];
                EntityManagerDocument.EntityManager.Properties.Property property = this.properties.addNewProperty();
                TableItem item = new TableItem(this.tProperties, 0);
                item.setText(0, propName);
                item.setData((Object)property);
                property.addNewName().setStringValue(propName);
                property.addNewValue();
                if (properties != null) {
                    int y = 0;
                    while (y < properties.length) {
                        String propertyName = properties[x].getName();
                        if (propName.equals(propertyName)) {
                            String value = properties[x].getValue();
                            item.setText(1, value);
                            property.getValue().setStringValue(value);
                            break;
                        }
                        ++y;
                    }
                }
                ++x;
            }
        }
        this.bAdd.setEnabled(!this.getVendorProperties().isEmpty());
    }

    private List<String> getVendorProperties() {
        String propertyName;
        VendorDefinitionDocument vdd;
        ArrayList<String> props = new ArrayList<String>();
        try {
            vdd = this.createVendorDefDoc();
        }
        catch (Exception e) {
            GenericPlugin.logException(e);
            return props;
        }
        VendorDefinitionDocument.VendorDefinition vendorDef = vdd.getVendorDefinition();
        VendorDefinitionDocument.VendorDefinition.PersistenceXml persistenceXml = vendorDef.getPersistenceXmlArray(0);
        VendorDefinitionDocument.VendorDefinition.PersistenceXml.PropertyMapping[] propertyMappings = persistenceXml.getPropertyMappingArray();
        int x = 0;
        while (x < propertyMappings.length) {
            VendorDefinitionDocument.VendorDefinition.PersistenceXml.PropertyMapping mapping = propertyMappings[x];
            propertyName = mapping.getPropertyName();
            if (!props.contains(propertyName)) {
                props.add(propertyName);
            }
            ++x;
        }
        VendorDefinitionDocument.VendorDefinition.PersistenceXml.Property[] properties = persistenceXml.getPropertyArray();
        int x2 = 0;
        while (x2 < properties.length) {
            propertyName = properties[x2].getName();
            if (!props.contains(propertyName)) {
                props.add(propertyName);
            }
            ++x2;
        }
        TableItem[] items = this.tProperties.getItems();
        int x3 = 0;
        while (x3 < items.length) {
            TableItem item = items[x3];
            props.remove(item.getText(0));
            ++x3;
        }
        return props;
    }

    protected VendorDefinitionDocument createVendorDefDoc() throws XmlException, IOException, CoreException {
        OrmProduct ormProduct;
        PersistenceProperties properties = new PersistenceProperties(this.project);
        String vendorDefRes = properties.getProperty("ejb3.vendor.definition");
        if (vendorDefRes == null) {
            vendorDefRes = "vendor-generic.xml";
        }
        String namespace = GenericPlugin.getPluginId();
        String productId = properties.getPersistenceProduct();
        if (productId != null && (ormProduct = OrmProductRegistry.INSTANCE.getOrmProductById(productId)) != null) {
            namespace = ormProduct.getNamespace();
        }
        VendorDefinitionDocument vdd = Utils.loadVendorDefinition(namespace, vendorDefRes);
        return vdd;
    }

    private void newProperty() {
        TableItem item = new TableItem(this.tProperties, 0);
        EntityManagerDocument.EntityManager.Properties.Property property = this.properties.addNewProperty();
        property.addNewName();
        property.addNewValue();
        item.setData((Object)property);
    }

    private void removeProperty() {
        int[] selectionIndices = this.tProperties.getSelectionIndices();
        int x = 0;
        while (x < selectionIndices.length) {
            TableItem item = this.tProperties.getItem(selectionIndices[x]);
            EntityManagerDocument.EntityManager.Properties.Property property = (EntityManagerDocument.EntityManager.Properties.Property)item.getData();
            if (property != null) {
                EntityManagerDocument.EntityManager.Properties.Property[] propertyArray = this.properties.getPropertyArray();
                int y = 0;
                while (y < propertyArray.length) {
                    EntityManagerDocument.EntityManager.Properties.Property temp = propertyArray[y];
                    if (property.equals(temp)) {
                        this.properties.removeProperty(y);
                    }
                    ++y;
                }
            }
            ++x;
        }
        if (selectionIndices != null && selectionIndices.length > 0) {
            this.tProperties.remove(selectionIndices);
        }
        this.bAdd.setEnabled(!this.getVendorProperties().isEmpty());
    }

    public ConnectionInfo getActiveConnectionInfo(PersistenceProperties props) {
        String rdbConnName = props.getConnectionName();
        if (rdbConnName != null) {
            ConnectionInfo[] rdbConnections = RdbUtils.getRdbConnections();
            int x = rdbConnections.length - 1;
            while (x >= 0) {
                if (rdbConnName.equals(rdbConnections[x].getName())) {
                    return rdbConnections[x];
                }
                --x;
            }
        }
        return null;
    }
}

