/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jsr220Orm.generic.xml.VendorDefinitionDocument;
import org.eclipse.jsr220Orm.xml.EntityManagerDocument;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.provider.MetadataEditPlugin;
import org.osgi.framework.Bundle;

public class Utils {
    protected static XmlOptions xmlOptions = new XmlOptions();
    protected static XmlOptions newFileXmlOptions = new XmlOptions();
    protected static final String PERSISTENCE_XML_NAMESPACE = "http://jsr220orm.eclipse.org/xml";
    protected static final String VENDOR_DEFINITION_XML_NAMESPACE = "http://jsr220orm.eclipse.org/generic/xml";
    public static final Map<Class, Class> PRIM_WRAPPER_MAP;
    public static final Map<Class, Object> WRAPPER_DEFAULT_MAP;
    public static final Map<String, Class> PRIM_CLASS_MAP;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        xmlOptions.setLoadLineNumbers();
        xmlOptions.setUseDefaultNamespace();
        newFileXmlOptions.setSavePrettyPrint();
        newFileXmlOptions.setSavePrettyPrintIndent(4);
        newFileXmlOptions.setUseDefaultNamespace();
        PRIM_WRAPPER_MAP = new HashMap<Class, Class>();
        WRAPPER_DEFAULT_MAP = new HashMap<Class, Object>();
        PRIM_CLASS_MAP = new HashMap<String, Class>();
        Object[] a = new Object[]{Integer.TYPE, Integer.class, 0, Long.TYPE, Long.class, 0L, Short.TYPE, Short.class, (short)0, Byte.TYPE, Byte.class, (byte)0, Boolean.TYPE, Boolean.class, Boolean.FALSE, Character.TYPE, Character.class, Character.valueOf('\u0000'), Float.TYPE, Float.class, Float.valueOf(0.0f), Double.TYPE, Double.class, 0.0};
        int i = 0;
        while (i < a.length) {
            Class p = (Class)a[i];
            Class w = (Class)a[i + 1];
            PRIM_WRAPPER_MAP.put(p, w);
            WRAPPER_DEFAULT_MAP.put(w, a[i + 2]);
            PRIM_CLASS_MAP.put(p.getName(), p);
            i += 3;
        }
    }

    public static void close(InputStream ins) {
        try {
            if (ins != null) {
                ins.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String convertGetMethodToProperty(String methodName) {
        char c = methodName.charAt(3);
        if (Character.isLowerCase(c)) {
            return methodName.substring(3);
        }
        return String.valueOf(Character.toLowerCase(c)) + methodName.substring(4);
    }

    public static String convertPropertyToGetMethod(String properyName) {
        char c = properyName.charAt(0);
        if (Character.isLowerCase(c)) {
            return "get" + Character.toUpperCase(c) + properyName.substring(1);
        }
        return "get" + properyName;
    }

    public static void replace(ASTNode old, ASTNode replacement) {
        StructuralPropertyDescriptor p = old.getLocationInParent();
        if (p == null) {
            return;
        }
        if (p.isChildProperty()) {
            old.getParent().setStructuralProperty(p, (Object)replacement);
            return;
        }
        if (p.isChildListProperty()) {
            List l = (List)old.getParent().getStructuralProperty(p);
            int i = l.indexOf(old);
            l.set(i, replacement);
        }
    }

    public static void setIfNotNull(AnnotationEx ann, String name, Object value) {
        if (value != null) {
            ann.set(name, value);
        }
    }

    public static Map createMarkerLocation(ASTNode node) {
        HashMap<String, Integer> ans = new HashMap<String, Integer>();
        CompilationUnit root = (CompilationUnit)node.getRoot();
        int start = node.getStartPosition();
        ans.put("lineNumber", root.lineNumber(start));
        ans.put("charStart", start);
        ans.put("charEnd", start + node.getLength());
        return ans;
    }

    public static String getAttributeName(RAnnotatedElement attribute) {
        if (attribute.isField()) {
            return attribute.getName();
        }
        return Utils.getAttributeNameForMethod(attribute.getName());
    }

    public static String getAttributeNameForMethod(String s) {
        if (s.startsWith("get") && s.length() > 3) {
            char c = s.charAt(3);
            if (Character.isUpperCase(c)) {
                return String.valueOf(Character.toLowerCase(c)) + s.substring(4);
            }
            return s.substring(3);
        }
        return s;
    }

    public static void removeAnnotation(RAnnotatedElement attribute, Class annotationType) {
        AnnotationEx a = (AnnotationEx)attribute.getAnnotation(annotationType);
        if (a != null) {
            a.delete();
        }
    }

    public static Class loadClass(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class<?> cls;
        boolean array = className.endsWith("[]");
        if (array) {
            className = className.substring(0, className.length() - 2);
        }
        if ((cls = PRIM_CLASS_MAP.get(className)) == null) {
            cls = Class.forName(className, initialize, loader);
        }
        if (array) {
            return Array.newInstance(cls, 0).getClass();
        }
        return cls;
    }

    public static String getTypeName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding.isParameterizedType()) {
            return binding.getBinaryName();
        }
        return binding.getQualifiedName();
    }

    public static EntityManagerDocument loadPersistenceXml(IProject project) throws Exception {
        PersistenceProperties props = new PersistenceProperties(project);
        String name = props.getPersistenceFileName();
        return Utils.loadPersistenceXml(project, name);
    }

    public static EntityManagerDocument loadPersistenceXml(IProject project, String fileName) throws Exception {
        IFile xmlFile = project.getFile(fileName);
        if (!xmlFile.isSynchronized(1)) {
            xmlFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        if (xmlFile.exists()) {
            InputStream ins = xmlFile.getContents();
            try {
                EntityManagerDocument entityManagerDocument = EntityManagerDocument.Factory.parse((InputStream)ins, (XmlOptions)Utils.getXmlOptions(PERSISTENCE_XML_NAMESPACE));
                return entityManagerDocument;
            }
            finally {
                Utils.close(ins);
            }
        }
        EntityManagerDocument newInstance = EntityManagerDocument.Factory.newInstance();
        newInstance.addNewEntityManager();
        return newInstance;
    }

    public static void savePersistenceXml(IProject project, EntityManagerDocument doc) throws Exception {
        PersistenceProperties props = new PersistenceProperties(project);
        String name = props.getPersistenceFileName();
        IFile xmlFile = project.getFile(name);
        boolean exists = xmlFile.exists();
        XmlOptions ops = exists ? Utils.getNewFileXmlOptions(PERSISTENCE_XML_NAMESPACE) : Utils.getXmlOptions(PERSISTENCE_XML_NAMESPACE);
        InputStream ins = doc.newInputStream(ops);
        try {
            if (exists) {
                xmlFile.setContents(ins, 1, null);
            } else {
                xmlFile.create(ins, 1, null);
            }
        }
        finally {
            Utils.close(ins);
        }
    }

    public static VendorDefinitionDocument loadVendorDefinition(String bundleNamespace, String vendorDefResouce) throws XmlException, IOException {
        InputStream ins = Utils.openBundleResource(bundleNamespace, vendorDefResouce);
        try {
            VendorDefinitionDocument vendorDefinitionDocument = VendorDefinitionDocument.Factory.parse((InputStream)ins, (XmlOptions)Utils.getXmlOptions(VENDOR_DEFINITION_XML_NAMESPACE));
            return vendorDefinitionDocument;
        }
        finally {
            Utils.close(ins);
        }
    }

    public static InputStream openBundleResource(String bundleNamespace, String resourceName) throws IOException {
        Bundle bundle = Platform.getBundle((String)bundleNamespace);
        URL resourceUrl = bundle.getResource(resourceName);
        if (resourceUrl == null && (resourceUrl = bundle.getResource("/" + resourceName)) == null) {
            throw new IllegalArgumentException("Unable to find resource '" + resourceName + "' on " + bundleNamespace + " classpath");
        }
        return resourceUrl.openStream();
    }

    public static XmlOptions getXmlOptions(String defaultNamespace) {
        XmlOptions ops = new XmlOptions(xmlOptions);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", defaultNamespace);
        ops.setLoadSubstituteNamespaces(map);
        return ops;
    }

    public static XmlOptions getNewFileXmlOptions(String defaultNamespace) {
        XmlOptions ops = new XmlOptions(newFileXmlOptions);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", defaultNamespace);
        ops.setSaveImplicitNamespaces(map);
        return ops;
    }

    public static void addCpVarTo(IJavaProject jProject, String classPathVariableName) throws JavaModelException {
        IClasspathEntry varEntry = JavaCore.newContainerEntry((IPath)new Path(classPathVariableName));
        IClasspathEntry[] oldclasspath = jProject.getRawClasspath();
        IClasspathEntry[] newclasspath = new IClasspathEntry[oldclasspath.length + 1];
        int i = 0;
        while (i < oldclasspath.length) {
            IClasspathEntry iClasspathEntry = oldclasspath[i];
            if (iClasspathEntry.equals(varEntry)) {
                return;
            }
            newclasspath[i] = iClasspathEntry;
            ++i;
        }
        newclasspath[newclasspath.length - 1] = varEntry;
        jProject.setRawClasspath(newclasspath, null);
    }

    public static void removeCpVarFrom(IJavaProject jProject, String classPathVariableName) throws JavaModelException {
        IClasspathEntry varEntry = JavaCore.newContainerEntry((IPath)new Path(classPathVariableName));
        IClasspathEntry[] oldclasspath = jProject.getRawClasspath();
        int entryCount = 0;
        int i = 0;
        while (i < oldclasspath.length) {
            if (varEntry.equals(oldclasspath[i])) {
                ++entryCount;
            }
            ++i;
        }
        if (entryCount == 0) {
            return;
        }
        IClasspathEntry[] newclasspath = new IClasspathEntry[oldclasspath.length - entryCount];
        entryCount = 0;
        int i2 = 0;
        while (i2 < newclasspath.length) {
            IClasspathEntry iClasspathEntry = oldclasspath[i2 + entryCount];
            if (iClasspathEntry.equals(varEntry)) {
                ++entryCount;
                continue;
            }
            newclasspath[i2] = iClasspathEntry;
            ++i2;
        }
        jProject.setRawClasspath(newclasspath, null);
    }

    public static Object getImage(String name) {
        return MetadataEditPlugin.INSTANCE.getImage("full/obj16/" + name);
    }

    public static boolean deleteJoinAndSrcCols(Join join) {
        if (join != null) {
            EList srcCols = join.getSrcColumns();
            join.delete();
            int i = srcCols.size() - 1;
            while (i >= 0) {
                ((OrmColumn)srcCols.get(i)).delete();
                --i;
            }
            return true;
        }
        return false;
    }

    public static void addBuilder(IProject project, String builderId) throws CoreException {
        if (builderId == null || builderId.trim().length() == 0) {
            return;
        }
        IProjectDescription desp = project.getDescription();
        ICommand[] commands = desp.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            String builderName = commands[i].getBuilderName();
            if (builderName.equals(builderId)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = desp.newCommand();
            command.setBuilderName(builderId);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[commands.length] = command;
            desp.setBuildSpec(newCommands);
            project.setDescription(desp, null);
        }
    }

    public static void removeBuilder(IProject project, String builderId) throws CoreException {
        if (builderId == null || builderId.trim().length() == 0) {
            return;
        }
        IProjectDescription desp = project.getDescription();
        ICommand[] commands = desp.getBuildSpec();
        boolean found = false;
        int index = -1;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                index = i;
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            ArrayList<ICommand> list = new ArrayList<ICommand>(commands.length);
            int i2 = 0;
            while (i2 < commands.length) {
                list.add(commands[i2]);
                ++i2;
            }
            list.remove(index);
            commands = new ICommand[commands.length - 1];
            list.toArray(commands);
            desp.setBuildSpec(commands);
            project.setDescription(desp, null);
        }
    }
}

