/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.SequenceGenerator;
import org.eclipse.dali.orm.adapters.ISequenceGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaSequenceGeneratorModelAdapter
extends JavaGeneratorModelAdapter
implements ISequenceGeneratorModelAdapter {
    private StringAnnotationElementAdapter specifiedSequenceNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedSequenceNameElementInfo());
    public static final String ANNOTATION_NAME = "SequenceGenerator";
    public static final String SEQUENCE_NAME_ELEMENT = "sequenceName";

    JavaSequenceGeneratorModelAdapter(Member member) {
        super(member);
    }

    public void setSequenceGenerator(SequenceGenerator sequenceGenerator) {
        super.setGenerator(sequenceGenerator);
    }

    protected SequenceGenerator getSequenceGenerator() {
        return (SequenceGenerator)this.getGenerator();
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedSequenceNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaSequenceGeneratorModelAdapter.this.getSequenceGenerator().setSpecifiedSequenceName(newValue);
            }

            public String persValue() {
                return JavaSequenceGeneratorModelAdapter.this.getSequenceGenerator().getSpecifiedSequenceName();
            }

            public String annotationElementName() {
                return JavaSequenceGeneratorModelAdapter.SEQUENCE_NAME_ELEMENT;
            }

            public String annotationName() {
                return JavaSequenceGeneratorModelAdapter.this.generatorAnnotationName();
            }

            public Member member() {
                return JavaSequenceGeneratorModelAdapter.this.member();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected String generatorAnnotationName() {
        return ANNOTATION_NAME;
    }

    public void updatePersModel(CompilationUnit astRoot) {
        super.updatePersModel(astRoot);
        this.updatePersSpecifiedSequenceName(astRoot);
    }

    private void updatePersSpecifiedSequenceName(CompilationUnit astRoot) {
        this.specifiedSequenceNameAdapter.updatePersElement(astRoot);
    }

    public void specifiedSequenceNameChanged() {
        this.specifiedSequenceNameAdapter.updateJavaElement();
    }

    public ITextRange getTextRange() {
        return this.member().getTextRange(ANNOTATION_NAME);
    }

    public ITextRange sequenceNameTextRange() {
        ITextRange textRange = this.specifiedSequenceNameAdapter.textRange();
        if (textRange == null) {
            return this.getTextRange();
        }
        return textRange;
    }
}

