/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.beans.Introspector;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class MethodAttribute
extends Attribute {
    public MethodAttribute(IMethod getterMethod) {
        super((IMember)getterMethod);
    }

    public IMethod getJDTMethod() {
        return (IMethod)this.getJDTMember();
    }

    public String getMethodName() {
        return this.getJDTMember().getElementName();
    }

    public String getName() {
        String methodName = super.getName();
        int beginIndex = 0;
        if (methodName.startsWith("get")) {
            beginIndex = 3;
        } else if (methodName.startsWith("is")) {
            beginIndex = 2;
        }
        return Introspector.decapitalize(methodName.substring(beginIndex));
    }

    BodyDeclaration bodyDeclaration(CompilationUnit astRoot) {
        String methodName = this.getMethodName();
        MethodDeclaration[] methodDeclarations = this.declaringTypeDeclaration(astRoot).getMethods();
        int i = methodDeclarations.length;
        while (i-- > 0) {
            MethodDeclaration methodDeclaration = methodDeclarations[i];
            if (!methodDeclaration.getName().getFullyQualifiedName().equals(methodName)) continue;
            return methodDeclaration;
        }
        return null;
    }

    public boolean isMethod() {
        return true;
    }

    public String getTypeSignature() {
        try {
            return this.getJDTMethod().getReturnType();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isPersistentAttributeFor(IMember member) {
        return this.getJDTMethod().equals(member) || this.setMethod().equals(member);
    }

    private IMethod setMethod() {
        try {
            return this.setMethodUnhandled();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private IMethod setMethodUnhandled() throws JavaModelException {
        String methodName = "set" + StringTools.capitalize((String)this.getName());
        String[] parmTypeSignatures = new String[]{this.getJDTMethod().getReturnType()};
        return this.getDeclaringType().getJDTType().getMethod(methodName, parmTypeSignatures);
    }
}

