/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.xml;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.ITableModelAdapter;
import org.eclipse.dali.orm.adapters.xml.IXMLTypeMappingModelAdapter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEntityModelAdapter
implements IEntityModelAdapter,
IXMLTypeMappingModelAdapter {
    private static final String NAME_TAG = "p:name";
    private static final String CLASS_TAG = "p:class";
    private static final String TABLE_TAG = "p:table";
    private Entity entity;
    private IDOMElement entityElement;

    public XMLEntityModelAdapter(IDOMElement domElement) {
        this.entityElement = domElement;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.entity = (Entity)typeMapping;
    }

    public void engage() {
        this.updatePersModel();
    }

    public void disengage() {
        this.entity = null;
    }

    public ITableModelAdapter createTableModelAdapter() {
        return null;
    }

    public IInheritanceModelAdapter createInheritanceModelAdapter() {
        return null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected void updatePersModel() {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName();
    }

    public void modelChanged(IStructuredModel model) {
        this.updatePersModel();
    }

    protected void updatePersSpecifiedName() {
        String name = this.xmlSpecifiedName();
        String persName = this.getEntity().getSpecifiedName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.getEntity().setSpecifiedName(name);
        }
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.entity.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.entity.setDefaultName(name);
        }
    }

    public void specifiedNameChanged() {
        this.updateXmlSpecifiedName();
    }

    private void updateXmlSpecifiedName() {
        NodeList elements;
        String javaName = this.xmlSpecifiedName();
        String persName = this.getEntity().getSpecifiedName();
        if (persName == null && persName != javaName) {
            NodeList elements2 = this.entityElement.getElementsByTagName(NAME_TAG);
            if (elements2.getLength() > 0) {
                IDOMElement element = (IDOMElement)elements2.item(0);
                this.entityElement.removeChild((Node)element);
            }
        } else if (persName != null && !persName.equals(javaName) && (elements = this.entityElement.getElementsByTagName(NAME_TAG)).getLength() > 0) {
            IDOMElement element = (IDOMElement)elements.item(0);
            element.setNodeValue(persName);
        }
    }

    protected String defaultName() {
        return this.xmlDefaultName();
    }

    private String xmlDefaultName() {
        Node node;
        Node classNode = this.childNodeNamed(CLASS_TAG);
        if (classNode.getNodeType() == 1 && (node = ((IDOMElement)classNode).getFirstChild()).getNodeType() == 3) {
            return node.getNodeValue();
        }
        return "";
    }

    private String xmlSpecifiedName() {
        IDOMElement element;
        Node node;
        NodeList elements = this.entityElement.getElementsByTagName(NAME_TAG);
        if (elements.getLength() > 0 && (node = (element = (IDOMElement)elements.item(0)).getFirstChild()).getParentNode() == this.entityElement && node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    private String xmlSpecifiedTableName() {
        NodeList nameElements;
        IDOMElement nameElement;
        Node textNode;
        IDOMElement element;
        NodeList elements = this.entityElement.getElementsByTagName(TABLE_TAG);
        if (elements.getLength() > 0 && (element = (IDOMElement)elements.item(0)).getNodeType() == 1 && (textNode = (nameElement = (IDOMElement)(nameElements = element.getElementsByTagName(NAME_TAG)).item(0)).getFirstChild()).getNodeType() == 3) {
            return textNode.getNodeValue();
        }
        return null;
    }

    private Node childNodeNamed(String nodeName) {
        NodeList nodeList = this.entityElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals(nodeName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public ITextRange getTextRange() {
        return null;
    }

    public ITextRange tableTextRange() {
        return null;
    }

    public IAttributeOverrideModelAdapter createAttributeOverrideModelAdapter() {
        return null;
    }
}

