/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class DiscriminatorType
extends AbstractEnumerator {
    public static final int DEFAULT = 0;
    public static final int STRING = 1;
    public static final int CHAR = 2;
    public static final int INTEGER = 3;
    public static final DiscriminatorType DEFAULT_LITERAL = new DiscriminatorType(0, "Default", "Default (String)");
    public static final DiscriminatorType STRING_LITERAL = new DiscriminatorType(1, "String", "String");
    public static final DiscriminatorType CHAR_LITERAL = new DiscriminatorType(2, "Char", "Char");
    public static final DiscriminatorType INTEGER_LITERAL = new DiscriminatorType(3, "Integer", "Integer");
    private static final DiscriminatorType[] VALUES_ARRAY = new DiscriminatorType[]{DEFAULT_LITERAL, STRING_LITERAL, CHAR_LITERAL, INTEGER_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static DiscriminatorType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscriminatorType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscriminatorType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscriminatorType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscriminatorType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_LITERAL;
            }
            case 1: {
                return STRING_LITERAL;
            }
            case 2: {
                return CHAR_LITERAL;
            }
            case 3: {
                return INTEGER_LITERAL;
            }
        }
        return null;
    }

    private DiscriminatorType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

