/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dali.core.PersistenceContainer;
import org.eclipse.dali.core.PersistenceFile;
import org.eclipse.dali.core.PersistenceModel;
import org.eclipse.dali.core.PersistenceProject;
import org.eclipse.dali.core.impl.PersistenceFileImpl;
import org.eclipse.dali.core.impl.PersistenceModelImpl;
import org.eclipse.dali.core.impl.PersistenceModelManager;
import org.eclipse.dali.core.impl.PersistenceProjectImpl;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class PersistenceModelManager {
    private static PersistenceModelManager INSTANCE;
    private PersistenceModelImpl persistenceModel = new PersistenceModelImpl();
    private IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private IElementChangedListener elementChangeListener = new ElementChangeListener();

    public static final PersistenceModelManager getPersistenceModelManager() {
        if (INSTANCE == null) {
            INSTANCE = new PersistenceModelManager();
        }
        return INSTANCE;
    }

    private PersistenceModelManager() {
    }

    public void addPersistenceNature(IJavaProject javaProject) throws CoreException {
        PersistenceProjectImpl.addNatureToProject(javaProject);
    }

    public void addPersistenceNature(IJavaProject javaProject, String connectionInfoName, String schemaName) throws CoreException {
        PersistenceProjectImpl.addNatureToProject(javaProject, connectionInfoName, schemaName);
    }

    public final PersistenceModel getPersistenceModel() {
        return this.persistenceModel;
    }

    public PersistenceProjectImpl getPersistenceProject(IProject project) {
        return PersistenceProjectImpl.getPersistenceProject(project);
    }

    public PersistenceFile getPersistenceFile(IFile file) {
        if (file == null || !"java".equals(file.getFileExtension())) {
            return null;
        }
        IContainer container = file.getParent();
        PersistenceContainer pContainer = this.getPersistenceContainer(container);
        if (pContainer != null) {
            return pContainer.getPersistenceFile((IPath)new Path(file.getName()));
        }
        return null;
    }

    private PersistenceContainer getPersistenceContainer(IContainer container) {
        switch (container.getType()) {
            case 4: {
                return this.getPersistenceProject((IProject)container);
            }
            case 2: {
                IContainer parentContainer = container.getParent();
                PersistenceContainer pContainer = this.getPersistenceContainer(parentContainer);
                if (pContainer == null) break;
                return pContainer.getPersistenceFolder((IPath)new Path(container.getName()));
            }
        }
        return null;
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementChangeListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 31);
        JavaCore.addElementChangedListener((IElementChangedListener)this.elementChangeListener);
    }

    public static class ResourceChangeListener
    implements IResourceChangeListener {
        ThreadLocal resourceChangeProcessors = new ThreadLocal();

        public void resourceChanged(IResourceChangeEvent event) {
            this.getResourceChangeProcessor().resourceChanged(event);
        }

        public ResourceChangeProcessor getResourceChangeProcessor() {
            ResourceChangeProcessor processor = (ResourceChangeProcessor)this.resourceChangeProcessors.get();
            if (processor != null) {
                return processor;
            }
            processor = new ResourceChangeProcessor();
            this.resourceChangeProcessors.set(processor);
            return processor;
        }
    }

    static class ResourceChangeProcessor {
        private PersistenceModelManager modelManager = PersistenceModelManager.getPersistenceModelManager();

        ResourceChangeProcessor() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getSource() instanceof IWorkspace) {
                IResource resource = event.getResource();
                IResourceDelta delta = event.getDelta();
                switch (event.getType()) {
                    case 4: {
                        try {
                            if (resource.getType() == 4 && ((IProject)resource).hasNature("org.eclipse.dali.core.persistenceNature")) {
                                this.projectBeingDeleted((IProject)resource);
                            }
                        }
                        catch (CoreException coreException) {}
                        return;
                    }
                    case 1: {
                        if (this.isApplicable(delta)) {
                            this.checkForProjectsBeingAddedOrRemoved(delta);
                            this.checkForPersistenceFilesBeingAddedOrRemoved(delta);
                        }
                        return;
                    }
                    case 2: 
                    case 8: 
                    case 16: {
                        return;
                    }
                }
            }
        }

        private void checkForPersistenceFilesBeingAddedOrRemoved(IResourceDelta delta) {
            IResource resource = delta.getResource();
            boolean processChildren = false;
            switch (resource.getType()) {
                case 8: {
                    processChildren = true;
                    break;
                }
                case 4: {
                    IProject project = (IProject)resource;
                    try {
                        if (!project.hasNature("org.eclipse.dali.core.persistenceNature")) break;
                        PersistenceProjectImpl pProject = this.modelManager.getPersistenceProject(project);
                        pProject.synchInternalResources(delta);
                        break;
                    }
                    catch (CoreException coreException) {}
                }
            }
            if (processChildren) {
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.checkForPersistenceFilesBeingAddedOrRemoved(children[i]);
                    ++i;
                }
            }
        }

        private void checkForProjectsBeingAddedOrRemoved(IResourceDelta delta) {
            IResource resource = delta.getResource();
            boolean processChildren = false;
            block0 : switch (resource.getType()) {
                case 8: {
                    processChildren = true;
                    break;
                }
                case 4: {
                    IProject project = (IProject)resource;
                    PersistenceProjectImpl pProject = this.modelManager.getPersistenceProject(project);
                    switch (delta.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 4: {
                            if ((delta.getFlags() & 0x4000) != 0) {
                                if (!project.isOpen()) {
                                    this.modelManager.getPersistenceModel().getProjects().remove((Object)pProject);
                                    break block0;
                                }
                            } else {
                                delta.getFlags();
                            }
                        }
                    }
                }
            }
            if (processChildren) {
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.checkForProjectsBeingAddedOrRemoved(children[i]);
                    ++i;
                }
            }
        }

        private void projectBeingDeleted(IProject project) {
            PersistenceProjectImpl pProject = this.modelManager.getPersistenceProject(project);
            this.modelManager.getPersistenceModel().getProjects().remove((Object)pProject);
        }

        private boolean isApplicable(IResourceDelta rootDelta) {
            if (rootDelta != null) {
                class FoundRelevantDeltaException
                extends RuntimeException {
                    private static final long serialVersionUID = 7137113252936111022L;
                    final /* synthetic */ ResourceChangeProcessor this$1;

                    FoundRelevantDeltaException(ResourceChangeProcessor resourceChangeProcessor) {
                        this.this$1 = resourceChangeProcessor;
                    }
                }
                try {
                    rootDelta.accept(new IResourceDeltaVisitor(this){
                        final /* synthetic */ ResourceChangeProcessor this$1;
                        {
                            this.this$1 = resourceChangeProcessor;
                        }

                        public boolean visit(IResourceDelta delta) {
                            switch (delta.getKind()) {
                                case 1: 
                                case 2: {
                                    throw new FoundRelevantDeltaException(this.this$1);
                                }
                                case 4: {
                                    if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                    throw new FoundRelevantDeltaException(this.this$1);
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                    return true;
                }
                catch (CoreException coreException) {}
            }
            return false;
        }
    }

    public static class ElementChangeListener
    implements IElementChangedListener {
        ThreadLocal elementChangeProcessors = new ThreadLocal();

        public void elementChanged(ElementChangedEvent event) {
            this.getElementChangeProcessor().elementChanged(event);
        }

        public ElementChangeProcessor getElementChangeProcessor() {
            ElementChangeProcessor processor = (ElementChangeProcessor)this.elementChangeProcessors.get();
            if (processor != null) {
                return processor;
            }
            processor = new ElementChangeProcessor();
            this.elementChangeProcessors.set(processor);
            return processor;
        }
    }

    static class ElementChangeProcessor {
        private PersistenceModelManager modelManager = PersistenceModelManager.getPersistenceModelManager();

        ElementChangeProcessor() {
        }

        public void elementChanged(ElementChangedEvent event) {
            Iterator stream = this.modelManager.getPersistenceModel().getProjects().iterator();
            while (stream.hasNext()) {
                Iterator stream2 = ((PersistenceProject)stream.next()).persistenceFiles();
                while (stream2.hasNext()) {
                    ((PersistenceFileImpl)stream2.next()).handleEvent(event);
                }
            }
        }
    }
}

