/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import java.util.ListIterator;
import org.eclipse.dali.core.DaliFactory;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.IdMapping;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.core.RelationshipMapping;
import org.eclipse.dali.core.TypeMapping;
import org.eclipse.dali.core.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public abstract class AbstractJavaJoinColumnModelAdapter
implements IJoinColumnModelAdapter {
    private JoinColumn joinColumn;
    private JoinColumnOwner owner;
    private AbstractAnnotationElementAdapter specifiedNameAdapter;
    private StringAnnotationElementAdapter specifiedTableNameAdapter;
    private AbstractAnnotationElementAdapter specifiedReferencedColumnNameAdapter;

    AbstractJavaJoinColumnModelAdapter(JoinColumnOwner owner) {
        this.owner = owner;
        this.specifiedNameAdapter = this.buildSpecifiedNameAdapter();
        this.specifiedTableNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedTableNameElementInfo());
        this.specifiedReferencedColumnNameAdapter = this.buildSpecifiedReferencedColumnNameAdapter();
    }

    protected abstract AbstractAnnotationElementAdapter buildSpecifiedNameAdapter();

    protected abstract AbstractAnnotationElementAdapter buildSpecifiedReferencedColumnNameAdapter();

    public JoinColumnOwner getOwner() {
        return this.owner;
    }

    protected JoinColumn getJoinColumn() {
        return this.joinColumn;
    }

    public JoinColumn buildJoinColumn(Attribute attribute) {
        this.joinColumn = DaliFactory.eINSTANCE.createJoinColumn(this);
        return this.joinColumn;
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedTableNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                AbstractJavaJoinColumnModelAdapter.this.joinColumn.setSpecifiedTableName(newValue);
            }

            public String persValue() {
                return AbstractJavaJoinColumnModelAdapter.this.joinColumn.getSpecifiedTableName();
            }

            public String annotationElementName() {
                return "table";
            }

            public String annotationName() {
                return "JoinColumn";
            }

            public Member member() {
                return AbstractJavaJoinColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.updatePersDefaultTableName();
        this.updatePersSpecifiedTableName(astRoot);
        this.updatePersDefaultReferencedColumnName();
        this.updatePersSpecifiedReferencedColumnName(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.joinColumn.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultName(name);
        }
    }

    protected abstract String defaultName();

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.joinColumn.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        this.specifiedTableNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultReferencedColumnName() {
        String name = this.defaultReferencedColumnName();
        String persName = this.joinColumn.getDefaultReferencedColumnName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultReferencedColumnName(name);
        }
    }

    private void updatePersSpecifiedReferencedColumnName(CompilationUnit astRoot) {
        this.specifiedReferencedColumnNameAdapter.updatePersElement(astRoot);
    }

    protected abstract String defaultReferencedColumnName();

    protected String idNameFromPersistenType(PersistentType persistentType) {
        String targetIdName = null;
        if (persistentType != null) {
            ListIterator i = persistentType.getAllPersistentAttributes().listIterator();
            while (i.hasNext()) {
                PersistentAttribute targetAttribute = (PersistentAttribute)i.next();
                if (!(targetAttribute.getAttributeMapping() instanceof IdMapping)) continue;
                targetIdName = ((IdMapping)targetAttribute.getAttributeMapping()).getColumn().getName();
                break;
            }
        }
        return targetIdName;
    }

    private String defaultTableName() {
        RelationshipMapping relationshipMapping = this.owner.relationshipMapping();
        TypeMapping typeMapping = relationshipMapping.getTypeMapping();
        if (typeMapping.getKey() == Entity.Key.INSTANCE) {
            return ((Entity)typeMapping).getTable().getName();
        }
        return null;
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void specifiedTableNameChanged() {
        this.specifiedTableNameAdapter.updateJavaElement();
    }

    public void specifiedReferencedColumnNameChanged() {
        this.specifiedReferencedColumnNameAdapter.updateJavaElement();
    }

    protected Attribute attribute() {
        JavaPersistentAttributeModelAdapter modelAdapter = (JavaPersistentAttributeModelAdapter)this.owner.relationshipMapping().getPersistentAttribute().getModelAdapter();
        return modelAdapter.getAttribute();
    }

    public ITextRange getTextRange() {
        return this.attribute().getTextRange("JoinColumn");
    }

    public ITextRange joinColumnTextRange() {
        return this.specifiedNameAdapter.getTextRange();
    }

    public ITextRange referencedColumnTextRange() {
        return this.specifiedReferencedColumnNameAdapter.getTextRange();
    }

    public static interface JoinColumnOwner {
        public RelationshipMapping relationshipMapping();
    }
}

