/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.wizards.NewConnectionWizard;

public class PersistenceNatureWizardPage
extends WizardPage {
    private IJavaProject javaProject;
    private Combo connectionInfoCombo;
    private Combo schemaSelectionCombo;

    public PersistenceNatureWizardPage(IJavaProject javaProject) {
        super("Persistence Nature");
        this.setTitle("Add Persistence");
        this.setMessage("Specify persistence properties.");
        this.javaProject = javaProject;
    }

    public void createClassPathConfigGroup(Composite group) {
        Group classPathConfigGroup = new Group(group, 16);
        GridLayout layout = new GridLayout();
        classPathConfigGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        classPathConfigGroup.setLayoutData((Object)data);
        classPathConfigGroup.setText("Classpath Configuration (Optional)");
        try {
            if (this.javaProject.getProject().hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                new Label((Composite)classPathConfigGroup, 0).setText("Target server specified, no configuration required.  Changes can be made\n in the project Server properties or Build Path if necessary.");
            } else {
                this.createOutOfContainerComposite((Composite)classPathConfigGroup);
            }
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    private void createOutOfContainerComposite(Composite strategyGroup) {
        Composite outOfContainerComposite = new Composite(strategyGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        outOfContainerComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        outOfContainerComposite.setLayoutData((Object)data);
        new Label(outOfContainerComposite, 0).setText("Configure the project");
        Link buildPathLink = new Link(outOfContainerComposite, 0);
        buildPathLink.setText("<a>Build Path.</a>");
        buildPathLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PersistenceNatureWizardPage.this.openConfigureBuildPathWizard();
            }

            public void widgetSelected(SelectionEvent e) {
                PersistenceNatureWizardPage.this.openConfigureBuildPathWizard();
            }
        });
    }

    public void createConnectionControl(Composite group) {
        Composite connectionComposite = new Composite(group, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        connectionComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        connectionComposite.setLayoutData((Object)data);
        Link connectionLink = new Link(connectionComposite, 0);
        connectionLink.setText("<a>Database Connection</a>");
        this.connectionInfoCombo = new Combo(connectionComposite, 12);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.connectionInfoCombo.setLayoutData((Object)data);
        this.populateConnectionInfoCombo();
        connectionLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PersistenceNatureWizardPage.this.openNewConnectionWizard();
            }

            public void widgetSelected(SelectionEvent e) {
                PersistenceNatureWizardPage.this.openNewConnectionWizard();
            }
        });
        this.connectionInfoCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PersistenceNatureWizardPage.this.populateSchemaSelectionCombo();
            }

            public void widgetSelected(SelectionEvent e) {
                PersistenceNatureWizardPage.this.populateSchemaSelectionCombo();
            }
        });
    }

    private void createSchemaSelectionControl(Composite group) {
        Composite schemaSelectionComposite = new Composite(group, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        schemaSelectionComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        schemaSelectionComposite.setLayoutData((Object)data);
        new Label(schemaSelectionComposite, 0).setText("Schema (must be connected):");
        this.schemaSelectionCombo = new Combo(schemaSelectionComposite, 12);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.schemaSelectionCombo.setLayoutData((Object)data);
        this.populateSchemaSelectionCombo();
    }

    public void createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(272));
        this.createConnectionControl(group);
        this.createSchemaSelectionControl(group);
        this.createClassPathConfigGroup(group);
        this.setControl((Control)group);
    }

    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        return button;
    }

    private void openNewConnectionWizard() {
        TransformationIterator infoNames = new TransformationIterator(PersistenceDbPlugin.getDefault().getConnectionRepository().allConnectionInfo()){

            protected Object transform(Object next) {
                return ((ConnectionInfoWrapper)next).getName();
            }
        };
        NewConnectionWizard wizard = new NewConnectionWizard(null, true);
        wizard.setExistingConnectionNames(CollectionTools.list((Iterator)infoNames));
        wizard.init(PlatformUI.getWorkbench(), null);
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        ConnectionInfo info = wizard.getConnection();
        if (info != null) {
            this.populateConnectionInfoCombo();
            this.connectionInfoCombo.select(this.connectionInfoCombo.indexOf(info.getName()));
            this.populateSchemaSelectionCombo();
        }
    }

    private void populateConnectionInfoCombo() {
        Iterator connectionInfos = PersistenceDbPlugin.getDefault().getConnectionRepository().getAllConnectionInfo().iterator();
        while (connectionInfos.hasNext()) {
            String connInfoName = ((ConnectionInfoWrapper)connectionInfos.next()).getName();
            this.connectionInfoCombo.add(connInfoName);
        }
    }

    private void populateSchemaSelectionCombo() {
        this.schemaSelectionCombo.setItems(new String[0]);
        ConnectionInfoWrapper connectionInfo = PersistenceDbPlugin.getDefault().getConnectionRepository().getConnectionInfoNamed(this.connectionInfoCombo.getText());
        if (connectionInfo.isConnected()) {
            Iterator schemaNames = CollectionTools.sort((List)CollectionTools.list((Iterator)connectionInfo.schemaNames())).iterator();
            while (schemaNames.hasNext()) {
                this.schemaSelectionCombo.add((String)schemaNames.next());
            }
        }
    }

    protected void openConfigureBuildPathWizard() {
        PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.javaProject.getProject(), (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, null).open();
    }

    String getConnectionInfoName() {
        return this.connectionInfoCombo.getText();
    }

    String getSchemaName() {
        return this.schemaSelectionCombo.getText();
    }
}

