/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.List;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.ColumnPersistentAttributeFlavor;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Table;
import org.eclipse.dali.core.Version;
import org.eclipse.dali.core.adapters.IVersionModelAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.core.impl.PersistentAttributeFlavorImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class VersionImpl
extends PersistentAttributeFlavorImpl
implements Version {
    protected Column column = null;
    static /* synthetic */ Class class$0;

    protected VersionImpl() {
    }

    protected VersionImpl(IVersionModelAdapter modelAdapter) {
        super(modelAdapter);
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getVersion();
    }

    public Column getColumn() {
        return this.column;
    }

    public NotificationChain basicSetColumn(Column newColumn, NotificationChain msgs) {
        Column oldColumn = this.column;
        this.column = newColumn;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldColumn, (Object)newColumn);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setColumn(Column newColumn) {
        if (newColumn != this.column) {
            NotificationChain msgs = null;
            if (this.column != null) {
                msgs = ((InternalEObject)this.column).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newColumn != null) {
                msgs = ((InternalEObject)newColumn).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetColumn(newColumn, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newColumn, (Object)newColumn));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return this.basicSetColumn(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getColumn();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setColumn((Column)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setColumn(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.column != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass) {
        if (baseClass == ColumnPersistentAttributeFlavor.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == ColumnPersistentAttributeFlavor.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public boolean supportsColumn() {
        return true;
    }

    public String getKey() {
        return "version";
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addVersionMappedToNonPrimaryTableProblemTo(problems);
        this.addVersionMappingIncorrectTypeProblemTo(problems);
        this.addUnresolvedColumnProblemTo(problems);
    }

    private void addUnresolvedColumnProblemTo(List problems) {
        if (!this.column.resolves()) {
            problems.add(this.buildProblem(this.unresolvedColumnMessage(), this.getTextRange()));
        }
    }

    protected String unresolvedColumnMessage() {
        return "Column \"" + this.column.getName() + "\" cannot be resolved";
    }

    private void addVersionMappedToNonPrimaryTableProblemTo(List problems) {
        String tableName = this.column.getTableName();
        Table table = this.getPersistentAttribute().getPersistentTypeFlavor().getTable();
        if (table != null && tableName.equals(table.getName())) {
            return;
        }
        problems.add(this.buildProblem("Version mappings must be mapped to the primary table", this.getTextRange()));
    }

    private void addVersionMappingIncorrectTypeProblemTo(List problems) {
        Attribute attribute = ((JavaPersistentAttributeModelAdapter)this.getPersistentAttribute().getModelAdapter()).getAttribute();
        if (attribute.typeIs("int")) {
            return;
        }
        if (attribute.typeIs("java.lang.Integer")) {
            return;
        }
        if (attribute.typeIs("short")) {
            return;
        }
        if (attribute.typeIs("java.lang.Short")) {
            return;
        }
        if (attribute.typeIs("long")) {
            return;
        }
        if (attribute.typeIs("java.lang.Long")) {
            return;
        }
        if (attribute.typeIs("java.sql.Timestamp")) {
            return;
        }
        problems.add(this.buildProblem("Version mapping type must be int, Integer, short, Short, long, Long, or Timestamp", this.getTextRange()));
    }
}

