/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.ColumnPersistentAttributeFlavor;
import org.eclipse.dali.core.Id;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.MultiReferenceMapping;
import org.eclipse.dali.core.PersistenceContainer;
import org.eclipse.dali.core.PersistenceFile;
import org.eclipse.dali.core.PersistenceProject;
import org.eclipse.dali.core.PersistenceResource;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentAttributeFlavor;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.core.PersistentTypeFlavor;
import org.eclipse.dali.core.ReferencePersistentAttributeFlavor;
import org.eclipse.dali.core.SingleReferenceMapping;
import org.eclipse.dali.core.Table;
import org.eclipse.dali.core.adapters.IPersistenceModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.db.ddl.JdbcUtils;
import org.eclipse.dali.db.ddl.RdbUtils;
import org.eclipse.dali.db.ddl.TableComparator;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEWizard;
import org.eclipse.wst.rdb.internal.core.definition.DataModelElementFactory;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.constraints.PrimaryKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataType;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpression;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpressionDefault;
import org.eclipse.wst.rdb.internal.models.sql.expressions.impl.SQLExpressionsFactoryImpl;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.PersistentTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesFactory;

public class OrmDdlGenerator {
    private Database database;
    private TableComparator tableComparator = new TableComparator();
    private DatabaseDefinition dbDef;

    private OrmDdlGenerator(String product, String version) {
        product = RdbUtils.getDatabaseName(product);
        version = RdbUtils.getDatabaseVersion(product, version);
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        this.dbDef = ddr.getDefinition(product, version);
        this.database = SQLSchemaFactory.eINSTANCE.createDatabase();
        this.database.setVendor(this.dbDef.getProduct());
        this.database.setVersion(this.dbDef.getVersion());
        Schema defaultSchema = SQLSchemaFactory.eINSTANCE.createSchema();
        this.database.getSchemas().add((Object)defaultSchema);
    }

    private void createDDL() {
        ArrayList tables = new ArrayList(100);
        for (Schema schema : this.database.getSchemas()) {
            tables.addAll(schema.getTables());
        }
        Collections.sort(tables, this.tableComparator);
        FEWizard wizard = new FEWizard(tables);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private BaseTable getTable(String catalogName, String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.getTable(schemaName, tableName);
    }

    private Schema getSchema(String schemaName) {
        if (schemaName == null) {
            schemaName = "";
        }
        schemaName = schemaName.trim();
        for (Schema schema : this.database.getSchemas()) {
            String name = schema.getName();
            if (name == null || !name.equalsIgnoreCase(schemaName)) continue;
            return schema;
        }
        Schema schema = SQLSchemaFactory.eINSTANCE.createSchema();
        schema.setName(schemaName);
        this.database.getSchemas().add((Object)schema);
        return schema;
    }

    private BaseTable getTable(String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        tableName = tableName.trim();
        Schema schema = this.getSchema(schemaName);
        for (BaseTable table : schema.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        PersistentTable table = SQLTablesFactory.eINSTANCE.createPersistentTable();
        table.setName(tableName);
        schema.getTables().add((Object)table);
        return table;
    }

    private org.eclipse.wst.rdb.internal.models.sql.tables.Column getColumn(String schemaName, String tableName, String columnName) {
        BaseTable table = this.getTable(schemaName, tableName);
        if (columnName == null) {
            return null;
        }
        columnName = columnName.trim();
        for (org.eclipse.wst.rdb.internal.models.sql.tables.Column column : table.getColumns()) {
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        org.eclipse.wst.rdb.internal.models.sql.tables.Column column = SQLTablesFactory.eINSTANCE.createColumn();
        column.setName(columnName);
        table.getColumns().add((Object)column);
        return column;
    }

    private static int getJdbcType(PersistentAttribute pattribute) {
        IPersistenceModelAdapter modelAdapter = pattribute.getModelAdapter();
        if (modelAdapter instanceof JavaPersistentAttributeModelAdapter) {
            String[][] resolvedType;
            JavaPersistentAttributeModelAdapter jma = (JavaPersistentAttributeModelAdapter)modelAdapter;
            String typeName = Signature.getSignatureSimpleName((String)jma.getAttribute().getTypeSignature());
            try {
                resolvedType = jma.getAttribute().getJDTMember().getDeclaringType().resolveType(typeName);
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
            String fullyQualifiedTypeName = resolvedType == null ? typeName : String.valueOf(resolvedType[0][0]) + "." + typeName;
            return JdbcUtils.getJdbcTypeForClass(fullyQualifiedTypeName);
        }
        return 12;
    }

    public static void createDdl(PersistenceProject persistenceProject, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Creating database definition ...");
        ConnectionInfoWrapper conInfo = persistenceProject.getConnectionInfo();
        OrmDdlGenerator ddlGen = conInfo != null ? new OrmDdlGenerator(conInfo.getDatabaseName(), conInfo.getDatabaseProductVersion()) : new OrmDdlGenerator(null, null);
        monitor.subTask("Analyzing resources ...");
        ArrayList pFiles = ddlGen.computePersistenceFiles(persistenceProject);
        float workdone = 20.0f;
        monitor.worked(Math.round(workdone));
        monitor.subTask("Building persistence resources ...");
        for (PersistenceFile pFile : pFiles) {
            ddlGen.addBasicColumns(ddlGen, persistenceProject, pFile);
            monitor.worked(Math.round(workdone += (float)(40 / pFiles.size())));
        }
        for (PersistenceFile pFile : pFiles) {
            ddlGen.addRefColumns(ddlGen, persistenceProject, pFile);
            monitor.worked(Math.round(workdone += (float)(40 / pFiles.size())));
        }
        ddlGen.createDDL();
    }

    private ArrayList computePersistenceFiles(PersistenceProject persistenceProject) throws CoreException {
        ArrayList presources = new ArrayList(100);
        this.computePersistenceFiles(presources, (List)persistenceProject.getPersistenceResources());
        return presources;
    }

    private void computePersistenceFiles(List pfiles, List presources) throws CoreException {
        for (PersistenceResource resource : presources) {
            if (resource instanceof PersistenceContainer) {
                PersistenceContainer container = (PersistenceContainer)resource;
                this.computePersistenceFiles(pfiles, (List)container.getPersistenceResources());
                continue;
            }
            if (!(resource instanceof PersistenceFile)) continue;
            pfiles.add(resource);
        }
    }

    private void addBasicColumns(OrmDdlGenerator ddlGen, PersistenceProject persistenceProject, PersistenceFile resource) {
        for (PersistentType type : resource.getPersistentTypes()) {
            PersistentTypeFlavor flavor = type.getFlavor();
            Table ormTable = flavor.getTable();
            if (ormTable == null) break;
            BaseTable dbTable = ddlGen.getTable(ormTable.getCatalog(), ormTable.getSchema(), ormTable.getName());
            ArrayList<org.eclipse.wst.rdb.internal.models.sql.tables.Column> pkList = new ArrayList<org.eclipse.wst.rdb.internal.models.sql.tables.Column>(3);
            for (PersistentAttribute attribute : type.getPersistentAttributes()) {
                PersistentAttributeFlavor attributeFlavor = attribute.getFlavor();
                if (attributeFlavor instanceof ColumnPersistentAttributeFlavor) {
                    ColumnPersistentAttributeFlavor columnFlavor = (ColumnPersistentAttributeFlavor)attributeFlavor;
                    Column ormColumn = columnFlavor.getColumn();
                    org.eclipse.wst.rdb.internal.models.sql.tables.Column dbColumn = ddlGen.getColumn(ormTable.getSchema(), ormColumn.getTableName(), ormColumn.getName());
                    int jdbcType = OrmDdlGenerator.getJdbcType(attribute);
                    this.copyToDb(ormColumn, dbColumn, jdbcType);
                    if (!(columnFlavor instanceof Id)) continue;
                    pkList.add(dbColumn);
                    continue;
                }
                if (!(attributeFlavor instanceof SingleReferenceMapping)) continue;
                SingleReferenceMapping cfr_ignored_0 = (SingleReferenceMapping)attributeFlavor;
            }
            this.addPkToTable(ormTable, dbTable, ddlGen.dbDef, pkList);
        }
    }

    private void addRefColumns(OrmDdlGenerator ddlGen, PersistenceProject persistenceProject, PersistenceFile pFile) {
        block0: for (PersistentType type : pFile.getPersistentTypes()) {
            PersistentTypeFlavor flavor = type.getFlavor();
            Table ormTable = flavor.getTable();
            if (ormTable == null) break;
            ddlGen.getTable(ormTable.getCatalog(), ormTable.getSchema(), ormTable.getName());
            for (PersistentAttribute attribute : type.getPersistentAttributes()) {
                EStructuralFeature feature;
                MultiReferenceMapping mFlavor;
                String mappedBy;
                PersistentAttributeFlavor attributeFlavor = attribute.getFlavor();
                if (!(attributeFlavor instanceof ReferencePersistentAttributeFlavor)) continue;
                ReferencePersistentAttributeFlavor refFlavor = (ReferencePersistentAttributeFlavor)attributeFlavor;
                if (refFlavor instanceof MultiReferenceMapping && (mappedBy = (mFlavor = (MultiReferenceMapping)attributeFlavor).getMappedBy()) != null && mappedBy.trim().length() > 0) continue block0;
                if (!(refFlavor instanceof SingleReferenceMapping)) continue;
                SingleReferenceMapping sFlavor = (SingleReferenceMapping)attributeFlavor;
                JoinColumn joinCol = sFlavor.getJoinColumn();
                org.eclipse.wst.rdb.internal.models.sql.tables.Column dbColumn = ddlGen.getColumn(ormTable.getSchema(), joinCol.getTableName(), joinCol.getName());
                PersistentType targetType = pFile.resolvePersistentType(refFlavor.getTargetEntity());
                Table targetTable = targetType.getFlavor().getTable();
                org.eclipse.wst.rdb.internal.models.sql.tables.Column dbJoinColumn = ddlGen.getColumn(targetTable.getSchema(), targetTable.getName(), joinCol.getReferencedColumnName());
                dbColumn.setName(joinCol.getName());
                DataType joinType = dbJoinColumn.getDataType();
                PredefinedDataTypeDefinition typeDef = this.dbDef.getPredefinedDataTypeDefinition(joinType.getName());
                if (typeDef == null) continue;
                PredefinedDataType dataType = this.dbDef.getPredefinedDataType(typeDef);
                if (typeDef.isLengthSupported()) {
                    feature = dataType.eClass().getEStructuralFeature("length");
                    dataType.eSet(feature, dbJoinColumn.eGet(feature));
                } else if (typeDef.isPrecisionSupported()) {
                    feature = dataType.eClass().getEStructuralFeature("precision");
                    dataType.eSet(feature, dbJoinColumn.eGet(feature));
                }
                if (typeDef.isScaleSupported()) {
                    feature = dataType.eClass().getEStructuralFeature("scale");
                    dataType.eSet(feature, dbJoinColumn.eGet(feature));
                }
                dbColumn.setContainedType((SQLDataType)dataType);
            }
        }
    }

    public void copyToDb(Column ormColumn, org.eclipse.wst.rdb.internal.models.sql.tables.Column dbColumn, int jdbcType) {
        PredefinedDataTypeDefinition typeDef;
        dbColumn.setName(ormColumn.getName());
        String columnDefinition = ormColumn.getColumnDefinition();
        if (columnDefinition != null && columnDefinition.trim().length() > 0) {
            ValueExpressionDefault expression = SQLExpressionsFactoryImpl.eINSTANCE.createValueExpressionDefault();
            expression.setSQL(columnDefinition);
            dbColumn.setGenerateExpression((ValueExpression)expression);
        }
        dbColumn.setNullable(ormColumn.isNullable());
        List predefinedDataTypeDefinitions = this.dbDef.getPredefinedDataTypeDefinitionsByJDBCEnumType(jdbcType);
        if (predefinedDataTypeDefinitions != null && predefinedDataTypeDefinitions.size() > 0 && (typeDef = (PredefinedDataTypeDefinition)predefinedDataTypeDefinitions.get(0)) != null && this.dbDef != null) {
            EStructuralFeature feature;
            PredefinedDataType type = this.dbDef.getPredefinedDataType(typeDef);
            if (typeDef.isLengthSupported()) {
                feature = type.eClass().getEStructuralFeature("length");
                type.eSet(feature, (Object)new Integer(ormColumn.getLength()));
            } else if (typeDef.isPrecisionSupported()) {
                feature = type.eClass().getEStructuralFeature("precision");
                type.eSet(feature, (Object)new Integer(ormColumn.getLength()));
            }
            if (typeDef.isScaleSupported()) {
                feature = type.eClass().getEStructuralFeature("scale");
                type.eSet(feature, (Object)new Integer(ormColumn.getScale()));
            }
            dbColumn.setContainedType((SQLDataType)type);
        }
    }

    public void addPkToTable(Table ormTable, BaseTable table, DatabaseDefinition dbDef, List pkList) {
        if (!pkList.isEmpty()) {
            DataModelElementFactory factory = dbDef.getDataModelElementFactory();
            EClass primaryKeyClass = SQLConstraintsPackage.eINSTANCE.getPrimaryKey();
            PrimaryKey pk = (PrimaryKey)factory.create(primaryKeyClass);
            pk.setName(String.valueOf(ormTable.getName()) + "_pk");
            for (org.eclipse.wst.rdb.internal.models.sql.tables.Column dbColumn : pkList) {
                pk.getMembers().add((Object)dbColumn);
            }
            table.getConstraints().add((Object)pk);
        }
    }
}

