/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratedValueHolder;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmBasicMapping;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGeneratorContainer;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverterContainer;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkAccessType;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.nosql.eclipselink.core.context.orm.EclipseLinkOrmConvertibleMapping;
import org.eclipse.jpt.nosql.eclipselink.core.context.orm.OrmEclipseLinkConverterContainer;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkConvert;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkConverterContainerImpl;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkMutable;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkBasicMapping
extends AbstractOrmBasicMapping<XmlBasic>
implements EclipseLinkBasicMapping,
EclipseLinkOrmConvertibleMapping,
OrmEclipseLinkConverterContainer.Owner,
OrmGeneratedValueHolder {
    protected final OrmEclipseLinkMutable mutable = new OrmEclipseLinkMutable((OrmAttributeMapping)this);
    protected final OrmEclipseLinkConverterContainer converterContainer = this.buildConverterContainer();
    protected final OrmGeneratorContainer generatorContainer = this.buildGeneratorContainer();
    protected OrmGeneratedValue generatedValue = this.buildGeneratedValue();

    public OrmEclipseLinkBasicMapping(OrmPersistentAttribute parent, XmlBasic xmlMapping) {
        super(parent, (org.eclipse.jpt.jpa.core.resource.orm.XmlBasic)xmlMapping);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.mutable.synchronizeWithResourceModel();
        this.converterContainer.synchronizeWithResourceModel();
        this.generatorContainer.synchronizeWithResourceModel();
        this.syncGeneratedValue();
    }

    public void update() {
        super.update();
        this.mutable.update();
        this.converterContainer.update();
        this.generatorContainer.update();
        if (this.generatedValue != null) {
            this.generatedValue.update();
        }
    }

    protected String buildSpecifiedAttributeType() {
        return ((XmlBasic)this.xmlAttributeMapping).getAttributeType();
    }

    protected void setSpecifiedAttributeTypeInXml(String attributeType) {
        ((XmlBasic)this.xmlAttributeMapping).setAttributeType(attributeType);
    }

    @Override
    public EclipseLinkMutable getMutable() {
        return this.mutable;
    }

    @Override
    public OrmEclipseLinkConverterContainer getConverterContainer() {
        return this.converterContainer;
    }

    protected OrmEclipseLinkConverterContainer buildConverterContainer() {
        return new OrmEclipseLinkConverterContainerImpl((JpaContextNode)this, this, (XmlConverterContainer)this.xmlAttributeMapping);
    }

    @Override
    public int getNumberSupportedConverters() {
        return 1;
    }

    public OrmGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected OrmGeneratorContainer buildGeneratorContainer() {
        return this.getContextNodeFactory().buildOrmGeneratorContainer((JpaContextNode)this, (XmlGeneratorContainer)this.xmlAttributeMapping);
    }

    public Iterable<Generator> getGenerators() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getGenerators(), this.generatorContainer.getGenerators()});
    }

    public OrmGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    public OrmGeneratedValue addGeneratedValue() {
        if (this.generatedValue != null) {
            throw new IllegalStateException("generated value already exists: " + this.generatedValue);
        }
        XmlGeneratedValue xmlGeneratedValue = this.buildXmlGeneratedValue();
        OrmGeneratedValue value = this.buildGeneratedValue(xmlGeneratedValue);
        this.setGeneratedValue(value);
        ((XmlBasic)this.xmlAttributeMapping).setGeneratedValue(xmlGeneratedValue);
        return value;
    }

    protected XmlGeneratedValue buildXmlGeneratedValue() {
        return OrmFactory.eINSTANCE.createXmlGeneratedValue();
    }

    public void removeGeneratedValue() {
        if (this.generatedValue == null) {
            throw new IllegalStateException("generated value does not exist");
        }
        this.setGeneratedValue(null);
        ((XmlBasic)this.xmlAttributeMapping).setGeneratedValue(null);
    }

    protected void setGeneratedValue(OrmGeneratedValue value) {
        OrmGeneratedValue old = this.generatedValue;
        this.generatedValue = value;
        this.firePropertyChanged("generatedValue", old, value);
    }

    protected OrmGeneratedValue buildGeneratedValue() {
        XmlGeneratedValue xmlGeneratedValue = ((XmlBasic)this.xmlAttributeMapping).getGeneratedValue();
        return xmlGeneratedValue == null ? null : this.buildGeneratedValue(xmlGeneratedValue);
    }

    protected OrmGeneratedValue buildGeneratedValue(XmlGeneratedValue xmlGeneratedValue) {
        return this.getContextNodeFactory().buildOrmGeneratedValue((JpaContextNode)this, xmlGeneratedValue);
    }

    protected void syncGeneratedValue() {
        XmlGeneratedValue xmlGeneratedValue = ((XmlBasic)this.xmlAttributeMapping).getGeneratedValue();
        if (xmlGeneratedValue == null) {
            if (this.generatedValue != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.generatedValue != null && this.generatedValue.getXmlGeneratedValue() == xmlGeneratedValue) {
            this.generatedValue.synchronizeWithResourceModel();
        } else {
            this.setGeneratedValue(this.buildGeneratedValue(xmlGeneratedValue));
        }
    }

    protected Iterable<OrmConverter.Adapter> getConverterAdapters() {
        return IterableTools.insert((Object)OrmEclipseLinkConvert.Adapter.instance(), (Iterable)super.getConverterAdapters());
    }

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.converterContainer.createMoveTypeEdits(originalType, newPackage)});
    }

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.converterContainer.createRenamePackageEdits(originalPackage, newName)});
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.converterContainer.createRenameTypeEdits(originalType, newName)});
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttributeType(messages);
        if (this.generatedValue != null) {
            this.generatedValue.validate(messages, reporter);
        }
        this.generatorContainer.validate(messages, reporter);
    }

    protected void validateAttributeType(List<IMessage> messages) {
        if (this.isVirtualAccess()) {
            if (StringTools.isBlank((String)this.getAttributeType())) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_NO_ATTRIBUTE_TYPE_SPECIFIED", new String[]{this.getName()}, (JpaNode)this, this.getAttributeTypeTextRange()));
                return;
            }
            if (MappingTools.typeIsBasic((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedAttributeType())) {
                return;
            }
            if (this.getResolvedAttributeType() == null) {
                IType jdtType = JDTTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedAttributeType());
                if (jdtType == null) {
                    messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_TYPE_DOES_NOT_EXIST", new String[]{this.getFullyQualifiedAttributeType()}, (JpaNode)this, this.getAttributeTypeTextRange()));
                }
                return;
            }
        }
    }

    protected boolean isVirtualAccess() {
        return this.getPersistentAttribute().getAccess() == EclipseLinkAccessType.VIRTUAL;
    }

    protected TextRange getAttributeTypeTextRange() {
        return this.getValidationTextRange(((XmlBasic)this.xmlAttributeMapping).getAttributeTypeTextRange());
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.converterContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.generatorContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.generatedValue != null && (result = this.generatedValue.getCompletionProposals(pos)) != null) {
            return result;
        }
        if (this.attributeTypeTouches(pos)) {
            return this.getCandidateAttributeTypeNames();
        }
        return null;
    }

    protected boolean attributeTypeTouches(int pos) {
        return ((XmlBasic)this.xmlAttributeMapping).attributeTypeTouches(pos);
    }

    protected Iterable<String> getCandidateAttributeTypeNames() {
        return MappingTools.getAllBasicTypeNames();
    }
}

