/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConverterClassConverter;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEclipseLinkConverterClassConverter<A extends EclipseLinkNamedConverterAnnotation>
extends JavaEclipseLinkConverter<A>
implements EclipseLinkConverterClassConverter {
    private String converterClass;

    public JavaEclipseLinkConverterClassConverter(JpaContextNode parent, A converterAnnotation, String converterClass) {
        super(parent, converterAnnotation);
        this.converterClass = converterClass;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(this.getAnnotationConverterClass());
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        this.setAnnotationConverterClass(converterClass);
        this.setConverterClass_(converterClass);
    }

    protected void setConverterClass_(String converterClass) {
        String old = this.converterClass;
        this.converterClass = converterClass;
        this.firePropertyChanged("converterClass", old, converterClass);
    }

    protected abstract String getAnnotationConverterClass();

    protected abstract void setAnnotationConverterClass(String var1);

    protected boolean typeExists(String typeName) {
        return typeName != null && JDTTools.findType((IJavaProject)this.getJavaProject(), (String)typeName) != null;
    }

    protected boolean typeImplementsInterface(String typeName, String interfaceName) {
        return typeName != null && JDTTools.typeIsSubType((IJavaProject)this.getJavaProject(), (String)typeName, (String)interfaceName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConverterClass(messages);
    }

    protected void validateConverterClass(List<IMessage> messages) {
        if (this.converterClass == null) {
            return;
        }
        if (StringTools.isBlank((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", (JpaNode)this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassExists()) {
            this.addConverterClassDoesNotExistMessageTo(messages);
            return;
        }
        if (!this.converterClassImplementsInterface(this.getEclipseLinkConverterInterface())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, this.getEclipseLinkConverterInterfaceErrorMessage(), new String[]{this.getFullyQualifiedConverterClass()}, (JpaNode)this, this.getConverterClassTextRange()));
        }
    }

    protected void addConverterClassDoesNotExistMessageTo(List<IMessage> messages) {
        messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_EXISTS", new String[]{this.getFullyQualifiedConverterClass()}, (JpaNode)this, this.getConverterClassTextRange()));
    }

    protected abstract String getEclipseLinkConverterInterface();

    protected abstract String getEclipseLinkConverterInterfaceErrorMessage();

    protected boolean converterClassExists() {
        return this.typeExists(this.getFullyQualifiedConverterClass());
    }

    protected boolean converterClassImplementsInterface(String interfaceName) {
        return this.typeImplementsInterface(this.getFullyQualifiedConverterClass(), interfaceName);
    }

    protected TextRange getConverterClassTextRange() {
        return this.getValidationTextRange(this.getAnnotationConverterClassTextRange());
    }

    protected abstract TextRange getAnnotationConverterClassTextRange();

    @Override
    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return super.isEquivalentTo(node) && this.isEquivalentTo((EclipseLinkConverterClassConverter)node);
    }

    protected boolean isEquivalentTo(EclipseLinkConverterClassConverter converter) {
        return ObjectTools.equals((Object)this.getFullyQualifiedConverterClass(), (Object)converter.getFullyQualifiedConverterClass());
    }
}

