/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.context.persistence;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Customization;

public class CustomizationEntity
extends AbstractModel
implements Cloneable,
Serializable {
    private String name;
    private Customization parent;
    public static final String DESCRIPTOR_CUSTOMIZER_PROPERTY = "descriptorCustomizer";
    private String descriptorCustomizer;
    private static final long serialVersionUID = 1L;
    public static final Transformer<CustomizationEntity, String> NAME_TRANSFORMER = new NameTransformer();

    public CustomizationEntity(Customization parent, String name) {
        this(parent);
        this.initialize(name);
    }

    private CustomizationEntity(Customization parent) {
        this.parent = parent;
    }

    private void initialize(String name) {
        if (StringTools.isBlank((String)name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CustomizationEntity)) {
            return false;
        }
        CustomizationEntity customizer = (CustomizationEntity)o;
        return this.descriptorCustomizer == null ? customizer.descriptorCustomizer == null : this.descriptorCustomizer.equals(customizer.descriptorCustomizer);
    }

    public int hashCode() {
        return this.descriptorCustomizer == null ? 0 : this.descriptorCustomizer.hashCode();
    }

    public CustomizationEntity clone() {
        try {
            return (CustomizationEntity)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean isEmpty() {
        return this.descriptorCustomizer == null;
    }

    public boolean entityNameIsValid() {
        return !StringTools.isBlank((String)this.name);
    }

    public Customization getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptorCustomizer() {
        return this.descriptorCustomizer;
    }

    public void setDescriptorCustomizer(String descriptorCustomizer) {
        String old = this.descriptorCustomizer;
        this.descriptorCustomizer = descriptorCustomizer;
        this.firePropertyChanged(DESCRIPTOR_CUSTOMIZER_PROPERTY, old, descriptorCustomizer);
    }

    public void toString(StringBuilder sb) {
        sb.append("name: ");
        sb.append(this.name);
        sb.append(", descriptorCustomizer: ");
        sb.append(this.descriptorCustomizer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameTransformer
    extends TransformerAdapter<CustomizationEntity, String> {
        public String transform(CustomizationEntity entity) {
            return entity.getName();
        }
    }
}

