/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.caching;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.CacheType;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Caching;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheDefaultsComposite<T extends Caching>
extends Pane<T> {
    public CacheDefaultsComposite(Pane<T> subjectHolder, Composite container) {
        super(subjectHolder, container);
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, EclipseLinkUiMessages.CacheDefaultsComposite_groupTitle, 2, null);
    }

    protected void initializeLayout(Composite parent) {
        this.addLabel(parent, EclipseLinkUiMessages.PersistenceXmlCachingTab_defaultCacheTypeLabel);
        this.buildDefaultCacheTypeCombo(parent);
        this.addLabel(parent, EclipseLinkUiMessages.DefaultCacheSizeComposite_defaultCacheSize);
        this.addDefaultCacheSizeCombo(parent);
        TriStateCheckBox sharedCacheCheckBox = this.addTriStateCheckBoxWithDefault(parent, EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheDefaultLabel, this.buildDefaultSharedCacheHolder(), this.buildDefaultSharedCacheStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_CACHING_DEFAULT_SHARED);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        sharedCacheCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    protected EnumFormComboViewer<Caching, CacheType> buildDefaultCacheTypeCombo(Composite container) {
        return new EnumFormComboViewer<Caching, CacheType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("cacheTypeDefault");
            }

            protected CacheType[] getChoices() {
                return CacheType.values();
            }

            protected boolean sortChoices() {
                return false;
            }

            protected CacheType getDefaultValue() {
                return ((Caching)this.getSubject()).getDefaultCacheTypeDefault();
            }

            protected String displayString(CacheType value) {
                switch (value) {
                    case full: {
                        return EclipseLinkUiMessages.CacheTypeComposite_full;
                    }
                    case weak: {
                        return EclipseLinkUiMessages.CacheTypeComposite_weak;
                    }
                    case soft: {
                        return EclipseLinkUiMessages.CacheTypeComposite_soft;
                    }
                    case soft_weak: {
                        return EclipseLinkUiMessages.CacheTypeComposite_soft_weak;
                    }
                    case hard_weak: {
                        return EclipseLinkUiMessages.CacheTypeComposite_hard_weak;
                    }
                    case none: {
                        return EclipseLinkUiMessages.CacheTypeComposite_none;
                    }
                }
                throw new IllegalStateException();
            }

            protected CacheType getValue() {
                return ((Caching)this.getSubject()).getCacheTypeDefault();
            }

            protected void setValue(CacheType value) {
                ((Caching)this.getSubject()).setCacheTypeDefault(value);
            }

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_CACHING_DEFAULT_TYPE;
            }
        };
    }

    protected void addDefaultCacheSizeCombo(Composite container) {
        new IntegerCombo<Caching>((Pane)this, container){

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_CACHING_DEFAULT_SIZE;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Caching, Integer>(this.getSubjectHolder()){

                    protected Integer buildValue_() {
                        return ((Caching)this.subject).getDefaultCacheSizeDefault();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Caching, Integer>(this.getSubjectHolder(), new String[]{"cacheSizeDefault"}){

                    protected Integer buildValue_() {
                        return ((Caching)this.subject).getCacheSizeDefault();
                    }

                    protected void setValue_(Integer value) {
                        ((Caching)this.subject).setCacheSizeDefault(value);
                    }
                };
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<Caching, Boolean>(this.getSubjectHolder(), new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                return ((Caching)this.subject).getSharedCacheDefault();
            }

            protected void setValue_(Boolean value) {
                ((Caching)this.subject).setSharedCacheDefault(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultSharedCacheStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultDefaultSharedCacheHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlCachingTab_defaultSharedCacheDefaultLabel, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheDefaultLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<Caching, Boolean>(this.getSubjectHolder(), new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                if (((Caching)this.subject).getSharedCacheDefault() != null) {
                    return null;
                }
                return ((Caching)this.subject).getDefaultSharedCacheDefault();
            }
        };
    }
}

