/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.vorto.codegen.ui.handler.PopulateGeneratorsMenu;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.perspective.command.DeleteModelAction;
import org.eclipse.vorto.perspective.command.ProjectAction;
import org.eclipse.vorto.perspective.command.ShareModelAction;
import org.eclipse.vorto.perspective.dnd.ModelDropListenerFactory;
import org.eclipse.vorto.perspective.util.ImageUtil;
import org.eclipse.vorto.perspective.view.ILocalModelWorkspace;
import org.eclipse.vorto.perspective.view.ModelTreeViewer;
import org.eclipse.vorto.wizard.infomodel.InfomodelWizard;

public class InfomodelTreeViewer
extends ModelTreeViewer {
    public InfomodelTreeViewer(Composite parent, ILocalModelWorkspace localProjectBrowser) {
        super(parent, localProjectBrowser);
    }

    @Override
    public void init() {
        super.init();
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.treeViewer.addDropSupport(operations, transferTypes, ModelDropListenerFactory.infomodelViewPartDropListener((Viewer)this.treeViewer, this.localModelWorkspace));
    }

    @Override
    protected void initContextMenu() {
        final MenuManager menuMgr = new MenuManager("#PopupMenuIM");
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IModelElement model;
                if (!InfomodelTreeViewer.this.treeViewer.getStructuredSelection().isEmpty() && (model = (IModelElement)InfomodelTreeViewer.this.treeViewer.getStructuredSelection().getFirstElement()).getId().getModelType() == ModelType.InformationModel) {
                    MenuManager generatorMenuMgr = new MenuManager("Generate Code");
                    generatorMenuMgr.add((IContributionItem)new PopulateGeneratorsMenu());
                    menuMgr.add((IContributionItem)generatorMenuMgr);
                    menuMgr.add((IAction)ShareModelAction.newInstance(InfomodelTreeViewer.this.treeViewer, model));
                    menuMgr.add((IAction)DeleteModelAction.newInstance(InfomodelTreeViewer.this.localModelWorkspace, InfomodelTreeViewer.this.treeViewer, model));
                    menuMgr.add((IAction)new ProjectAction("New Mapping Model", ImageUtil.getImage("add_obj.gif"), InfomodelTreeViewer.this.treeViewer.getLocalModelWorkspace()){

                        @Override
                        public void doAction() {
                            InfomodelTreeViewer.this.openMappingWizard();
                        }
                    });
                }
                manager.add((IAction)new ProjectAction("New Information Model", ImageUtil.getImage("add_obj.gif"), InfomodelTreeViewer.this.treeViewer.getLocalModelWorkspace()){

                    @Override
                    public void doAction() {
                        WizardDialog wizardDialog = new WizardDialog((this).InfomodelTreeViewer.this.treeViewer.getControl().getShell(), (IWizard)new InfomodelWizard((this).InfomodelTreeViewer.this.localModelWorkspace.getProjectBrowser().getSelectedProject()));
                        if (wizardDialog.open() == 0) {
                            InfomodelTreeViewer.this.populate((this).InfomodelTreeViewer.this.localModelWorkspace.getProjectBrowser().getSelectedProject().getModelElementsByType(ModelType.InformationModel));
                        }
                    }
                });
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getControl().setMenu(menu);
    }

    @Override
    protected String getLabel() {
        return "Information Models";
    }
}

