/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.perspective.util.TreeViewerCallback;

public class TreeViewerTemplate {
    private TreeViewer treeViewer;

    public TreeViewerTemplate(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.init();
    }

    public void update(final TreeViewerCallback callback) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        callback.doUpdate(TreeViewerTemplate.this.treeViewer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private void init() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IModelElement modelElement;
                IStructuredSelection selection;
                if (event.getSelection().isEmpty()) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() > 0 && selection.getFirstElement() instanceof IModelElement && (modelElement = (IModelElement)selection.getFirstElement()).getModelFile() != null) {
                    TreeViewerTemplate.this.openFileInEditor(modelElement.getModelFile());
                }
            }
        });
    }

    protected void openFileInEditor(IFile fileToOpen) {
        if (fileToOpen.exists()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)fileToOpen);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("File not found for: " + fileToOpen);
        }
    }
}

