/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vorto.core.api.model.model.ModelType;

public class ImageUtil {
    private static final String BUNDLE_ICON_URL = "platform:/plugin/org.eclipse.vorto.core.ui/icons/";
    private static final String SHARED_DT = "dt.png";
    private static final String SHARED_FB = "fb.png";
    private static final String SHARED_IM = "im.png";
    private static Map<ModelType, Image> modelImageMap = ImageUtil.getImageMap();

    private static Map<ModelType, Image> getImageMap() {
        HashMap<ModelType, Image> imageMap = new HashMap<ModelType, Image>();
        imageMap.put(ModelType.InformationModel, ImageUtil.getImage(SHARED_IM));
        imageMap.put(ModelType.Functionblock, ImageUtil.getImage(SHARED_FB));
        imageMap.put(ModelType.Datatype, ImageUtil.getImage(SHARED_DT));
        return imageMap;
    }

    public static Image getImage(String imageFileName) {
        URL url = null;
        try {
            url = new URL(BUNDLE_ICON_URL + imageFileName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("URL to datatype model image is not correct!", e);
        }
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    public static Image getImageForModelType(ModelType modelType) {
        return modelImageMap.get(modelType);
    }
}

