/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.api;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.vorto.codegen.api.Generated;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class DatatypeGeneratorTask
implements ICodeGeneratorTask<InformationModel> {
    private IFileTemplate<Entity> entityTemplate;
    private IFileTemplate<Enum> enumTemplate;

    public DatatypeGeneratorTask(IFileTemplate<Entity> entityTemplate, IFileTemplate<Enum> enumTemplate) {
        this.entityTemplate = entityTemplate;
        this.enumTemplate = enumTemplate;
    }

    @Override
    public void generate(InformationModel ctx, InvocationContext context, IGeneratedWriter writer) {
        HashSet<Type> allTypesUsedInModel = new HashSet<Type>();
        for (FunctionblockProperty prop : ctx.getProperties()) {
            allTypesUsedInModel.addAll(DatatypeGeneratorTask.getTypes(prop.getType()));
        }
        for (Type type : allTypesUsedInModel) {
            if (type instanceof Entity) {
                writer.write(new Generated(this.entityTemplate.getFileName((Entity)type), this.entityTemplate.getPath((Entity)type), this.entityTemplate.getContent((Entity)type, context)));
                continue;
            }
            if (!(type instanceof Enum)) continue;
            writer.write(new Generated(this.enumTemplate.getFileName((Enum)type), this.enumTemplate.getPath((Enum)type), this.enumTemplate.getContent((Enum)type, context)));
        }
    }

    private static Set<Type> getTypes(FunctionblockModel model) {
        LinkedHashSet<Type> allTypes = new LinkedHashSet<Type>();
        TreeIterator iterator = model.eAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            if (current instanceof RefParam) {
                DatatypeGeneratorTask.addTypeAndReferences(((RefParam)current).getType(), allTypes);
                continue;
            }
            if (current instanceof ReturnObjectType) {
                DatatypeGeneratorTask.addTypeAndReferences(((ReturnObjectType)current).getReturnType(), allTypes);
                continue;
            }
            if (!(current instanceof ObjectPropertyType)) continue;
            DatatypeGeneratorTask.addTypeAndReferences(((ObjectPropertyType)current).getType(), allTypes);
        }
        return allTypes;
    }

    private static void addTypeAndReferences(Type type, Set<Type> container) {
        if (!container.contains(type)) {
            container.add(type);
            Set<Type> references = DatatypeGeneratorTask.getTypesOfType(type, container);
            container.addAll(references);
        }
    }

    private static Set<Type> getTypesOfType(Type type, Set<Type> container) {
        TreeIterator iterator = type.eAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            if (!(current instanceof ObjectPropertyType) || container.contains(current)) continue;
            container.add(((ObjectPropertyType)current).getType());
            Set<Type> moreTypes = DatatypeGeneratorTask.getTypesOfType(((ObjectPropertyType)current).getType(), container);
            container.addAll(moreTypes);
        }
        return container;
    }
}

