/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard.mapping;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.wizard.ModelBaseWizardPage;

public class MappingModellWizardPage
extends ModelBaseWizardPage {
    private static final String DEFAULT_VERSION = "1.0.0";
    private static final String DEFAULT_DESCRIPTION = "Mapping model for ";
    private static final String DEFAULT_MAPPINGMODEL_NAME = "NewMapping";
    private Text txtPlatform;

    protected MappingModellWizardPage(String pageName, IModelProject modelProject) {
        super(pageName, modelProject);
    }

    @Override
    protected void decorate(Composite parent) {
        this.txtPlatform = this.newLabeledText(parent, "Platform:", 2048, this.newTxtGridData(400, null), this.modificationListener);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.txtPlatform.setText(this.getDefaultTargetPlatform());
    }

    @Override
    protected boolean validateProject() {
        boolean result = super.validateProject();
        String platform = this.txtPlatform.getText();
        result &= !this.ifModelExist(this.getModelId(), "Mapping model already exists");
        return result &= this.validateStrExist(platform, "Target Platform must be provided.");
    }

    private boolean ifModelExist(ModelId modelId, String errorMessage) {
        if (this.getModelProject().exists(modelId)) {
            this.setErrorMessage(errorMessage);
            return true;
        }
        return false;
    }

    protected String getTargetPlatform() {
        return this.txtPlatform.getText();
    }

    @Override
    protected String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    @Override
    protected String getDefaultDescription() {
        return DEFAULT_DESCRIPTION;
    }

    @Override
    protected String getDefaultModelName() {
        return DEFAULT_MAPPINGMODEL_NAME;
    }

    @Override
    protected String getDefaultNamespace() {
        return "com.mycompany.mapping";
    }

    @Override
    protected String getGroupTitle() {
        return "Mapping Model Details";
    }

    @Override
    protected String getModelLabel() {
        return "Mapping Model Name:";
    }

    protected String getDefaultTargetPlatform() {
        return "myplatform";
    }

    public ModelId getModelId() {
        return this.getModelId(ModelType.Mapping);
    }
}

