/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pair;

public class PropertyConstraintMappingValidation {
    private String errorMsg = "Constraint cannot apply on this property's datatype";
    private final String[] intervalArr = new String[]{"MAX", "MIN", "SCALING"};
    private final String[] strArr = new String[]{"STRLEN", "REGEX"};
    private final String[] mimeArr = new String[]{"MIMETYPE"};
    private final String[] byteArr = (String[])Conversions.unwrapArray((Object)Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)this.intervalArr)), (Iterable)((Iterable)Conversions.doWrapArray((Object)this.mimeArr))), String.class);
    private final String[] empty = new String[0];
    private final HashMap<String, String[]> valueTypeMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"int", (Object)this.intervalArr), Pair.of((Object)"byte", (Object)this.byteArr), Pair.of((Object)"float", (Object)this.intervalArr), Pair.of((Object)"long", (Object)this.intervalArr), Pair.of((Object)"short", (Object)this.intervalArr), Pair.of((Object)"double", (Object)this.intervalArr), Pair.of((Object)"dateTime", (Object)this.intervalArr), Pair.of((Object)"string", (Object)this.strArr), Pair.of((Object)"boolean", (Object)this.empty), Pair.of((Object)"base64Binary", (Object)this.mimeArr)});

    public final boolean checkPropertyConstraints(PrimitiveType type, Constraint cons) {
        boolean _xblockexpression = false;
        String _literal = type.getLiteral();
        String[] arr = this.valueTypeMap.get(_literal);
        boolean _or = false;
        boolean _equals = Objects.equal((Object)arr, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _not;
            String[] _converted_arr = arr;
            ConstraintIntervalType _type = cons.getType();
            String _literal_1 = _type.getLiteral();
            boolean _contains = ((List)Conversions.doWrapArray((Object)_converted_arr)).contains(_literal_1);
            _or = _not = !_contains;
        }
        if (_or) {
            this.setErrorMessage("Constraint cannot apply on this property's datatype");
            return false;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private String setErrorMessage(String err) {
        this.errorMsg = err;
        return this.errorMsg;
    }
}

