/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.vorto.core.ui.IMessageDisplay;

public class DefaultMessageDisplay
implements IMessageDisplay {
    private static DefaultMessageDisplay fDefault = null;
    private String fTitle = null;
    private static MessageConsole fMessageConsole = null;
    private static Color warningColor;
    private static Color infoColor;
    private static Color errorColor;
    private static Color successColor;
    private static final String SEPERATOR = "------------------------------------------------------------------------";

    private DefaultMessageDisplay(String messageTitle) {
        this.fTitle = messageTitle;
        Display display = Display.getDefault();
        infoColor = display.getSystemColor(2);
        errorColor = display.getSystemColor(3);
        successColor = display.getSystemColor(6);
        warningColor = display.getSystemColor(9);
    }

    public static DefaultMessageDisplay getDefault() {
        if (fDefault == null) {
            fDefault = new DefaultMessageDisplay(" Vorto ");
        }
        return fDefault;
    }

    protected void println(final String msg, final MSG_KIND msgKind) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String msgWithMarker;
                if (msg == null) {
                    return;
                }
                IViewPart consoleViewPart = DefaultMessageDisplay.this.displayConsoleView();
                if (consoleViewPart == null) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)msg);
                    return;
                }
                switch (msgKind) {
                    case INFO: {
                        msgWithMarker = "[INFO] " + msg;
                        break;
                    }
                    case ERROR: {
                        msgWithMarker = "[ERROR] " + msg;
                        break;
                    }
                    case SUCCESS: {
                        msgWithMarker = "[SUCCESS] " + msg;
                        break;
                    }
                    case WARNING: {
                        msgWithMarker = "[WARNING] " + msg;
                        break;
                    }
                    default: {
                        msgWithMarker = msg;
                    }
                }
                try {
                    DefaultMessageDisplay.this.getNewMessageConsoleStream(msgKind).write(msgWithMarker);
                    DefaultMessageDisplay.this.getNewMessageConsoleStream(msgKind).write(10);
                    if (msgKind == MSG_KIND.ERROR) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)consoleViewPart);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void displayError(String msg) {
        this.println(msg, MSG_KIND.ERROR);
    }

    @Override
    public void displaySuccess(String msg) {
        this.println(msg, MSG_KIND.SUCCESS);
    }

    @Override
    public void displayWarning(String msg) {
        this.println(msg, MSG_KIND.WARNING);
    }

    @Override
    public void display(String msg) {
        this.println(msg, MSG_KIND.INFO);
    }

    @Override
    public void clear() {
        IDocument document = this.getMessageConsole().getDocument();
        if (document != null) {
            document.set("");
        }
    }

    @Override
    public void displayNewLine() {
        this.println(SEPERATOR, MSG_KIND.INFO);
    }

    public IViewPart displayConsoleView() {
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                return activePage.showView("org.eclipse.ui.console.ConsoleView", null, 2);
            }
        }
        catch (PartInitException partInitException) {
            throw new RuntimeException("Cannot open console view");
        }
        return null;
    }

    public IOConsoleOutputStream getNewMessageConsoleStream(MSG_KIND msgKind) {
        Color color = null;
        switch (msgKind) {
            case INFO: {
                color = infoColor;
                break;
            }
            case ERROR: {
                color = errorColor;
                break;
            }
            case SUCCESS: {
                color = successColor;
                break;
            }
            case WARNING: {
                color = warningColor;
                break;
            }
            default: {
                color = infoColor;
            }
        }
        IOConsoleOutputStream msgConsoleStream = this.getMessageConsole().newOutputStream();
        msgConsoleStream.setColor(color);
        return msgConsoleStream;
    }

    private MessageConsole getMessageConsole() {
        if (fMessageConsole == null) {
            this.createMessageConsoleStream(this.fTitle);
        }
        return fMessageConsole;
    }

    private void createMessageConsoleStream(String title) {
        DefaultMessageDisplay.initalize(title);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fMessageConsole});
    }

    private static void initalize(String title) {
        fMessageConsole = new MessageConsole(title, null);
    }

    @Override
    public void displayError(Throwable cause) {
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        this.println(sw.toString(), MSG_KIND.ERROR);
    }

    protected static enum MSG_KIND {
        ERROR,
        WARNING,
        INFO,
        SUCCESS;

    }
}

