/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.tasks;

import com.google.common.base.Objects;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.vorto.codegen.api.Generated;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.ui.filewrite.FileWriteContext;
import org.eclipse.vorto.codegen.ui.filewrite.FileWritingStrategyFactory;
import org.eclipse.vorto.codegen.ui.filewrite.IFileWritingStrategy;
import org.eclipse.vorto.core.ui.IMessageDisplay;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ProjectFileOutputter
implements IGeneratedWriter {
    private IProject project = null;
    private IFileWritingStrategy strategy;

    public ProjectFileOutputter(IProject project) {
        this.project = project;
    }

    public void write(Generated generated) {
        try {
            String _fileName;
            boolean _notEquals_1;
            boolean _notEquals;
            IFolder folder = null;
            String _folderPath = generated.getFolderPath();
            boolean bl = _notEquals = !Objects.equal((Object)_folderPath, null);
            if (_notEquals) {
                IFolder _createProjectFolders;
                String _folderPath_1 = generated.getFolderPath();
                folder = _createProjectFolders = this.createProjectFolders(_folderPath_1);
            }
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_fileName = generated.getFileName()), null);
            if (_notEquals_1) {
                boolean _notEquals_2;
                IFile generatedFile = null;
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)folder, null);
                if (_notEquals_2) {
                    IFile _file;
                    String _fileName_1 = generated.getFileName();
                    generatedFile = _file = folder.getFile(_fileName_1);
                } else {
                    IFile _file_1;
                    String _fileName_2 = generated.getFileName();
                    generatedFile = _file_1 = this.project.getFile(_fileName_2);
                }
                IFileWritingStrategy _fileWritingStrategy = this.getFileWritingStrategy();
                byte[] _content = generated.getContent();
                String _string = new String(_content, "UTF-8");
                FileWriteContext _fileWriteContext = new FileWriteContext(_string);
                _fileWritingStrategy.writeFile(_fileWriteContext, generatedFile);
                IMessageDisplay _messageDisplay = MessageDisplayFactory.getMessageDisplay();
                IPath _location = generatedFile.getLocation();
                File _file_2 = _location.toFile();
                String _path = _file_2.getPath();
                String _plus = "Generated file " + _path;
                _messageDisplay.display(_plus);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ioEx = (Exception)_t;
                IMessageDisplay _messageDisplay_1 = MessageDisplayFactory.getMessageDisplay();
                String _message = ioEx.getMessage();
                String _plus_1 = "File Generation failed !" + _message;
                _messageDisplay_1.displayError(_plus_1);
                throw new RuntimeException("Generated resource " + generated + " could not be written", ioEx);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private IFolder createProjectFolders(String folderPath) {
        try {
            boolean _not;
            IFolder folder = this.project.getFolder(folderPath);
            boolean _exists = folder.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                IFolder _folder;
                IPath _location = folder.getLocation();
                File _file = _location.toFile();
                boolean foldersCreated = _file.mkdirs();
                if (!foldersCreated) {
                    IMessageDisplay _messageDisplay = MessageDisplayFactory.getMessageDisplay();
                    IPath _location_1 = folder.getLocation();
                    File _file_1 = _location_1.toFile();
                    String _path = _file_1.getPath();
                    String _plus = "Folders not created at " + _path;
                    _messageDisplay.displayWarning(_plus);
                } else {
                    IMessageDisplay _messageDisplay_1 = MessageDisplayFactory.getMessageDisplay();
                    IPath _location_2 = folder.getLocation();
                    File _file_2 = _location_2.toFile();
                    String _path_1 = _file_2.getPath();
                    String _plus_1 = "Folders created at " + _path_1;
                    _messageDisplay_1.display(_plus_1);
                }
                folder.refreshLocal(1, null);
                folder = _folder = this.project.getFolder(folderPath);
            }
            return folder;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IFileWritingStrategy getFileWritingStrategy() {
        IFileWritingStrategy _xblockexpression = null;
        boolean _equals = Objects.equal((Object)this.strategy, null);
        if (_equals) {
            IFileWritingStrategy _genFileStrategy;
            FileWritingStrategyFactory _instance = FileWritingStrategyFactory.getInstance();
            this.strategy = _genFileStrategy = _instance.getGenFileStrategy();
        }
        _xblockexpression = this.strategy;
        return _xblockexpression;
    }
}

