/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.perspective.contentprovider.DefaultTreeModelContentProvider;
import org.eclipse.vorto.perspective.labelprovider.DefaultTreeModelLabelProvider;
import org.eclipse.vorto.perspective.view.ILocalModelWorkspace;
import org.eclipse.vorto.perspective.view.ModelProjectTreeViewer;
import org.eclipse.vorto.wizard.mapping.MappingModelWizard;

public abstract class ModelTreeViewer {
    protected ModelProjectTreeViewer treeViewer;
    protected ILocalModelWorkspace localModelWorkspace;

    public ModelTreeViewer(Composite parent, ILocalModelWorkspace localModelWorkspace) {
        this.treeViewer = this.createTreeViewer(parent, localModelWorkspace);
        this.localModelWorkspace = localModelWorkspace;
        this.init();
        this.initContextMenu();
    }

    protected abstract String getLabel();

    protected abstract void initContextMenu();

    private ModelProjectTreeViewer createTreeViewer(Composite parent, ILocalModelWorkspace localModelBrowser) {
        Composite composite = new Composite(parent, 2048);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setBackground(new Color((Device)Display.getCurrent(), 58, 90, 130));
        label.setForeground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        label.setText(this.getLabel());
        FormData lblFormData = new FormData();
        lblFormData.top = new FormAttachment(0, 0);
        lblFormData.left = new FormAttachment(0, 0);
        lblFormData.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)lblFormData);
        ModelProjectTreeViewer treeViewer = new ModelProjectTreeViewer(composite, 772, localModelBrowser);
        FormData viewerFormData = new FormData();
        viewerFormData.top = new FormAttachment((Control)label, 10);
        viewerFormData.left = new FormAttachment(0, 0);
        viewerFormData.right = new FormAttachment(100, 0);
        viewerFormData.bottom = new FormAttachment(100, 0);
        treeViewer.getTree().setLayoutData((Object)viewerFormData);
        treeViewer.setContentProvider((IContentProvider)new DefaultTreeModelContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DefaultTreeModelLabelProvider());
        treeViewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        return treeViewer;
    }

    public void populate(Collection<IModelElement> modelElements) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(this.newViewUpdateRunnable(this.treeViewer, modelElements));
        }
    }

    private Runnable newViewUpdateRunnable(final ModelProjectTreeViewer treeViewer, final Collection<IModelElement> modelElements) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    treeViewer.setInput(modelElements);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected void openMappingWizard() {
        IModelElement firstElement = (IModelElement)this.treeViewer.getStructuredSelection().getFirstElement();
        ModelId modelId = firstElement.getId();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)new MappingModelWizard(this.localModelWorkspace.getProjectBrowser().getSelectedProject(), modelId));
        dialog.create();
        dialog.open();
    }

    protected void init() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IModelElement modelElement;
                IStructuredSelection selection;
                if (event.getSelection().isEmpty()) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() > 0 && selection.getFirstElement() instanceof IModelElement && (modelElement = (IModelElement)selection.getFirstElement()).getModelFile() != null) {
                    ModelTreeViewer.this.openFileInEditor(modelElement.getModelFile());
                }
            }
        });
        this.treeViewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ModelTreeViewer.this.localModelWorkspace.setFocus(ModelTreeViewer.this.treeViewer);
            }
        });
    }

    private void openFileInEditor(IFile fileToOpen) {
        if (fileToOpen.exists()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)fileToOpen);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("File not found for: " + fileToOpen);
        }
    }
}

