/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.DatatypeFactory;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyAttribute;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockFactory;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;

public class ModelConversionUtils {
    public static Model convertToFlatHierarchy(Model model) {
        if (model instanceof FunctionblockModel && ((FunctionblockModel)model).getSuperType() != null) {
            return ModelConversionUtils.convertToFlatHierarchy((FunctionblockModel)model);
        }
        return model;
    }

    public static FunctionblockModel convertToFlatHierarchy(FunctionblockModel fbm) {
        FunctionBlock fb = fbm.getFunctionblock();
        List<Property> configproperties = ModelConversionUtils.getFlatConfigProperties(fbm);
        List<Property> statusProperties = ModelConversionUtils.getFlatStatusProperties(fbm);
        ArrayList<Property> allProperties = new ArrayList<Property>();
        allProperties.addAll(configproperties);
        allProperties.addAll(statusProperties);
        if (fbm.getSuperType() != null) {
            ModelConversionUtils.removeSuperTypeModelReference(fbm);
        }
        allProperties.stream().filter(p -> p.getType() instanceof ObjectPropertyType).forEach(p -> ModelConversionUtils.createReference(fbm, (ObjectPropertyType)p.getType()));
        Status status = FunctionblockFactory.eINSTANCE.createStatus();
        status.getProperties().addAll(statusProperties);
        fb.setStatus(status);
        Configuration configuration = FunctionblockFactory.eINSTANCE.createConfiguration();
        configuration.getProperties().addAll(configproperties);
        fb.setConfiguration(configuration);
        List<Operation> operations = ModelConversionUtils.getFlatOperations(fbm);
        fb.getOperations().clear();
        fb.getOperations().addAll(operations);
        return fbm;
    }

    private static void removeSuperTypeModelReference(FunctionblockModel fbm) {
        Iterator iter = fbm.getReferences().iterator();
        while (iter.hasNext()) {
            ModelReference reference = (ModelReference)iter.next();
            ModelReference superTypeReference = ModelIdFactory.newInstance(fbm.getSuperType()).asModelReference();
            if (!EcoreUtil.equals((EObject)superTypeReference, (EObject)reference)) continue;
            iter.remove();
        }
    }

    private static void createReference(FunctionblockModel fbm, ObjectPropertyType type) {
        ModelReference reference = ModelFactory.eINSTANCE.createModelReference();
        reference.setImportedNamespace(String.valueOf(type.getType().getNamespace()) + "." + type.getType().getName());
        reference.setVersion(type.getType().getVersion());
        fbm.getReferences().add((Object)reference);
    }

    private static List<Operation> getFlatOperations(FunctionblockModel fbm) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        TreeIterator iter = fbm.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof Operation)) continue;
            operations.add((Operation)obj);
        }
        if (fbm.getSuperType() != null) {
            operations.addAll(ModelConversionUtils.getFlatOperations(fbm.getSuperType()));
        }
        return operations;
    }

    public static InformationModel convertToFlatHierarchy(InformationModel infomodel) {
        for (FunctionblockProperty fbProperty : infomodel.getProperties()) {
            FunctionblockModel fbm = fbProperty.getType();
            fbProperty.setType(ModelConversionUtils.convertToFlatHierarchy(fbm));
            if (fbProperty.getExtendedFunctionBlock() == null || fbProperty.getExtendedFunctionBlock().getStatus() == null) continue;
            for (Property extendedProperty : fbProperty.getExtendedFunctionBlock().getStatus().getProperties()) {
                Optional<Property> baseProperty = fbm.getFunctionblock().getStatus().getProperties().stream().filter(p -> p.getName().equals(extendedProperty.getName())).findFirst();
                if (!baseProperty.isPresent()) continue;
                baseProperty.get().setConstraintRule(extendedProperty.getConstraintRule());
            }
        }
        return infomodel;
    }

    private static List<Property> getFlatConfigProperties(FunctionblockModel fbm) {
        BasicEList properties = new BasicEList();
        TreeIterator iter = fbm.eAllContents();
        while (iter.hasNext()) {
            ObjectPropertyType objectType;
            Property property;
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof Property) || !((property = (Property)obj).eContainer() instanceof Configuration)) continue;
            properties.add((Object)ModelConversionUtils.copyProperty(property));
            if (!(property.getType() instanceof ObjectPropertyType) || !((objectType = (ObjectPropertyType)property.getType()).getType() instanceof Entity)) continue;
            Entity entity = (Entity)((ObjectPropertyType)property.getType()).getType();
            EList<Property> entityProperties = ModelConversionUtils.getFlatProperties(entity);
            entity.getProperties().addAll(entityProperties);
            if (entity.getSuperType() != null) {
                ModelConversionUtils.removeSuperTypeModelReference(entity);
            }
            entity.getProperties().stream().filter(p -> p.getType() instanceof ObjectPropertyType).forEach(p -> ModelConversionUtils.createReference(entity, (ObjectPropertyType)p.getType()));
        }
        if (fbm.getSuperType() != null) {
            properties.addAll(ModelConversionUtils.getFlatConfigProperties(fbm.getSuperType()));
        }
        return properties;
    }

    private static List<Property> getFlatStatusProperties(FunctionblockModel fbm) {
        BasicEList properties = new BasicEList();
        TreeIterator iter = fbm.eAllContents();
        while (iter.hasNext()) {
            ObjectPropertyType objectType;
            Property property;
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof Property) || !((property = (Property)obj).eContainer() instanceof Status)) continue;
            properties.add((Object)ModelConversionUtils.copyProperty(property));
            if (!(property.getType() instanceof ObjectPropertyType) || !((objectType = (ObjectPropertyType)property.getType()).getType() instanceof Entity)) continue;
            Entity entity = (Entity)((ObjectPropertyType)property.getType()).getType();
            EList<Property> entityProperties = ModelConversionUtils.getFlatProperties(entity);
            entity.getProperties().addAll(entityProperties);
            if (entity.getSuperType() != null) {
                ModelConversionUtils.removeSuperTypeModelReference(entity);
            }
            entity.getProperties().stream().filter(p -> p.getType() instanceof ObjectPropertyType).forEach(p -> ModelConversionUtils.createReference(entity, (ObjectPropertyType)p.getType()));
        }
        if (fbm.getSuperType() != null) {
            properties.addAll(ModelConversionUtils.getFlatStatusProperties(fbm.getSuperType()));
        }
        return properties;
    }

    private static Property copyProperty(Property property) {
        Property newProperty = DatatypeFactory.eINSTANCE.createProperty();
        newProperty.setName(property.getName());
        newProperty.setPresence(property.getPresence());
        newProperty.setDescription(property.getDescription());
        if (property.getType() instanceof PrimitivePropertyType) {
            PrimitivePropertyType newPrimitiveType = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
            PrimitivePropertyType oldPrimitiveType = (PrimitivePropertyType)property.getType();
            newPrimitiveType.setType(oldPrimitiveType.getType());
            newProperty.setType(newPrimitiveType);
        } else if (property.getType() instanceof ObjectPropertyType) {
            ObjectPropertyType newObjectType = DatatypeFactory.eINSTANCE.createObjectPropertyType();
            ObjectPropertyType oldObjectType = (ObjectPropertyType)property.getType();
            newObjectType.setType(oldObjectType.getType());
            newProperty.setType(newObjectType);
        }
        EList<PropertyAttribute> oldPropertyAtributeList = property.getPropertyAttributes();
        BasicEList newPropertyAtributeList = new BasicEList();
        for (PropertyAttribute oldProp : oldPropertyAtributeList) {
            PropertyAttribute newPropertyAtribute;
            if (oldProp instanceof BooleanPropertyAttribute) {
                newPropertyAtribute = DatatypeFactory.eINSTANCE.createBooleanPropertyAttribute();
                newPropertyAtribute.setType(((BooleanPropertyAttribute)oldProp).getType());
                newPropertyAtribute.setValue(((BooleanPropertyAttribute)oldProp).isValue());
                newPropertyAtributeList.add((Object)newPropertyAtribute);
                continue;
            }
            newPropertyAtribute = DatatypeFactory.eINSTANCE.createEnumLiteralPropertyAttribute();
            newPropertyAtribute.setType(((EnumLiteralPropertyAttribute)oldProp).getType());
            newPropertyAtribute.setValue(((EnumLiteralPropertyAttribute)oldProp).getValue());
            newPropertyAtributeList.add((Object)newPropertyAtribute);
        }
        newProperty.getPropertyAttributes().addAll((Collection)newPropertyAtributeList);
        return newProperty;
    }

    private static void removeSuperTypeModelReference(Entity entity) {
        Iterator iter = entity.getReferences().iterator();
        while (iter.hasNext()) {
            ModelReference reference = (ModelReference)iter.next();
            ModelReference superTypeReference = ModelIdFactory.newInstance(entity.getSuperType()).asModelReference();
            if (!EcoreUtil.equals((EObject)superTypeReference, (EObject)reference)) continue;
            iter.remove();
        }
    }

    private static void createReference(Entity entity, ObjectPropertyType type) {
        ModelReference reference = ModelFactory.eINSTANCE.createModelReference();
        reference.setImportedNamespace(String.valueOf(type.getType().getNamespace()) + "." + type.getType().getName());
        reference.setVersion(type.getType().getVersion());
        entity.getReferences().add((Object)reference);
    }

    private static EList<Property> getFlatProperties(Entity entity) {
        BasicEList properties = new BasicEList();
        TreeIterator iter = entity.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof Property)) continue;
            Property property = (Property)obj;
            properties.add((Object)ModelConversionUtils.copyProperty(property));
        }
        if (entity.getSuperType() != null) {
            properties.addAll(ModelConversionUtils.getFlatProperties(entity.getSuperType()));
        }
        return properties;
    }
}

